/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.settings.NewSMTTranslationSettings;
import de.uka.ilkd.key.smt.newsmt2.SMTHandlerProperty;
import de.uka.ilkd.key.smt.newsmt2.SMTHandlerPropertyVisitor;
import de.uka.ilkd.key.smt.newsmt2.SMTHandlerServices;
import de.uka.ilkd.key.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

class NewTranslationOptions
extends SettingsPanel
implements SettingsProvider {
    private final List<JComponent> components = new ArrayList<JComponent>();

    public NewTranslationOptions() {
        this.setHeaderText(this.getDescription());
        this.makeComponents();
    }

    private void makeComponents() {
        try {
            Collection properties = SMTHandlerServices.getInstance().getSMTProperties();
            for (SMTHandlerProperty property : properties) {
                JComponent comp = (JComponent)property.accept((SMTHandlerPropertyVisitor)new ComCreationVisitor(), null);
                comp.putClientProperty("smtProperty", property);
                this.components.add(comp);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getDescription() {
        return "SMT Translation";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        NewSMTTranslationSettings newSMTSettings = SettingsManager.getNewSmtSettings(window);
        SetVisitor visitor = new SetVisitor();
        for (JComponent component : this.components) {
            SMTHandlerProperty prop = (SMTHandlerProperty)component.getClientProperty("smtProperty");
            String id = prop.getIdentifier();
            String val = newSMTSettings.get(id);
            if (val == null) continue;
            prop.accept((SMTHandlerPropertyVisitor)visitor, (Object)new Pair((Object)val, (Object)component));
        }
        return this;
    }

    @Override
    public void applySettings(MainWindow window) {
        NewSMTTranslationSettings newSMTSettings = SettingsManager.getNewSmtSettings(window);
        ApplyVisitor visitor = new ApplyVisitor(newSMTSettings);
        for (JComponent component : this.components) {
            SMTHandlerProperty prop = (SMTHandlerProperty)component.getClientProperty("smtProperty");
            prop.accept((SMTHandlerPropertyVisitor)visitor, (Object)component);
        }
    }

    private class ApplyVisitor
    implements SMTHandlerPropertyVisitor<JComponent, Void> {
        private final NewSMTTranslationSettings settings;

        public ApplyVisitor(NewSMTTranslationSettings newSMTSettings) {
            this.settings = newSMTSettings;
        }

        public Void visit(SMTHandlerProperty.EnumProperty<?> enumProp, JComponent arg) {
            String val = ((JComboBox)arg).getSelectedItem().toString();
            this.settings.put(enumProp.getIdentifier(), val);
            return null;
        }

        public Void visit(SMTHandlerProperty.IntegerProperty integerProp, JComponent arg) {
            String val = ((JTextField)arg).getText();
            this.settings.put(integerProp.getIdentifier(), val);
            return null;
        }

        public Void visit(SMTHandlerProperty.BooleanProperty booleanProp, JComponent arg) {
            String val = ((JCheckBox)arg).isSelected() ? "true" : "false";
            this.settings.put(booleanProp.getIdentifier(), val);
            return null;
        }

        public Void visit(SMTHandlerProperty.StringProperty stringProp, JComponent arg) {
            String val = ((JTextField)arg).getText();
            this.settings.put(stringProp.getIdentifier(), val);
            return null;
        }
    }

    private class SetVisitor
    implements SMTHandlerPropertyVisitor<Pair<String, JComponent>, Void> {
        private SetVisitor() {
        }

        public Void visit(SMTHandlerProperty.EnumProperty<?> enumProp, Pair<String, JComponent> arg) {
            JComboBox box = (JComboBox)arg.second;
            box.setSelectedItem(arg.first);
            return null;
        }

        public Void visit(SMTHandlerProperty.IntegerProperty integerProp, Pair<String, JComponent> arg) {
            JTextField field = (JTextField)arg.second;
            field.setText((String)arg.first);
            return null;
        }

        public Void visit(SMTHandlerProperty.BooleanProperty booleanProp, Pair<String, JComponent> arg) {
            JCheckBox box = (JCheckBox)arg.second;
            box.setSelected(Boolean.parseBoolean((String)arg.first));
            return null;
        }

        public Void visit(SMTHandlerProperty.StringProperty stringProp, Pair<String, JComponent> arg) {
            JTextField field = (JTextField)arg.second;
            field.setText((String)arg.first);
            return null;
        }
    }

    private class ComCreationVisitor
    implements SMTHandlerPropertyVisitor<Void, JComponent> {
        private ComCreationVisitor() {
        }

        public JComponent visit(SMTHandlerProperty.EnumProperty<?> eprop, Void unit) {
            return NewTranslationOptions.this.addComboBox(eprop.getLabel(), eprop.getDescription(), 0, null, (Enum[])eprop.getEnumType().getEnumConstants());
        }

        public JComponent visit(SMTHandlerProperty.IntegerProperty iprop, Void unit) {
            return NewTranslationOptions.this.addNumberField(iprop.getLabel(), iprop.getMinimum(), Integer.valueOf(iprop.getMaximum()), 1, iprop.getDescription(), NewTranslationOptions.this.emptyValidator());
        }

        public JComponent visit(SMTHandlerProperty.BooleanProperty bprop, Void unit) {
            return NewTranslationOptions.this.addCheckBox(bprop.getLabel(), bprop.getDescription(), false, NewTranslationOptions.this.emptyValidator());
        }

        public JComponent visit(SMTHandlerProperty.StringProperty sprop, Void unit) {
            return NewTranslationOptions.this.addTextField(sprop.getLabel(), sprop.getDescription(), "", NewTranslationOptions.this.emptyValidator());
        }
    }
}

