/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt.settings;

import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.gui.smt.settings.NewTranslationOptions;
import de.uka.ilkd.key.gui.smt.settings.SolverOptions;
import de.uka.ilkd.key.gui.smt.settings.TacletTranslationOptions;
import de.uka.ilkd.key.gui.smt.settings.TranslationOptions;
import de.uka.ilkd.key.settings.ProofIndependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.smt.solvertypes.SolverType;
import de.uka.ilkd.key.smt.solvertypes.SolverTypes;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class SMTSettingsProvider
extends SettingsPanel
implements SettingsProvider {
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("de.uka.ilkd.key.gui.smt.settings.messages");
    public static final String PROGRESS_MODE_USER = "PROGRESS_MODE_USER";
    public static final String PROGRESS_MODE_CLOSE = "PROGRESS_MODE_CLOSE";
    public static final String PROGRESS_MODE_CLOSE_FIRST = "PROGRESS_MODE_CLOSE_FIRST";
    private static final String INFO_BOUND = "infoBound";
    private static final String INFO_SAVE_TO_FILE_PANEL = "infoSaveToFilePanel";
    private static final String INFO_PROGRESS_MODE_BOX = "infoProgressModeBox";
    private static final String INFO_CHECK_FOR_SUPPORT = "infoCheckForSupport";
    private static final String INFO_MAX_PROCESSES = "infoMaxProcesses";
    private static final String INFO_TIMEOUT_FIELD = "infoTimeoutField";
    private final JTextField saveToFilePanel;
    private final JComboBox<String> progressModeBox;
    private final JSpinner maxProcesses;
    private final JSpinner timeoutField;
    private final JSpinner intBoundField;
    private final JSpinner seqBoundField;
    private final JSpinner objectBoundField;
    private final JSpinner locsetBoundField;
    private final JCheckBox solverSupportCheck;
    private transient ProofIndependentSMTSettings settings;
    private transient List<SettingsProvider> children = new ArrayList<SettingsProvider>();

    public SMTSettingsProvider() {
        this.saveToFilePanel = this.getSaveToFilePanel();
        this.progressModeBox = this.getProgressModeBox();
        this.timeoutField = this.createTimeoutField();
        this.maxProcesses = this.createMaxProcesses();
        this.intBoundField = this.createIntBoundField();
        this.objectBoundField = this.createObjectBoundField();
        this.locsetBoundField = this.createLocSetBoundField();
        this.seqBoundField = this.createSeqBoundField();
        this.solverSupportCheck = this.createSolverSupportCheck();
        Collection solverTypes = SolverTypes.getSolverTypes();
        this.getChildren().add(new TacletTranslationOptions());
        this.getChildren().add(new NewTranslationOptions());
        if (!Main.isExperimentalMode()) {
            solverTypes.removeAll(SolverTypes.getLegacySolvers());
        } else {
            this.getChildren().add(new TranslationOptions());
        }
        for (SolverType options : solverTypes.stream().filter(t -> ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings().containsSolver(t)).collect(Collectors.toList())) {
            this.getChildren().add(new SolverOptions(options));
        }
    }

    @Override
    public List<SettingsProvider> getChildren() {
        return this.children;
    }

    @Override
    public String getDescription() {
        return "SMT";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        ProofIndependentSMTSettings pi = SettingsManager.getSmtPiSettings();
        this.setSmtSettings(pi.clone());
        return this;
    }

    @Override
    public void applySettings(MainWindow window) {
        ProofIndependentSMTSettings pi = SettingsManager.getSmtPiSettings();
        pi.copy(this.settings);
        pi.fireSettingsChanged();
        this.setSmtSettings(pi.clone());
    }

    private JSpinner createLocSetBoundField() {
        return this.addNumberField("Locset bound:", 0L, Long.valueOf(Integer.MAX_VALUE), 1, BUNDLE.getString(INFO_BOUND), e -> this.settings.setLocsetBound(e.longValue()));
    }

    private JSpinner createMaxProcesses() {
        return this.addNumberField("Concurrent processes:", 0, Integer.valueOf(Integer.MAX_VALUE), 1, BUNDLE.getString(INFO_MAX_PROCESSES), e -> this.settings.setMaxConcurrentProcesses(e.intValue()));
    }

    private JSpinner createTimeoutField() {
        JSpinner timeoutSpinner = this.addNumberField("Timeout:", 0.0, Double.valueOf(9.223372036854776E18), 1, BUNDLE.getString(INFO_TIMEOUT_FIELD), e -> this.settings.setTimeout((long)Math.floor(e.doubleValue() * 1000.0)));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(timeoutSpinner, "#.###");
        editor.getFormat().setRoundingMode(RoundingMode.FLOOR);
        timeoutSpinner.setEditor(editor);
        return timeoutSpinner;
    }

    private JSpinner createIntBoundField() {
        return this.addNumberField("Integer bound:", 0L, Long.valueOf(Integer.MAX_VALUE), 1, BUNDLE.getString(INFO_BOUND), e -> this.settings.setIntBound(e.longValue()));
    }

    private JSpinner createSeqBoundField() {
        return this.addNumberField("Seq bound:", 0L, Long.valueOf(Integer.MAX_VALUE), 1, BUNDLE.getString(INFO_BOUND), e -> this.settings.setSeqBound(e.longValue()));
    }

    private JSpinner createObjectBoundField() {
        return this.addNumberField("Object bound:", 0L, Long.valueOf(Integer.MAX_VALUE), 1, BUNDLE.getString(INFO_BOUND), e -> this.settings.setObjectBound(e.longValue()));
    }

    private JComboBox<String> getProgressModeBox() {
        return this.addComboBox("", BUNDLE.getString(INFO_PROGRESS_MODE_BOX), 0, e -> this.settings.setModeOfProgressDialog(ProofIndependentSMTSettings.ProgressMode.values()[this.progressModeBox.getSelectedIndex()]), this.getProgressMode(ProofIndependentSMTSettings.ProgressMode.USER), this.getProgressMode(ProofIndependentSMTSettings.ProgressMode.CLOSE));
    }

    private JCheckBox createSolverSupportCheck() {
        return this.addCheckBox("Check for support when a solver is started", BUNDLE.getString(INFO_CHECK_FOR_SUPPORT), false, e -> this.settings.setCheckForSupport(this.solverSupportCheck.isSelected()));
    }

    private JTextField getSaveToFilePanel() {
        return this.addFileChooserPanel("Store translation to file:", "", BUNDLE.getString(INFO_SAVE_TO_FILE_PANEL), true, e -> this.settings.setPathForSMTTranslation(this.saveToFilePanel.getText()));
    }

    private String getProgressMode(ProofIndependentSMTSettings.ProgressMode index) {
        switch (index) {
            case USER: {
                return BUNDLE.getString(PROGRESS_MODE_USER);
            }
            case CLOSE: {
                return BUNDLE.getString(PROGRESS_MODE_CLOSE);
            }
            case CLOSE_FIRST: {
                return BUNDLE.getString(PROGRESS_MODE_CLOSE_FIRST);
            }
        }
        return "";
    }

    public void setSmtSettings(ProofIndependentSMTSettings settings) {
        this.settings = settings;
        this.saveToFilePanel.setText(this.settings.getPathForSMTTranslation());
        this.solverSupportCheck.setSelected(this.settings.isCheckForSupport());
        this.progressModeBox.setSelectedIndex(this.settings.getModeOfProgressDialog().ordinal());
        this.intBoundField.setValue(this.settings.getIntBound());
        this.locsetBoundField.setValue(this.settings.getLocsetBound());
        this.objectBoundField.setValue(this.settings.getObjectBound());
        this.seqBoundField.setValue(this.settings.getSeqBound());
        this.timeoutField.setValue((double)this.settings.getTimeout() / 1000.0);
        this.maxProcesses.setValue(this.settings.getMaxConcurrentProcesses());
    }
}

