/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.gui.smt.settings.SMTSettingsProvider;
import de.uka.ilkd.key.settings.ProofIndependentSMTSettings;
import de.uka.ilkd.key.smt.solvertypes.SolverType;
import java.math.RoundingMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

class SolverOptions
extends SettingsPanel
implements SettingsProvider {
    private static final String INFO_SOLVER_NAME = "infoSolverName";
    private static final String INFO_SOLVER_PARAMETERS = "infoSolverParameters";
    private static final String INFO_SOLVER_COMMAND = "infoSolverCommand";
    private static final String INFO_SOLVER_SUPPORT = "infoSolverSupport";
    private static final String INFO_SOLVER_INFO = "SOLVER_INFO";
    private static final String[] SOLVER_SUPPORT_TEXT = new String[]{SMTSettingsProvider.BUNDLE.getString("SOLVER_SUPPORTED"), SMTSettingsProvider.BUNDLE.getString("SOLVER_MAY_SUPPORTED"), SMTSettingsProvider.BUNDLE.getString("SOLVER_UNSUPPORTED")};
    private static final String INFO_SOLVER_TIMEOUT = "SOLVER_TIMEOUT";
    private static final int SOLVER_SUPPORTED = 0;
    private static final int SOLVER_NOT_SUPPOTED = 1;
    private static final int SOLVER_SUPPORT_NOT_CHECKED = 2;
    private final transient SolverType solverType;
    private final JTextField solverCommand;
    private final JTextField solverParameters;
    private final JTextField solverSupported;
    private final JTextField solverName;
    private final JTextField solverInstalled;
    private final JSpinner solverTimeout;

    public SolverOptions(SolverType solverType) {
        this.setName(solverType.getName());
        this.solverType = solverType;
        this.setHeaderText("SMT Solver: " + this.getDescription());
        this.solverName = this.createSolverName();
        this.createSolverInformation();
        this.solverInstalled = this.createSolverInstalled();
        this.solverCommand = this.createSolverCommand();
        this.solverTimeout = this.createSolverTimeout();
        this.solverParameters = this.createSolverParameters();
        this.solverSupported = this.createSolverSupported();
        this.createDefaultButton();
        this.createCheckSupportButton();
    }

    private static final String versionInfo(String info, String versionString) {
        StringBuilder builder = new StringBuilder();
        builder.append(info);
        builder.append(" ");
        builder.append("(");
        builder.append(versionString);
        builder.append(")");
        return builder.toString();
    }

    protected JButton createDefaultButton() {
        JButton toDefaultButton = new JButton("Set parameters to default");
        toDefaultButton.addActionListener(arg0 -> this.solverParameters.setText(this.solverType.getDefaultSolverParameters()));
        this.addRowWithHelp(null, new JLabel(), toDefaultButton);
        return toDefaultButton;
    }

    private String createSupportedVersionText() {
        StringBuilder result = new StringBuilder("The following minimal version is supported: ");
        result.append(this.solverType.getMinimumSupportedVersion());
        return result.toString();
    }

    private String getSolverSupportText() {
        if (this.solverType.supportHasBeenChecked()) {
            return this.solverType.isSupportedVersion() ? SOLVER_SUPPORT_TEXT[0] : SOLVER_SUPPORT_TEXT[1];
        }
        return SOLVER_SUPPORT_TEXT[2];
    }

    private JTextField createSolverInformation() {
        String info = this.solverType.getInfo();
        if (info != null && !info.equals("")) {
            JTextField solverInfo = this.addTextField("Info", info, SMTSettingsProvider.BUNDLE.getString(INFO_SOLVER_INFO), null);
            solverInfo.setEditable(false);
            return solverInfo;
        }
        return null;
    }

    protected JTextField createSolverSupported() {
        JTextField txt = this.addTextField("Support", this.getSolverSupportText(), SMTSettingsProvider.BUNDLE.getString(INFO_SOLVER_SUPPORT) + this.createSupportedVersionText(), this.emptyValidator());
        txt.setEditable(false);
        return txt;
    }

    private JSpinner createSolverTimeout() {
        SpinnerNumberModel model = new SpinnerNumberModel(0.0, -1.0, 9.223372036854776E18, 1.0);
        JSpinner jsp = this.createNumberTextField(model, this.emptyValidator());
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(jsp, "#.###");
        editor.getFormat().setRoundingMode(RoundingMode.FLOOR);
        jsp.setEditor(editor);
        this.addTitledComponent("Timeout", jsp, SMTSettingsProvider.BUNDLE.getString(INFO_SOLVER_TIMEOUT));
        return jsp;
    }

    protected JButton createCheckSupportButton() {
        JButton checkForSupportButton = new JButton("Check for support");
        checkForSupportButton.setEnabled(this.solverType.isInstalled(false));
        checkForSupportButton.addActionListener(arg0 -> {
            this.solverType.checkForSupport();
            this.solverSupported.setText(this.getSolverSupportText());
        });
        this.addRowWithHelp(null, new JLabel(), checkForSupportButton);
        return checkForSupportButton;
    }

    protected JTextField createSolverParameters() {
        return this.addTextField("Parameters", this.solverType.getSolverParameters(), SMTSettingsProvider.BUNDLE.getString(INFO_SOLVER_PARAMETERS), e -> {});
    }

    public JTextField createSolverCommand() {
        return this.addTextField("Command", this.solverType.getSolverCommand(), SMTSettingsProvider.BUNDLE.getString(INFO_SOLVER_COMMAND), e -> {});
    }

    protected JTextField createSolverInstalled() {
        Object info;
        boolean installed = this.solverType.isInstalled(true);
        Object object = info = installed ? "yes" : "no";
        if (installed) {
            try {
                String versionString = this.solverType.getRawVersion();
                info = SolverOptions.versionInfo((String)info, versionString);
            }
            catch (RuntimeException re) {
                info = "(version: unknown) solver is installed, but trying to access it resulted in an error " + (re.getCause() != null ? re.getCause().getLocalizedMessage() : re.getLocalizedMessage());
            }
        }
        JTextField txt = this.addTextField("Installed", (String)info, "", this.emptyValidator());
        txt.setEditable(false);
        return txt;
    }

    protected JTextField createSolverName() {
        JTextField txt = this.addTextField("Name", this.solverType.getName(), SMTSettingsProvider.BUNDLE.getString(INFO_SOLVER_NAME), this.emptyValidator());
        txt.setEditable(false);
        return txt;
    }

    @Override
    public String getDescription() {
        return this.solverType.getName();
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        this.setSmtSettings(SettingsManager.getSmtPiSettings().clone());
        return this;
    }

    private void setSmtSettings(ProofIndependentSMTSettings clone) {
        String info;
        if (!clone.containsSolver(this.solverType)) {
            throw new IllegalStateException("Could not find solver data for type: " + this.solverType);
        }
        this.solverCommand.setText(clone.getCommand(this.solverType));
        this.solverParameters.setText(clone.getParameters(this.solverType));
        this.solverTimeout.setValue((double)clone.getSolverTimeout(this.solverType) / 1000.0);
        this.solverName.setText(this.solverType.getName());
        boolean installed = this.solverType.isInstalled(true);
        String string = info = installed ? "yes" : "no";
        if (installed) {
            String versionString = this.solverType.getRawVersion();
            info = SolverOptions.versionInfo(info, versionString);
        }
        this.solverInstalled.setText(info);
    }

    @Override
    public void applySettings(MainWindow window) {
        ProofIndependentSMTSettings settings = SettingsManager.getSmtPiSettings();
        if (!settings.containsSolver(this.solverType)) {
            throw new IllegalStateException("Could not find solver data for type: " + this.solverType);
        }
        String command = this.solverCommand.getText();
        String params = this.solverParameters.getText();
        long timeout = (long)(((Number)this.solverTimeout.getValue()).doubleValue() * 1000.0);
        this.solverType.setSolverCommand(command);
        this.solverType.setSolverParameters(params);
        this.solverType.setSolverTimeout(timeout);
        window.updateSMTSelectMenu();
        this.setSmtSettings(SettingsManager.getSmtPiSettings().clone());
    }
}

