/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.settings.ProofDependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSMTSettings;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class TacletTranslationOptions
extends SettingsPanel
implements SettingsProvider {
    private static final long serialVersionUID = 5273966151509876358L;
    private static final String infoFileChooserPanel = "Activate this option to store the translations of taclets that are handed over to the externals solvers:\n1. Choose the folder.\n2. Specify the filename:\n\t%s: the solver's name\n\t%d: date\n\t%t: time\n\t%i: the goal's number\n\n\nExample: ./home/translations/Taclet%d_%t_%i_%s.txt\n\nNote: After every restart of KeY this option is deactivated.";
    private static final String infoMaxNumberOfGenerics = "This option specifies how many different generic sorts are allowed within a taclet.\n\nBe aware of the fact that too many different generic sorts can overwhelm the external solvers. On the other side there are taclets that use a certain amount of different generic sorts (see: taclet selection).\n\nRule of thumb: Most of the taclets can be translated by using 2-3 different generic sorts.";
    private final JTextField fileChooserPanel;
    private final JSpinner maxNumberOfGenerics;

    public TacletTranslationOptions() {
        this.setHeaderText("Taclet Translation Options for SMT");
        this.fileChooserPanel = this.createFileChooserPanel();
        this.maxNumberOfGenerics = this.createMaxNumberOfGenerics();
    }

    protected JSpinner createMaxNumberOfGenerics() {
        return this.addNumberField("Maximum number of generic sorts.", 0, Integer.valueOf(Integer.MAX_VALUE), 1, infoMaxNumberOfGenerics, this.emptyValidator());
    }

    protected JTextField createFileChooserPanel() {
        return this.addFileChooserPanel("Store taclet translation to file:", "", infoFileChooserPanel, true, e -> {});
    }

    @Override
    public String getDescription() {
        return "Taclet Translation";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        ProofDependentSMTSettings pdSettings = SettingsManager.getSmtPdSettings(window).clone();
        ProofIndependentSMTSettings piSettings = SettingsManager.getSmtPiSettings().clone();
        this.maxNumberOfGenerics.setValue(pdSettings.maxGenericSorts);
        this.fileChooserPanel.setText(piSettings.getPathForTacletTranslation());
        return this;
    }

    @Override
    public void applySettings(MainWindow window) {
        ProofDependentSMTSettings currentPd = SettingsManager.getSmtPdSettings(window);
        ProofIndependentSMTSettings currentPi = SettingsManager.getSmtPiSettings();
        currentPd.maxGenericSorts = (Integer)this.maxNumberOfGenerics.getValue();
        currentPi.setPathForTacletTranslation(this.fileChooserPanel.getText());
        currentPi.setStoreTacletTranslationToFile(!this.fileChooserPanel.getText().trim().isEmpty());
        currentPd.fireSettingsChanged();
        currentPi.fireSettingsChanged();
    }
}

