/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.settings.ProofDependentSMTSettings;
import java.awt.Color;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;

class TranslationOptions
extends SettingsPanel
implements SettingsProvider {
    private static final long serialVersionUID = 7299370317491756605L;
    private static final String infoUseExplicitTypeHierarchy = "If this option is selected, the transitive inheritance between classes is modeled by assumptions.\n\nExample: Let A, B and C  be classes such that C extends B and B extends A.\nIf the option is not selected, the following assumptions are added:\n\\forall x; (type_of_C(x)->type_of_B(x))\n\\forall x; (type_of_B(x)->type_of_A(x))\nIf the option is selected, the following assumption is additionally added to the assumptions above:\n\\forall x; (type_of_C(x)->type_of_A(x))\n";
    private static final String infoUseNullInstantiation = "At the moment this option has only effect on hierarchy assumptions regarding the null object.\nExample: Let A and B be classes.\nIf the option is not selected, the type null is treated as a normal class. Consequently, the following assumptions are added:\n\\forall x; (type_of_Null(x)->type_of_A(x))\n\\forall x; (type_of_Null(x)->type_of_B(x))\nIf the option is selected, those assumptions are instantiated with a concrete null object:\ntype_of_A(null)\ntype_of_B(null)";
    private static final String infoUseBuiltInUniqueness = "Some solvers support the uniqueness of functions by built-in mechanisms. If this option is selected those mechanisms are used, otherwise some assumptions are added by using normal FOL.\nNote: The uniqueness of functions is needed for translating attributes and arrays.";
    private static final String infoUseUIMultiplication = "Some solvers support only simple multiplications. For example Yices supports only multiplications of type a*b where a or b must be a number.\nIn order to support more complex multiplications, this option can be activated: If the solver does not support a certain kind of multiplication, the occurence of this multiplication is translated into the uninterpreted function mult. Furthermore some typical assumptions are added:\n\\forall x; mult(x,0)=0\n\\forall x; mult(0,x)=0\n\\forall x; mult(x,1)=x\n\\forall x; mult(1,x)=x\n\\forall x; \\forall y; mult(x,y)=mult(y,x)\n\\forall x; \\forall y; \\forall z; mult(mult(x,y),z)=mult(x,mult(y,z))\n\\forall x; \\forall y; mult(x,y)=0 -> (x=0|y=0)\n\\forall x; \\forall y; mult(x,y)=1 -> (x=1&y=1)\nNote:\n1. If this option is not selected, an exception is thrown in the case that a unsupported multiplication occurs.\n2. The translation makes the uninterpreted function mult unique, so that there cannot be any clashes with functions that are introduced by the user.";
    private static final String infoUseConstantsForIntegers = "Some solvers support only a certain interval of integers (e.g. Simplify). If this option is activated, numbers that are not supported by the used solver are translated into uninterpreted constants. Furthermore  an asumption is added that states that the introduced constant is greater than the maximum of the supported numbers.\n\nExample: Assume that a solver supports numbers less or equal 10:\nThe number 11 is translated into the constant c_11 and the assumption c_11>10 is introduced.\n\nNote: If this option is not selected, an exception is thrown in the case that a not supported number occurs.\n";
    private final JCheckBox useExplicitTypeHierachy;
    private final JCheckBox useNullInstantiation;
    private final JCheckBox useBuiltInUniqueness;
    private final JCheckBox useUIMultiplication;
    private final JCheckBox useConstantsForIntegers;
    private final JSpinner minField;
    private final JSpinner maxField;
    private ProofDependentSMTSettings settings;

    public TranslationOptions() {
        this.setHeaderText(this.getDescription());
        this.useExplicitTypeHierachy = this.createUseExplicitTypeHierachy();
        this.useNullInstantiation = this.createNullInstantiation();
        this.useBuiltInUniqueness = this.createBuiltInUniqueness();
        this.useUIMultiplication = this.createUIMultiplication();
        this.addSeparator("Use constants for too big or too small integers.");
        this.useConstantsForIntegers = this.createConstantsForIntegers();
        this.minField = this.createMinField();
        this.maxField = this.createMaxField();
    }

    public void setSmtSettings(ProofDependentSMTSettings settings) {
        this.settings = settings;
        if (settings == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.useExplicitTypeHierachy.setSelected(settings.useExplicitTypeHierarchy);
            this.useNullInstantiation.setSelected(settings.useNullInstantiation);
            this.useBuiltInUniqueness.setSelected(settings.useBuiltInUniqueness);
            this.useConstantsForIntegers.setSelected(settings.useConstantsForIntegers);
            this.minField.setValue(settings.minInteger);
            this.maxField.setValue(settings.maxInteger);
        }
    }

    protected JCheckBox createUseExplicitTypeHierachy() {
        return this.addCheckBox("Use an explicit type hierarchy.", infoUseExplicitTypeHierarchy, false, e -> {
            this.settings.useExplicitTypeHierarchy = this.useExplicitTypeHierachy.isSelected();
        });
    }

    protected JCheckBox createNullInstantiation() {
        return this.addCheckBox("Instantiate hierarchy assumptions if possible (recommended).", infoUseNullInstantiation, false, e -> {
            this.settings.useNullInstantiation = this.useNullInstantiation.isSelected();
        });
    }

    protected JCheckBox createBuiltInUniqueness() {
        return this.addCheckBox("Use built-in mechanism for uniqueness if possible.", infoUseBuiltInUniqueness, false, e -> {
            this.settings.useBuiltInUniqueness = this.useBuiltInUniqueness.isSelected();
        });
    }

    protected JCheckBox createUIMultiplication() {
        return this.addCheckBox("Use uninterpreted multiplication if necessary.", infoUseUIMultiplication, false, e -> {
            this.settings.useUIMultiplication = this.useUIMultiplication.isSelected();
        });
    }

    protected JSpinner createMaxField() {
        JSpinner max = this.addNumberField("Maximum", Integer.MIN_VALUE, Integer.valueOf(Integer.MAX_VALUE), 1, "", e -> {
            if (this.settings != null) {
                this.settings.maxInteger = e.longValue();
            }
        });
        try {
            max.setValue(Integer.MAX_VALUE);
            max.setForeground(Color.BLACK);
        }
        catch (IllegalArgumentException e2) {
            max.setForeground(Color.RED);
        }
        return max;
    }

    protected JSpinner createMinField() {
        return this.addNumberField("Minimum", Integer.MIN_VALUE, Integer.valueOf(Integer.MAX_VALUE), 1, "", val -> {
            this.settings.minInteger = val.longValue();
        });
    }

    protected JCheckBox createConstantsForIntegers() {
        return this.addCheckBox("Active", infoUseConstantsForIntegers, false, e -> {
            this.settings.useConstantsForIntegers = this.useConstantsForIntegers.isSelected();
            this.maxField.setEnabled(this.useConstantsForIntegers.isSelected());
            this.minField.setEnabled(this.useConstantsForIntegers.isSelected());
        });
    }

    @Override
    public String getDescription() {
        return "SMT Translation (Old)";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        this.setSmtSettings(SettingsManager.getSmtPdSettings(window).clone());
        return this;
    }

    @Override
    public void applySettings(MainWindow window) {
        ProofDependentSMTSettings current = SettingsManager.getSmtPdSettings(window);
        current.copy(this.settings);
        current.fireSettingsChanged();
    }
}

