/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.sourceview;

import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.speclang.jml.JMLUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class JavaDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = -1856296532743892931L;
    private static final ColorSettings.ColorProperty JAVA_KEYWORD_COLOR = ColorSettings.define("[java]keyword", "", new Color(8323157));
    private static final ColorSettings.ColorProperty COMMENT_COLOR = ColorSettings.define("[java]comment", "", new Color(4161375));
    private static final ColorSettings.ColorProperty JAVADOC_COLOR = ColorSettings.define("[java]javadoc", "", new Color(4161375));
    private static final ColorSettings.ColorProperty JML_COLOR = ColorSettings.define("[java]jml", "", new Color(192));
    private static final ColorSettings.ColorProperty JML_KEYWORD_COLOR = ColorSettings.define("[java]jmlKeyword", "", new Color(240));
    private static final String DELIM = "[\\Q .;{}[]\n\r()+-*/%!=<>?:~&|^@'\"\\E]";
    private static final Pattern JML_ANNOT_MARKER = Pattern.compile("/\\*([+|-][$_a-zA-Z0-9]+)+@");
    private static final Pattern JML_ANNOT_MARKER_LINE = Pattern.compile("//([+|-][$_a-zA-Z0-9]+)+@");
    private static final String[] KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"};
    private static final String[] JMLKEYWORDS = new String[]{"break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "false", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "label", "new", "null", "package", "return", "super", "switch", "this", "throw", "throws", "true", "try", "void", "while", "boolean", "byte", "char", "double", "float", "int", "long", "short", "\\bigint", "\\locset", "\\real", "\\seq", "\\TYPE", "abstract", "code", "code_bigint_math", "code_java_math", "code_safe_math", "extract", "final", "ghost", "helper", "instance", "model", "native", "non_null", "nullable", "nullable_by_default", "private", "protected", "peer", "\\peer", "public", "pure", "rep", "\\rep", "spec_bigint_math", "spec_java_math", "spec_protected", "spec_public", "spec_safe_math", "static", "strictfp", "strictly_pure", "synchronized", "transient", "two_state", "uninitialized", "volatile", "no_state", "modifies", "erases", "modifiable", "returns", "break_behavior", "continue_behavior", "return_behavior", "\\constraint_for", "\\created", "\\disjoint", "\\duration", "\\everything", "\\exception", "\\exists", "\\forall", "\\fresh", "\\index", "\\invariant_for", "\\is_initialized", "\\itself", "\\lblneg", "\\lblpos", "\\lockset", "\\max", "\\measured_by", "\\min", "\\new_elems_fresh", "\\nonnullelements", "\\not_accessed", "\\not_assigned", "\\not_modified", "\\not_specified", "\\nothing", "\\num_of", "\\old", "\\only_assigned", "\\only_called", "\\only_captured", "\\pre", "\\product", "\\reach", "\\reachLocs", "\\result", "\\same", "\\seq_contains", "\\space", "\\static_constraint_for", "\\static_invariant_for", "\\strictly_nothing", "\\subset", "\\sum", "\\type", "\\typeof", "\\working_space", "\\values", "\\inv", "accessible", "accessible_redundantly", "assert", "assert_redundantly", "assignable", "assignable_redundantly", "assume", "assume_redudantly", "breaks", "breaks_redundantly", "\\by", "callable", "callable_redundantly", "captures", "captures_redundantly", "continues", "continues_redundantly", "debug", "\\declassifies", "decreases", "decreases_redundantly", "decreasing", "decreasing_redundantly", "diverges", "determines", "diverges_redundantly", "duration", "duration_redundantly", "ensures", "ensures_redundantly", "\\erases", "forall", "for_example", "hence_by", "implies_that", "in", "in_redundantly", "\\into", "loop_invariant", "loop_invariant_redundantly", "measured_by", "measured_by_redundantly", "maintaining", "maintaining_redundantly", "maps", "maps_redundantly", "\\new_objects", "old", "refining", "represents", "requires", "set", "signals", "signals_only", "\\such_that", "unreachable", "when", "working_space", "abrupt_behavior", "abrupt_behaviour", "also", "axiom", "behavior", "behaviour", "constraint", "exceptional_behavior", "exceptional_behaviour", "initially", "invariant", "model_behavior", "model_behaviour", "monitors_for", "normal_behavior", "normal_behaviour", "readable", "writable", "\\seq_empty", "\\seq_def", "\\seq_singleton", "\\seq_get", "\\seq_put", "\\seq_reverse", "\\seq_length", "\\index_of", "\\seq_concat", "\\empty", "\\singleton", "\\set_union", "\\intersect", "\\set_minus", "\\all_fields", "\\infinite_union", "\\strictly_than_nothing"};
    private final SimpleAttributeSet annotation = new SimpleAttributeSet();
    private final SimpleAttributeSet normal = new SimpleAttributeSet();
    private final SimpleAttributeSet keyword = new SimpleAttributeSet();
    private final SimpleAttributeSet comment = new SimpleAttributeSet();
    private final SimpleAttributeSet javadoc = new SimpleAttributeSet();
    private final SimpleAttributeSet jml = new SimpleAttributeSet();
    private final SimpleAttributeSet jmlkeyword = new SimpleAttributeSet();
    private final Set<String> keywords = new HashSet<String>(KEYWORDS.length);
    private final Set<String> jmlkeywords = new HashSet<String>(JMLKEYWORDS.length);
    private int currentPos = 0;
    private int tokenStart = 0;
    private String token = "";
    private Mode mode = Mode.NORMAL;
    private CommentState state = CommentState.NO;

    public JavaDocument() {
        this.updateStyles();
        ColorSettings.getInstance().addSettingsListener(e -> this.updateStyles());
        this.putProperty("__EndOfLine__", "\n");
        this.keywords.addAll(Arrays.asList(KEYWORDS));
        this.jmlkeywords.addAll(Arrays.asList(JMLKEYWORDS));
    }

    private void updateStyles() {
        StyleConstants.setBold(this.keyword, true);
        StyleConstants.setForeground(this.keyword, JAVA_KEYWORD_COLOR.get());
        StyleConstants.setForeground(this.comment, COMMENT_COLOR.get());
        StyleConstants.setForeground(this.javadoc, JAVADOC_COLOR.get());
        StyleConstants.setForeground(this.jml, JML_COLOR.get());
        StyleConstants.setForeground(this.jmlkeyword, JML_KEYWORD_COLOR.get());
        StyleConstants.setBold(this.jmlkeyword, true);
    }

    private void checkAt() {
        this.token = this.token + "@";
        if (this.state == CommentState.COMMENT) {
            this.state = CommentState.NO;
            this.mode = Mode.JML;
        } else if (this.state == CommentState.LINECOMMENT) {
            this.state = CommentState.NO;
            this.mode = Mode.LINE_JML;
        } else if (this.mode == Mode.NORMAL && this.state == CommentState.NO) {
            this.mode = Mode.ANNOTATION;
            this.tokenStart = this.currentPos;
        } else if (this.state == CommentState.JML_ANNOTATION || this.state == CommentState.JML_ANNOTATION_LINE) {
            boolean lineComment = this.state == CommentState.JML_ANNOTATION_LINE;
            this.state = CommentState.NO;
            String features = this.token.substring(2);
            this.mode = JMLUtils.isJmlCommentStarter((String)features) ? (lineComment ? Mode.LINE_JML : Mode.JML) : (lineComment ? Mode.LINE_COMMENT : Mode.COMMENT);
        }
    }

    private void checkSpaceTab(char c) {
        this.token = this.token + c;
        this.state = CommentState.NO;
    }

    private void checkPlusMinus(char c) {
        if (this.state == CommentState.LINECOMMENT || this.state == CommentState.JML_ANNOTATION_LINE) {
            this.token = this.token + c;
            this.state = CommentState.JML_ANNOTATION_LINE;
        } else if (this.state == CommentState.COMMENT || this.state == CommentState.JML_ANNOTATION) {
            this.token = this.token + c;
            this.state = CommentState.JML_ANNOTATION;
        } else {
            this.token = this.token + c;
            this.state = CommentState.NO;
        }
    }

    private void checkLinefeed() throws BadLocationException {
        this.state = CommentState.NO;
        if (this.mode == Mode.LINE_COMMENT) {
            this.insertCommentString(this.token, this.tokenStart);
            this.mode = Mode.NORMAL;
            this.token = "\n";
            this.tokenStart = this.currentPos;
        } else if (this.mode == Mode.LINE_JML) {
            this.insertJMLString(this.token, this.tokenStart);
            this.mode = Mode.NORMAL;
            this.token = "\n";
            this.tokenStart = this.currentPos;
        } else if (this.mode == Mode.ANNOTATION) {
            this.insertAnnotation(this.token, this.tokenStart);
            this.mode = Mode.NORMAL;
            this.token = "\n";
            this.tokenStart = this.currentPos;
        } else if (this.mode == Mode.NORMAL) {
            this.insertNormalString(this.token, this.tokenStart);
            this.token = "\n";
            this.tokenStart = this.currentPos;
        } else {
            this.token = this.token + "\n";
        }
    }

    private void checkStar() throws BadLocationException {
        if (this.state == CommentState.MAYBE) {
            this.insertNormalString(this.token.substring(0, this.token.length() - 1), this.tokenStart);
            this.token = "/*";
            this.tokenStart = this.currentPos - 1;
            this.state = CommentState.COMMENT;
            this.mode = Mode.COMMENT;
        } else if (this.state == CommentState.COMMENT) {
            this.token = this.token + "*";
            this.state = CommentState.MAYBEEND;
            this.mode = Mode.JAVADOC;
        } else if (this.mode == Mode.COMMENT || this.mode == Mode.JAVADOC || this.mode == Mode.JML) {
            this.token = this.token + "*";
            this.state = CommentState.MAYBEEND;
        } else {
            this.token = this.token + "*";
            this.state = CommentState.NO;
        }
    }

    private void checkSlash() throws BadLocationException {
        if (this.mode == Mode.NORMAL && this.state == CommentState.NO) {
            this.token = this.token + "/";
            this.state = CommentState.MAYBE;
        } else if (this.state == CommentState.MAYBE) {
            this.insertNormalString(this.token.substring(0, this.token.length() - 1), this.tokenStart);
            this.token = "//";
            this.tokenStart = this.currentPos - 1;
            this.state = CommentState.LINECOMMENT;
            this.mode = Mode.LINE_COMMENT;
        } else if (this.state == CommentState.MAYBEEND) {
            this.token = this.token + "/";
            if (this.mode == Mode.COMMENT) {
                this.insertCommentString(this.token, this.tokenStart);
            } else if (this.mode == Mode.JAVADOC) {
                if (this.token.equals("/**/")) {
                    this.insertCommentString(this.token, this.tokenStart);
                } else {
                    this.insertJavadocString(this.token, this.tokenStart);
                }
            } else if (this.mode == Mode.JML) {
                this.insertJMLString(this.token, this.tokenStart);
            }
            this.state = CommentState.NO;
            this.mode = Mode.NORMAL;
            this.token = "";
            this.tokenStart = this.currentPos + 1;
        } else {
            this.token = this.token + "/";
        }
    }

    private void checkQuote() {
        this.state = CommentState.NO;
        this.token = this.token + "\"";
    }

    private void checkOther(char c) {
        this.token = this.token + c;
        if (this.state != CommentState.JML_ANNOTATION && this.state != CommentState.JML_ANNOTATION_LINE) {
            this.state = CommentState.NO;
        }
    }

    private void checkDelimiter(char c) {
        this.token = this.token + c;
        this.state = CommentState.NO;
    }

    private void processChar(char strChar) throws BadLocationException {
        switch (strChar) {
            case '@': {
                this.checkAt();
                break;
            }
            case '\n': {
                this.checkLinefeed();
                break;
            }
            case '\t': 
            case ' ': {
                this.checkSpaceTab(strChar);
                break;
            }
            case '*': {
                this.checkStar();
                break;
            }
            case '/': {
                this.checkSlash();
                break;
            }
            case '\"': {
                this.checkQuote();
                break;
            }
            case '+': 
            case '-': {
                this.checkPlusMinus(strChar);
                break;
            }
            case '!': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '.': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                this.checkDelimiter(strChar);
                break;
            }
            default: {
                this.checkOther(strChar);
            }
        }
    }

    private void insertCommentString(String str, int pos) throws BadLocationException {
        this.remove(pos, str.length());
        super.insertString(pos, str, this.comment);
    }

    private void insertAnnotation(String str, int pos) throws BadLocationException {
        this.remove(pos, str.length());
        super.insertString(pos, str, this.annotation);
    }

    private void insertJavadocString(String str, int pos) throws BadLocationException {
        this.remove(pos, str.length());
        super.insertString(pos, str, this.javadoc);
    }

    private void insertJMLString(String str, int pos) throws BadLocationException {
        String[] tokens;
        this.remove(pos, str.length());
        int offset = 0;
        for (String t : tokens = str.split("((?<=[\\Q .;{}[]\n\r()+-*/%!=<>?:~&|^@'\"\\E])|(?=[\\Q .;{}[]\n\r()+-*/%!=<>?:~&|^@'\"\\E]))")) {
            if (this.jmlkeywords.contains(t)) {
                super.insertString(pos + offset, t, this.jmlkeyword);
            } else {
                super.insertString(pos + offset, t, this.jml);
            }
            offset += t.length();
        }
    }

    private void insertNormalString(String str, int pos) throws BadLocationException {
        String[] tokens;
        this.remove(pos, str.length());
        int offset = 0;
        for (String t : tokens = str.split("((?<=[\\Q .;{}[]\n\r()+-*/%!=<>?:~&|^@'\"\\E])|(?=[\\Q .;{}[]\n\r()+-*/%!=<>?:~&|^@'\"\\E]))")) {
            if (this.keywords.contains(t)) {
                super.insertString(pos + offset, t, this.keyword);
            } else {
                super.insertString(pos + offset, t, this.normal);
            }
            offset += t.length();
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, this.normal);
        int strLen = str.length();
        int endpos = offs + strLen;
        for (int i = offs; i < endpos; ++i) {
            this.currentPos = i;
            int strpos = i - offs;
            this.processChar(str.charAt(strpos));
        }
        this.currentPos = endpos;
        this.tokenStart = endpos;
        this.token = "";
        this.mode = Mode.NORMAL;
        this.state = CommentState.NO;
    }

    private static enum CommentState {
        NO,
        MAYBE,
        COMMENT,
        LINECOMMENT,
        JML_ANNOTATION,
        JML_ANNOTATION_LINE,
        MAYBEEND;

    }

    private static enum Mode {
        NORMAL,
        KEYWORD,
        COMMENT,
        LINE_COMMENT,
        LINE_JML,
        JAVADOC,
        ANNOTATION,
        JML,
        JML_KEYWORD;

    }
}

