/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.sourceview;

import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.TaskTree;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.configuration.Config;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.nodeviews.CurrentGoalView;
import de.uka.ilkd.key.gui.sourceview.JavaDocument;
import de.uka.ilkd.key.gui.sourceview.TextLineNumber;
import de.uka.ilkd.key.java.NonTerminalProgramElement;
import de.uka.ilkd.key.java.PositionInfo;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.Statement;
import de.uka.ilkd.key.java.statement.Else;
import de.uka.ilkd.key.java.statement.If;
import de.uka.ilkd.key.java.statement.MethodBodyStatement;
import de.uka.ilkd.key.java.statement.Then;
import de.uka.ilkd.key.java.visitor.JavaASTVisitor;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.pp.Range;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofJavaSourceCollection;
import de.uka.ilkd.key.proof.io.consistency.FileRepo;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.key_project.util.collection.ImmutableSet;
import org.key_project.util.java.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceView
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTree.class);
    private static final long serialVersionUID = -94424677425561025L;
    private static SourceView instance;
    private static final String TEXTPANE_HIGHLIGHTED_TOOLTIP = "Jump upwards to the most recent occurrence of this line in symbolic execution.";
    private static final String NO_SOURCE = "No source loaded";
    private static final int TAB_SIZE = 4;
    private static final ColorSettings.ColorProperty NORMAL_HIGHLIGHT_COLOR;
    private static final ColorSettings.ColorProperty MOST_RECENT_HIGHLIGHT_COLOR;
    private static final ColorSettings.ColorProperty TAB_HIGHLIGHT_COLOR;
    private final MainWindow mainWindow;
    private final Map<URI, Tab> tabs = new HashMap<URI, Tab>();
    private final TabbedPane tabPane = new TabbedPane();
    private URI selectedFile = null;
    private final JLabel sourceStatusBar;
    private LinkedList<Pair<Node, PositionInfo>> lines;
    private final Set<Highlight> symbExHighlights = new HashSet<Highlight>();

    private SourceView(final MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.sourceStatusBar = new JLabel();
        this.tabPane.setBorder(new TitledBorder(NO_SOURCE));
        this.tabPane.addChangeListener(e -> {
            this.selectedFile = this.tabPane.getSelectedTab() == null ? null : this.tabPane.getSelectedTab().absoluteFileName;
            for (Tab tab : this.tabs.values()) {
                tab.markTabComponent();
            }
        });
        this.sourceStatusBar.setBorder(new BevelBorder(1));
        this.sourceStatusBar.setBackground(Color.gray);
        this.sourceStatusBar.setPreferredSize(new Dimension(0, this.getFontMetrics(this.sourceStatusBar.getFont()).getHeight() + 6));
        this.sourceStatusBar.setHorizontalAlignment(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane, "Center");
        this.add((Component)this.sourceStatusBar, "South");
        Config.DEFAULT.addConfigChangeListener(e -> {
            for (Tab tab : this.tabs.values()) {
                tab.textPane.setFont(UIManager.getFont("KEY_FONT_CURRENT_GOAL_VIEW"));
            }
        });
        mainWindow.getMediator().addKeYSelectionListener(new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
                if (!mainWindow.getMediator().isInAutoMode()) {
                    SourceView.this.updateGUI();
                }
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                SourceView.this.clear();
                SourceView.this.updateGUI();
            }
        });
        KeYGuiExtensionFacade.installKeyboardShortcuts(null, this, KeYGuiExtension.KeyboardShortcuts.SOURCE_VIEW);
    }

    public static SourceView getSourceView(MainWindow mainWindow) {
        if (instance == null) {
            instance = new SourceView(mainWindow);
        }
        return instance;
    }

    public Highlight addHighlight(URI fileURI, int line, Color color, int level) throws BadLocationException, IOException {
        this.openFile(fileURI);
        Tab tab = this.tabs.get(fileURI);
        if (tab == null || line < 0 || line >= tab.lineInformation.length) {
            throw new BadLocationException("Not a valid line number for " + fileURI, line);
        }
        if (!tab.highlights.containsKey(line)) {
            tab.highlights.put(line, new TreeSet(Collections.reverseOrder()));
        }
        SortedSet<Highlight> highlights = tab.highlights.get(line);
        Highlight highlight = new Highlight(fileURI, line, color, level);
        highlights.add(highlight);
        tab.markTabComponent();
        tab.removeHighlights(line);
        tab.applyHighlights(line);
        return highlight;
    }

    public Set<Highlight> addHighlightsForJMLStatement(URI fileURI, int firstLine, Color color, int level) throws BadLocationException, IOException {
        int i;
        this.openFile(fileURI);
        Tab tab = this.tabs.get(fileURI);
        String[] lines = tab != null ? tab.source.split("\\R", -1) : new String[]{};
        int lastLine = firstLine;
        if (0 < lines.length && lines[firstLine - 1].trim().startsWith("@")) {
            int parens = 0;
            block0: for (i = firstLine; i <= lines.length; ++i) {
                for (int j = 0; j < lines[i - 1].length(); ++j) {
                    if (lines[i - 1].charAt(j) == '(') {
                        ++parens;
                        continue;
                    }
                    if (lines[i - 1].charAt(j) == ')') {
                        --parens;
                        continue;
                    }
                    if (parens != 0 || lines[i - 1].charAt(j) != ';') continue;
                    lastLine = i;
                    break block0;
                }
            }
        }
        HashSet<Highlight> result = new HashSet<Highlight>();
        for (i = firstLine; i <= lastLine && tab != null; ++i) {
            result.add(this.addHighlight(fileURI, i, color, level));
        }
        return result;
    }

    public void changeHighlight(Highlight highlight, int newLine) throws BadLocationException {
        URI fileURI = highlight.getFileURI();
        int oldLine = highlight.getLine();
        Tab tab = this.tabs.get(fileURI);
        if (tab == null || !tab.highlights.containsKey(oldLine) || !tab.highlights.get(oldLine).contains(highlight)) {
            throw new IllegalArgumentException("highlight");
        }
        tab.removeHighlights(oldLine);
        tab.highlights.get(oldLine).remove(highlight);
        tab.applyHighlights(oldLine);
        if (tab.highlights.get(oldLine).isEmpty()) {
            tab.highlights.remove(oldLine);
        }
        highlight.line = newLine;
        highlight.setTag(null);
        if (!tab.highlights.containsKey(newLine)) {
            tab.highlights.put(newLine, new TreeSet());
        }
        tab.highlights.get(newLine).add(highlight);
        tab.removeHighlights(newLine);
        tab.applyHighlights(newLine);
    }

    public boolean removeHighlight(Highlight highlight) {
        Tab tab = this.tabs.get(highlight.getFileURI());
        if (tab == null) {
            return false;
        }
        tab.removeHighlights(highlight.getLine());
        boolean result = tab.highlights.containsKey(highlight.getLine()) && tab.highlights.get(highlight.getLine()).remove(highlight);
        highlight.setTag(null);
        if (result && tab.highlights.get(highlight.getLine()).isEmpty()) {
            tab.highlights.remove(highlight.getLine());
        } else {
            try {
                tab.applyHighlights(highlight.getLine());
            }
            catch (BadLocationException e) {
                throw new AssertionError();
            }
        }
        tab.markTabComponent();
        return result;
    }

    public void openFile(URI fileURI) throws IOException {
        HashSet<URI> set = new HashSet<URI>();
        set.add(fileURI);
        this.openFiles(set);
    }

    public void openFiles(Set<URI> fileURIs) throws IOException {
        boolean updateNecessary = false;
        for (URI fileURI : fileURIs) {
            if (!this.addFile(fileURI)) continue;
            updateNecessary = true;
            ((ProofJavaSourceCollection)this.mainWindow.getMediator().getSelectedProof().lookup(ProofJavaSourceCollection.class)).addRelevantFile(fileURI);
        }
        if (updateNecessary) {
            this.updateGUI();
        }
    }

    private static Range calculateLineRange(JTextPane textPane, int pos) {
        Document doc = textPane.getDocument();
        String text = "";
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            LOGGER.debug("Caught exception!", (Throwable)e);
        }
        int end = text.indexOf(10, pos);
        end = end == -1 ? text.length() : end;
        int start = text.lastIndexOf(10, pos - 1);
        int n = start = start == -1 ? 0 : start;
        while (start < text.length() && start < end && Character.isWhitespace(text.charAt(start))) {
            ++start;
        }
        return new Range(start, end);
    }

    private static String replaceTabs(String s) {
        char[] rep = new char[4];
        Arrays.fill(rep, ' ');
        return s.replace("\t", new String(rep));
    }

    private boolean isSelected(Tab tab) {
        return Objects.equals(this.selectedFile, tab.absoluteFileName);
    }

    private boolean isHighlighted(Point point) {
        Tab tab = this.tabs.get(this.selectedFile);
        int pos = tab.textPane.viewToModel(point);
        int line = tab.posToLine(pos);
        for (Highlight h : this.symbExHighlights) {
            Range range;
            if (line != h.line || (range = SourceView.calculateLineRange(tab.textPane, tab.lineInformation[line - 1].getOffset())).start() > pos || pos >= range.end()) continue;
            return true;
        }
        return false;
    }

    private void addFiles() throws IOException {
        ImmutableSet fileURIs = ((ProofJavaSourceCollection)this.mainWindow.getMediator().getSelectedProof().lookup(ProofJavaSourceCollection.class)).getRelevantFiles();
        Iterator<URI> it = this.tabs.keySet().iterator();
        while (it.hasNext()) {
            URI fileURI = it.next();
            if (fileURIs.contains((Object)fileURI)) continue;
            Tab tab = this.tabs.get(fileURI);
            it.remove();
            this.tabPane.remove(tab);
        }
        for (URI fileURI : fileURIs) {
            this.addFile(fileURI);
        }
    }

    private boolean addFile(URI fileURI) throws IOException {
        if (fileURI == null || this.tabs.containsKey(fileURI)) {
            return false;
        }
        Proof proof = this.mainWindow.getMediator().getSelectedProof();
        FileRepo repo = proof.getInitConfig().getFileRepo();
        try (InputStream is = repo.getInputStream(fileURI.toURL());){
            if (is != null) {
                Tab tab = new Tab(fileURI, is);
                this.tabs.put(fileURI, tab);
                this.tabPane.addTab(tab.simpleFileName, tab);
                int index = this.tabPane.indexOfComponent(tab);
                this.tabPane.setToolTipTextAt(index, tab.absoluteFileName.toString());
                tab.paintSymbExHighlights();
                boolean bl = true;
                return bl;
            }
        }
        throw new IOException("Could not open file: " + fileURI);
    }

    private void clear() {
        this.lines = null;
        this.tabs.clear();
        this.tabPane.removeAll();
    }

    private void updateGUI() {
        Node currentNode = this.mainWindow.getMediator().getSelectedNode();
        if (currentNode != null) {
            this.lines = this.constructLinesSet(currentNode);
            if (this.lines == null) {
                this.tabPane.setBorder(new TitledBorder(NO_SOURCE));
                this.sourceStatusBar.setText(NO_SOURCE);
                return;
            }
            try {
                this.addFiles();
            }
            catch (IOException e) {
                LOGGER.debug("Caught exception!", (Throwable)e);
            }
        }
        this.tabs.values().forEach(rec$ -> ((Tab)rec$).paintSymbExHighlights());
        if (this.tabPane.getTabCount() > 0) {
            Tab t;
            PositionInfo p;
            this.tabPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            PositionInfo positionInfo = p = this.lines.isEmpty() ? null : (PositionInfo)this.lines.getFirst().second;
            if (p != null && (t = this.tabs.get(p.getURI())) != null) {
                String s = t.simpleFileName;
                for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                    if (!this.tabPane.getTitleAt(i).equals(s)) continue;
                    this.tabPane.setSelectedIndex(i);
                    int line = ((PositionInfo)this.lines.getFirst().second).getEndPosition().getLine();
                    t.scrollToLine(line);
                }
            }
            this.sourceStatusBar.setText(SourceView.collectPathInformation(currentNode));
        } else {
            this.tabPane.setBorder(new TitledBorder(NO_SOURCE));
            this.sourceStatusBar.setText(NO_SOURCE);
        }
    }

    private void addPosToList(PositionInfo pos, LinkedList<Pair<Node, PositionInfo>> list, Node node) {
        if (pos != null && !pos.equals(PositionInfo.UNDEFINED) && pos.startEndValid() && pos.getURI() != null) {
            list.addLast((Pair<Node, PositionInfo>)new Pair((Object)node, (Object)pos));
            ((ProofJavaSourceCollection)node.proof().lookup(ProofJavaSourceCollection.class)).addRelevantFile(pos.getURI());
        }
    }

    private LinkedList<Pair<Node, PositionInfo>> constructLinesSet(final Node node) {
        LinkedList<Pair<Node, PositionInfo>> list = new LinkedList<Pair<Node, PositionInfo>>();
        if (node == null) {
            return null;
        }
        Node cur = node;
        do {
            SourceElement activeStatement;
            if ((activeStatement = cur.getNodeInfo().getActiveStatement()) == null) continue;
            this.addPosToList(SourceView.joinPositionsRec(activeStatement), list, cur);
        } while ((cur = cur.parent()) != null);
        if (list.isEmpty()) {
            node.sequent().forEach(formula -> formula.formula().execPostOrder(new Visitor(){

                public boolean visitSubtree(Term visited) {
                    return visited.containsJavaBlockRecursive();
                }

                public void visit(Term visited) {
                }

                public void subtreeLeft(Term subtreeRoot) {
                }

                public void subtreeEntered(Term subtreeRoot) {
                    if (subtreeRoot.javaBlock() != null) {
                        JavaASTVisitor visitor = new JavaASTVisitor((ProgramElement)subtreeRoot.javaBlock().program(), SourceView.this.mainWindow.getMediator().getServices()){

                            protected void doDefaultAction(SourceElement el) {
                                if (el instanceof MethodBodyStatement) {
                                    MethodBodyStatement mb = (MethodBodyStatement)el;
                                    Statement body = mb.getBody(this.services);
                                    PositionInfo posInf = null;
                                    if (body != null) {
                                        posInf = body.getPositionInfo();
                                    } else {
                                        IProgramMethod pm = mb.getProgramMethod(this.services);
                                        if (pm != null) {
                                            posInf = pm.getPositionInfo();
                                        }
                                    }
                                    if (posInf != null && posInf.getURI() != null) {
                                        if (!posInf.getURI().equals(PositionInfo.UNKNOWN_URI)) {
                                            ((ProofJavaSourceCollection)node.proof().lookup(ProofJavaSourceCollection.class)).addRelevantFile(posInf.getURI());
                                        } else if (!posInf.getParentClassURI().equals(PositionInfo.UNKNOWN_URI)) {
                                            ((ProofJavaSourceCollection)node.proof().lookup(ProofJavaSourceCollection.class)).addRelevantFile(posInf.getParentClassURI());
                                        }
                                    }
                                }
                            }
                        };
                        visitor.start();
                    }
                }
            }));
        }
        return list;
    }

    private static PositionInfo joinPositionsRec(SourceElement se) {
        if (se instanceof NonTerminalProgramElement) {
            if (se instanceof If || se instanceof Then || se instanceof Else) {
                return PositionInfo.UNDEFINED;
            }
            NonTerminalProgramElement ntpe = (NonTerminalProgramElement)se;
            PositionInfo pos = se.getPositionInfo();
            for (int i = 0; i < ntpe.getChildCount(); ++i) {
                ProgramElement pe2 = ntpe.getChildAt(i);
                pos = PositionInfo.join((PositionInfo)pos, (PositionInfo)SourceView.joinPositionsRec((SourceElement)pe2));
            }
            return pos;
        }
        return se.getPositionInfo();
    }

    private static String collectPathInformation(Node node) {
        while (node != null) {
            String label;
            if (node.getNodeInfo() != null && node.getNodeInfo().getBranchLabel() != null && ((label = node.getNodeInfo().getBranchLabel()).equals("Invariant Initially Valid") || label.equals("Invariant Preserved and Used") || label.equals("Body Preserves Invariant") || label.equals("Use Case") || label.equals("Show Axiom Satisfiability") || label.startsWith("Pre (") || label.startsWith("Exceptional Post (") || label.startsWith("Post (") || label.contains("Normal Execution") || label.contains("Null Reference") || label.contains("Index Out of Bounds") || label.contains("Validity") || label.contains("Precondition") || label.contains("Usage"))) {
                return label;
            }
            node = node.parent();
        }
        return "Show Postcondition/Assignable";
    }

    static {
        NORMAL_HIGHLIGHT_COLOR = ColorSettings.define("[SourceView]normalHighlight", "Color for highlighting symbolically executed lines in source view", new Color(194, 245, 194));
        MOST_RECENT_HIGHLIGHT_COLOR = ColorSettings.define("[SourceView]mostRecentHighlight", "Color for highlighting most recently symbolically executed line in source view", new Color(57, 210, 81));
        TAB_HIGHLIGHT_COLOR = ColorSettings.define("[SourceView]tabHighlight", "Color for highlighting source view tabs whose files contain highlighted lines.", new Color(57, 210, 81));
    }

    private final class TextPaneMouseAdapter
    extends MouseAdapter {
        final IOUtil.LineInformation[] li;
        final JTextPane textPane;
        final URI fileURI;

        private TextPaneMouseAdapter(JTextPane textPane, IOUtil.LineInformation[] li, URI fileURI) {
            this.textPane = textPane;
            this.li = li;
            this.fileURI = fileURI;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int pos = this.textPane.viewToModel(e.getPoint());
            if (SourceView.this.isHighlighted(e.getPoint())) {
                int line;
                for (line = 0; line < this.li.length - 1 && (this.li[line].getOffset() > pos || pos >= this.li[line + 1].getOffset()); ++line) {
                }
                Node n = null;
                for (Pair pair : SourceView.this.lines) {
                    if (((PositionInfo)pair.second).getStartPosition().getLine() != line + 1 || !((PositionInfo)pair.second).getURI().equals(this.fileURI)) continue;
                    n = (Node)pair.first;
                    break;
                }
                if (n != null) {
                    SourceView.this.mainWindow.getMediator().getSelectionModel().setSelectedNode(n);
                }
            }
        }
    }

    public static final class Highlight
    implements Comparable<Highlight> {
        private static final Map<Highlight, Object> TAGS = new HashMap<Highlight, Object>();
        private final int level;
        private final Color color;
        private final URI fileURI;
        private int line;

        private Highlight(URI fileURI, int line, Color color, int level) {
            this.level = level;
            this.color = color;
            this.fileURI = fileURI;
            this.line = line;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
            result = 31 * result + (this.fileURI == null ? 0 : this.fileURI.hashCode());
            result = 31 * result + this.level;
            result = 31 * result + this.line;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Highlight other = (Highlight)obj;
            if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
                return false;
            }
            if (this.fileURI == null ? other.fileURI != null : !this.fileURI.equals(other.fileURI)) {
                return false;
            }
            if (this.level != other.level) {
                return false;
            }
            return this.line == other.line;
        }

        @Override
        public int compareTo(Highlight other) {
            int result = this.fileURI.compareTo(other.fileURI);
            if (result == 0) {
                result = Integer.compare(this.line, other.line);
            }
            if (result == 0) {
                result = Integer.compare(this.level, other.level);
            }
            if (result == 0) {
                result = Integer.compare(this.color.getRGB(), other.color.getRGB());
            }
            return result;
        }

        private void setTag(Object tag) {
            if (tag == null) {
                TAGS.remove(this);
            } else {
                TAGS.put(this, tag);
            }
        }

        private Object getTag() {
            return TAGS.get(this);
        }

        public int getLevel() {
            return this.level;
        }

        public Color getColor() {
            return this.color;
        }

        public URI getFileURI() {
            return this.fileURI;
        }

        public int getLine() {
            return this.line;
        }
    }

    private final class Tab
    extends JScrollPane {
        private static final long serialVersionUID = -8964428275919622930L;
        private final URI absoluteFileName;
        private final String simpleFileName;
        private final JTextPane textPane = new JTextPane(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                if (!ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isShowSourceViewTooltips()) {
                    return null;
                }
                if (SourceView.this.isHighlighted(mouseEvent.getPoint())) {
                    return SourceView.TEXTPANE_HIGHLIGHTED_TOOLTIP;
                }
                return null;
            }
        };
        private IOUtil.LineInformation[] lineInformation;
        private String source;
        private Highlight selectionHL;
        private final Map<Integer, SortedSet<Highlight>> highlights = new HashMap<Integer, SortedSet<Highlight>>();

        private Tab(URI fileURI, InputStream stream) {
            this.absoluteFileName = fileURI;
            this.simpleFileName = this.extractFileName(fileURI);
            try {
                String text = IOUtil.readFrom((InputStream)stream);
                this.source = text != null && !text.isEmpty() ? SourceView.replaceTabs(text) : "[SOURCE COULD NOT BE LOADED]";
            }
            catch (IOException e) {
                this.source = "[SOURCE COULD NOT BE LOADED]";
                LOGGER.debug("Unknown IOException!", (Throwable)e);
            }
            this.initLineInfo();
            this.initTextPane();
            JPanel nowrap = new JPanel(new BorderLayout());
            nowrap.add(this.textPane);
            this.setViewportView(nowrap);
            this.setHorizontalScrollBarPolicy(30);
            this.setVerticalScrollBarPolicy(20);
            this.getVerticalScrollBar().setUnitIncrement(30);
            this.getHorizontalScrollBar().setUnitIncrement(30);
            TextLineNumber tln = new TextLineNumber(this.textPane, 1);
            this.setRowHeaderView(tln);
        }

        private String extractFileName(URI uri) {
            String s = uri.toString();
            int index = s.lastIndexOf("/");
            if (index < 0) {
                return s;
            }
            return s.substring(index + 1);
        }

        private void initLineInfo() {
            try {
                ByteArrayInputStream inStream = new ByteArrayInputStream(this.source.getBytes());
                this.lineInformation = IOUtil.computeLineInformation((InputStream)inStream);
            }
            catch (IOException e) {
                LOGGER.debug("Error while computing line information from {}", (Object)this.absoluteFileName, (Object)e);
            }
        }

        private void initTextPane() {
            this.textPane.setFont(UIManager.getFont("KEY_FONT_CURRENT_GOAL_VIEW"));
            this.textPane.setToolTipText("");
            this.textPane.setEditable(false);
            this.textPane.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (SourceView.this.isHighlighted(mouseEvent.getPoint())) {
                        Tab.this.textPane.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        Tab.this.textPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            try {
                JavaDocument doc = new JavaDocument();
                this.textPane.setDocument(doc);
                doc.insertString(0, this.source, new SimpleAttributeSet());
            }
            catch (BadLocationException e) {
                throw new AssertionError();
            }
            this.textPane.addMouseMotionListener(new MouseMotionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseMoved(MouseEvent e) {
                    SourceView sourceView = SourceView.this;
                    synchronized (sourceView) {
                        if (Tab.this.selectionHL != null) {
                            Tab.this.paintSelectionHighlight(e.getPoint(), Tab.this.selectionHL);
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.textPane.addMouseListener(new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseExited(MouseEvent e) {
                    SourceView sourceView = SourceView.this;
                    synchronized (sourceView) {
                        if (Tab.this.selectionHL != null) {
                            SourceView.this.removeHighlight(Tab.this.selectionHL);
                            Tab.this.selectionHL = null;
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseEntered(MouseEvent e) {
                    SourceView sourceView = SourceView.this;
                    synchronized (sourceView) {
                        if (Tab.this.selectionHL == null) {
                            Tab.this.initSelectionHL();
                        }
                    }
                }
            });
            this.textPane.addMouseListener(new TextPaneMouseAdapter(this.textPane, this.lineInformation, this.absoluteFileName));
        }

        private void markTabComponent() {
            if (this.highlights.isEmpty()) {
                SourceView.this.tabPane.setForegroundAt(SourceView.this.tabPane.indexOfComponent(this), UIManager.getColor("TabbedPane.foreground"));
                SourceView.this.tabPane.setBackgroundAt(SourceView.this.tabPane.indexOfComponent(this), UIManager.getColor("TabbedPane.background"));
            } else if (SourceView.this.isSelected(this)) {
                SourceView.this.tabPane.setForegroundAt(SourceView.this.tabPane.indexOfComponent(this), TAB_HIGHLIGHT_COLOR.get());
                SourceView.this.tabPane.setBackgroundAt(SourceView.this.tabPane.indexOfComponent(this), UIManager.getColor("TabbedPane.background"));
            } else {
                SourceView.this.tabPane.setForegroundAt(SourceView.this.tabPane.indexOfComponent(this), UIManager.getColor("TabbedPane.foreground"));
                SourceView.this.tabPane.setBackgroundAt(SourceView.this.tabPane.indexOfComponent(this), TAB_HIGHLIGHT_COLOR.get());
            }
        }

        private void initSelectionHL() {
            try {
                this.selectionHL = SourceView.this.addHighlight(this.absoluteFileName, 1, CurrentGoalView.DEFAULT_HIGHLIGHT_COLOR.get(), 0x7FFFFFFE);
            }
            catch (IOException | BadLocationException e) {
                LOGGER.debug("Caught exception!", (Throwable)e);
            }
        }

        private void removeHighlights(int line) {
            SortedSet<Highlight> set = this.highlights.get(line);
            if (set == null) {
                return;
            }
            for (Highlight highlight : set) {
                if (highlight.getTag() == null) continue;
                this.textPane.getHighlighter().removeHighlight(highlight.getTag());
                highlight.setTag(null);
            }
        }

        private void applyHighlights(int line) throws BadLocationException {
            SortedSet<Highlight> set = this.highlights.get(line);
            if (set != null && !set.isEmpty()) {
                for (Highlight highlight : set) {
                    Range range = SourceView.calculateLineRange(this.textPane, this.lineInformation[highlight.getLine() - 1].getOffset());
                    Color c = highlight.getColor();
                    int alpha = set.size() == 1 ? c.getAlpha() : 256 / set.size();
                    Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                    highlight.setTag(this.textPane.getHighlighter().addHighlight(range.start(), range.end(), new DefaultHighlighter.DefaultHighlightPainter(color)));
                }
            }
            this.textPane.revalidate();
            this.textPane.repaint();
        }

        private void paintSymbExHighlights() {
            for (Highlight hl : SourceView.this.symbExHighlights) {
                SourceView.this.removeHighlight(hl);
            }
            SourceView.this.symbExHighlights.clear();
            if (SourceView.this.lines == null) {
                return;
            }
            try {
                int mostRecentLine = -1;
                for (int i = 0; i < SourceView.this.lines.size(); ++i) {
                    Pair<Node, PositionInfo> l = SourceView.this.lines.get(i);
                    if (!this.absoluteFileName.equals(((PositionInfo)l.second).getURI())) continue;
                    int line = ((PositionInfo)l.second).getStartPosition().getLine();
                    if (i == 0) {
                        mostRecentLine = line;
                        SourceView.this.symbExHighlights.add(SourceView.this.addHighlight(this.absoluteFileName, line, MOST_RECENT_HIGHLIGHT_COLOR.get(), 0));
                        continue;
                    }
                    if (line == mostRecentLine) continue;
                    SourceView.this.symbExHighlights.add(SourceView.this.addHighlight(this.absoluteFileName, line, NORMAL_HIGHLIGHT_COLOR.get(), 0));
                }
            }
            catch (IOException | BadLocationException e) {
                LOGGER.debug("Caught exception!", (Throwable)e);
            }
        }

        private void paintSelectionHighlight(Point p, Highlight highlight) {
            try {
                int line = this.posToLine(this.textPane.viewToModel(p));
                SourceView.this.changeHighlight(highlight, line);
            }
            catch (BadLocationException e) {
                LOGGER.debug("Caught exception!", (Throwable)e);
            }
        }

        private int posToLine(int pos) {
            return this.textPane.getDocument().getDefaultRootElement().getElementIndex(pos) + 1;
        }

        private void scrollToLine(int line) {
            int offs = this.lineInformation[line].getOffset();
            this.textPane.setCaretPosition(offs);
        }
    }

    private static final class TabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = -5438740208669700183L;

        private TabbedPane() {
        }

        Tab getSelectedTab() {
            return (Tab)this.getSelectedComponent();
        }
    }
}

