/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.sourceview;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.sourceview.SourceView;
import de.uka.ilkd.key.gui.utilities.ClosableTabComponent;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class SourceViewFrame
extends JSplitPane {
    private static final long serialVersionUID = 382427737154314400L;
    private final SourceView sourceView;
    private final JTabbedPane tabbedPane;
    private final int dividerSize;
    private boolean tabbedPaneShown;

    public SourceViewFrame(MainWindow mainWindow) {
        super(0);
        this.sourceView = SourceView.getSourceView(mainWindow);
        this.tabbedPane = new JTabbedPane();
        this.setResizeWeight(1.0);
        this.setOneTouchExpandable(true);
        this.setLeftComponent(this.sourceView);
        this.setRightComponent(this.tabbedPane);
        this.dividerSize = this.getDividerSize();
        this.hideTabbedPane();
    }

    private void hideTabbedPane() {
        this.tabbedPaneShown = false;
        this.setDividerLocation(1.0);
        this.setDividerSize(0);
    }

    private void showTabbedPane() {
        this.tabbedPaneShown = true;
        this.setDividerLocation(0.5);
        this.setDividerSize(this.dividerSize);
    }

    public void addComponent(final JComponent component) {
        this.addComponent(component, null, new AbstractAction(){
            private static final long serialVersionUID = -3905660332423077705L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceViewFrame.this.removeComponent(component);
            }
        });
    }

    public void toFront(JComponent component) throws IllegalArgumentException {
        this.tabbedPane.setSelectedComponent(component);
    }

    public void addComponent(JComponent component, String toolTipText, Action closeAction) {
        this.tabbedPane.add(component);
        this.tabbedPane.setTabComponentAt(this.tabbedPane.indexOfComponent(component), new ClosableTabComponent(component.getName(), closeAction));
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfComponent(component), toolTipText);
        if (!this.tabbedPaneShown) {
            this.showTabbedPane();
        }
        this.toFront(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(JComponent component) {
        this.tabbedPane.remove(component);
        Object object = this.tabbedPane.getTreeLock();
        synchronized (object) {
            if (this.tabbedPaneShown && this.tabbedPane.getComponentCount() == 1) {
                this.hideTabbedPane();
            }
        }
    }
}

