/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.utilities;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class BracketMatchingTextArea
extends JTextArea
implements CaretListener {
    private static final long serialVersionUID = 1649172317561172229L;
    private static final Color HIGHLIGHT_COLOR_SAME_PARENS = Color.LIGHT_GRAY;
    private static final Color HIGHLIGHT_COLOR_DIFFERENT_PARENS = Color.RED;
    private static final Highlighter.HighlightPainter SAME_PAINTER = new BorderPainter(HIGHLIGHT_COLOR_SAME_PARENS);
    private static final Highlighter.HighlightPainter DIFF_PAINTER = new BorderPainter(HIGHLIGHT_COLOR_DIFFERENT_PARENS);
    private static final String OPENING_PARENS = "({[";
    private static final String CLOSING_PARENS = ")}]";
    private Object theSameParensHighlight;
    private Object theDiffParensHighlight;

    public BracketMatchingTextArea() {
        this.init();
    }

    public BracketMatchingTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.init();
    }

    public BracketMatchingTextArea(Document doc) {
        super(doc);
        this.init();
    }

    public BracketMatchingTextArea(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public BracketMatchingTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.init();
    }

    public BracketMatchingTextArea(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.addCaretListener(this);
        DefaultHighlighter highlight = new DefaultHighlighter();
        this.setHighlighter(highlight);
        try {
            this.theSameParensHighlight = highlight.addHighlight(0, 0, SAME_PAINTER);
            this.theDiffParensHighlight = highlight.addHighlight(0, 0, DIFF_PAINTER);
        }
        catch (BadLocationException e) {
            throw new Error(e);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        Object theHighlight = this.theSameParensHighlight;
        try {
            int dot = this.getCaretPosition();
            String text = this.getText();
            char charOn = dot == text.length() ? (char)'\u0000' : text.charAt(dot);
            char charBefore = dot == 0 ? (char)'\u0000' : text.charAt(dot - 1);
            int begin = -1;
            int end = -1;
            if (OPENING_PARENS.indexOf(charOn) != -1) {
                end = this.findMatchingClose(dot);
                if (end > 0) {
                    ++end;
                }
                begin = dot;
            } else if (CLOSING_PARENS.indexOf(charBefore) != -1) {
                end = dot;
                begin = this.findMatchingOpen(dot - 1);
            }
            if (end != -1 && begin != -1) {
                assert (begin < end) : "begin=" + begin + " end=" + end;
                assert (end > 0);
                theHighlight = CLOSING_PARENS.indexOf(text.charAt(end - 1)) != OPENING_PARENS.indexOf(text.charAt(begin)) ? this.theDiffParensHighlight : this.theSameParensHighlight;
                this.getHighlighter().changeHighlight(theHighlight, begin, end);
            } else {
                this.resetHighlights();
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            try {
                this.resetHighlights();
            }
            catch (BadLocationException ex2) {
                throw new Error(ex2);
            }
        }
    }

    protected void resetHighlights() throws BadLocationException {
        this.getHighlighter().changeHighlight(this.theSameParensHighlight, 0, 0);
        this.getHighlighter().changeHighlight(this.theDiffParensHighlight, 0, 0);
    }

    private int findMatchingClose(int dot) {
        int count = 0;
        String text = this.getText();
        do {
            if (OPENING_PARENS.indexOf(text.charAt(dot)) != -1) {
                ++count;
            } else if (CLOSING_PARENS.indexOf(text.charAt(dot)) != -1) {
                --count;
            }
            if (count != 0) continue;
            return dot;
        } while (++dot < text.length());
        return -1;
    }

    private int findMatchingOpen(int dot) {
        int count = 0;
        String text = this.getText();
        do {
            if (OPENING_PARENS.indexOf(text.charAt(dot)) != -1) {
                --count;
            } else if (CLOSING_PARENS.indexOf(text.charAt(dot)) != -1) {
                ++count;
            }
            if (count != 0) continue;
            return dot;
        } while (--dot >= 0);
        return -1;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Test bracket matching text area");
        f.getContentPane().add(new BracketMatchingTextArea("nothing", 10, 10));
        f.setSize(200, 200);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public static class BorderPainter
    implements Highlighter.HighlightPainter {
        private final Color highlightColor;

        public BorderPainter(Color highlightColor) {
            this.highlightColor = highlightColor;
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            if (offs0 == offs1) {
                return;
            }
            Rectangle alloc = bounds.getBounds();
            try {
                TextUI mapper = c.getUI();
                Rectangle p0 = mapper.modelToView(c, offs0);
                Rectangle p1 = mapper.modelToView(c, offs1);
                g.setColor(this.highlightColor);
                if (p0.y == p1.y) {
                    Rectangle r = p0.union(p1);
                    g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
                } else {
                    int p0ToMarginWidth = alloc.x + alloc.width - p0.x;
                    g.drawRect(p0.x, p0.y, p0ToMarginWidth, p0.height);
                    if (p0.y + p0.height != p1.y) {
                        g.drawRect(alloc.x, p0.y + p0.height, alloc.width - 1, p1.y - (p0.y + p0.height) - 1);
                    }
                    g.drawRect(alloc.x, p1.y, p1.x - alloc.x - 1, p1.height - 1);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

