/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.utilities;

import de.uka.ilkd.key.gui.utilities.ClickableMessageBox;
import de.uka.ilkd.key.gui.utilities.StdDialog;
import de.uka.ilkd.key.gui.utilities.TrafficLight;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CheckedUserInput
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TrafficLight trafficLight;
    private JTextPane inputFieldForFormula;
    private ClickableMessageBox infoBox;
    private JScrollPane detailScrollPane;
    private CheckedUserInputInspector inspector;
    private final List<CheckedUserInputListener> listeners = new LinkedList<CheckedUserInputListener>();

    public CheckedUserInput(boolean showInformation) {
        this(new CheckedUserInputInspector(){

            @Override
            public String check(String toBeChecked) {
                return null;
            }
        }, showInformation);
    }

    public CheckedUserInput(CheckedUserInputInspector inspector, boolean showInformation) {
        this.inspector = inspector;
        this.setLayout(new BoxLayout(this, 1));
        Box horzBox = Box.createHorizontalBox();
        JScrollPane pane = new JScrollPane(this.getInputFieldForFormula());
        horzBox.add(pane);
        horzBox.add(Box.createHorizontalStrut(5));
        horzBox.add(this.getTrafficLight());
        Dimension dim = pane.getPreferredSize();
        dim.height = this.getTrafficLight().getPreferredSize().height;
        pane.setPreferredSize(dim);
        pane.setMinimumSize(dim);
        this.add(horzBox);
        this.add(Box.createVerticalStrut(2));
        if (showInformation) {
            horzBox = Box.createHorizontalBox();
            horzBox.add(Box.createHorizontalStrut(5));
            horzBox.add(Box.createHorizontalGlue());
            this.add(horzBox);
            horzBox = Box.createHorizontalBox();
            horzBox.add(this.getDetailScrollPane());
            horzBox.add(Box.createHorizontalGlue());
            this.add(horzBox);
            this.add(Box.createVerticalGlue());
        }
        this.setInput("");
    }

    public void setInspector(CheckedUserInputInspector inspector) {
        this.inspector = inspector;
        this.checkInput();
    }

    public JScrollPane getDetailScrollPane() {
        if (this.detailScrollPane == null) {
            this.detailScrollPane = new JScrollPane(this.getInfoBox());
            this.detailScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.detailScrollPane.setPreferredSize(new Dimension(this.detailScrollPane.getPreferredSize().width, 80));
            this.detailScrollPane.setMinimumSize(new Dimension(this.detailScrollPane.getPreferredSize().width, 80));
            this.detailScrollPane.setBorder(BorderFactory.createTitledBorder("Details"));
        }
        return this.detailScrollPane;
    }

    private TrafficLight getTrafficLight() {
        if (this.trafficLight == null) {
            this.trafficLight = new TrafficLight(10);
        }
        return this.trafficLight;
    }

    private ClickableMessageBox getInfoBox() {
        if (this.infoBox == null) {
            this.infoBox = new ClickableMessageBox();
            this.infoBox.setBackground(this.getBackground());
            this.infoBox.setFont(this.getFont());
            this.infoBox.add(new ClickableMessageBox.ClickableMessageBoxListener(){

                @Override
                public void eventMessageClicked(Object object) {
                    if (object != null) {
                        JOptionPane.showMessageDialog(CheckedUserInput.this.detailScrollPane, object, "Problem Description", 1);
                    }
                }
            });
        }
        return this.infoBox;
    }

    private JTextPane getInputFieldForFormula() {
        if (this.inputFieldForFormula == null) {
            this.inputFieldForFormula = new JTextPane();
            this.inputFieldForFormula.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CheckedUserInput.this.checkInput();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CheckedUserInput.this.checkInput();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        return this.inputFieldForFormula;
    }

    private void checkInput() {
        String text = this.inputFieldForFormula.getText();
        String result = this.inspector.check(text);
        this.setValid(result);
        for (CheckedUserInputListener listener : this.listeners) {
            listener.userInputChanged(text, result == null, result);
        }
    }

    public void addListener(CheckedUserInputListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CheckedUserInputListener listener) {
        this.listeners.remove(listener);
    }

    public String getInput() {
        return this.getInputFieldForFormula().getText();
    }

    public void setInput(String input) {
        this.getInputFieldForFormula().setText(input == null ? "" : input);
        this.checkInput();
    }

    private void setValid(String result) {
        this.getInfoBox().clear();
        if (result != null) {
            String[] segments = result.split("#");
            this.getInfoBox().add(segments.length >= 2 ? segments[1] : null, segments[0], Color.RED);
        }
        this.getTrafficLight().setGreen(result == null);
    }

    public static String showAsDialog(String title, String description, final String helpText, String defaultInput, CheckedUserInputInspector inspector, boolean showInformation) {
        CheckedUserInput userInput = new CheckedUserInput(inspector, showInformation);
        Box vertBox = Box.createVerticalBox();
        if (description != null) {
            Box horzBox = Box.createHorizontalBox();
            horzBox.add(new JLabel(description));
            horzBox.add(Box.createHorizontalGlue());
            vertBox.add(horzBox);
            vertBox.add(Box.createVerticalStrut(5));
        }
        vertBox.add(userInput);
        final StdDialog dialog = new StdDialog(title, vertBox, 5, helpText != null);
        userInput.addListener((input, valid, reason) -> dialog.getOkButton().setEnabled(valid));
        dialog.getHelpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(dialog, helpText, "Help", 1);
            }
        });
        userInput.setInput(defaultInput);
        Dimension dim = dialog.getPreferredSize();
        dialog.setSize(Math.max(dim.width, dialog.getOkButton().getWidth() * 4), dim.height);
        dialog.setVisible(true);
        if (dialog.okButtonHasBeenPressed()) {
            return userInput.getInput();
        }
        return null;
    }

    public static void main(String[] args) {
        CheckedUserInput.showAsDialog("Checked user input embedded in a dialog.", "type 'test'", "that is only a test", "default", new CheckedUserInputInspector(){

            @Override
            public String check(String toBeChecked) {
                return toBeChecked.equals("test") ? null : "Syntax Error#test";
            }
        }, true);
    }

    public static interface CheckedUserInputListener {
        public void userInputChanged(String var1, boolean var2, String var3);
    }

    public static interface CheckedUserInputInspector {
        public static final String NO_USER_INPUT = " ";

        public String check(String var1);
    }
}

