/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.utilities;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class ClickableMessageBox
extends JTextPane {
    private static final long serialVersionUID = 7588093268080119674L;
    private ArrayList<Object> items = new ArrayList();
    private LinkedList<ClickableMessageBoxListener> listeners = new LinkedList();
    private HTMLEditorKit kit = new HTMLEditorKit();
    private HTMLDocument doc = new HTMLDocument();

    public ClickableMessageBox() {
        this.setEditorKit(this.kit);
        this.setDocument(this.doc);
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    int index = Integer.parseInt(e.getDescription());
                    Object item = ClickableMessageBox.this.items.get(index);
                    for (ClickableMessageBoxListener listener : ClickableMessageBox.this.listeners) {
                        listener.eventMessageClicked(item);
                    }
                }
            }
        });
    }

    public void clear() {
        this.items.clear();
        this.setText("");
    }

    public void add(ClickableMessageBoxListener listener) {
        this.listeners.add(listener);
    }

    public void add(Object item, String message, Color color) {
        try {
            if (item != null) {
                this.kit.insertHTML(this.doc, this.doc.getLength(), "<u><a href=\"" + this.items.size() + "\" style=\"color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\">" + message + "</a></u>", 0, 0, null);
            } else {
                this.kit.insertHTML(this.doc, this.doc.getLength(), "<font color= rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\">" + message + "</font>", 0, 0, null);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.items.add(item);
    }

    public static interface ClickableMessageBoxListener {
        public void eventMessageClicked(Object var1);
    }
}

