/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.utilities;

import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.pp.PosInSequent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public final class GuiUtilities {
    private static final String ESC_COMMAND = "ESC";

    private GuiUtilities() {
        throw new Error("Do not instantiate");
    }

    public static void paintEmptyViewComponent(JComponent pane, String name) {
        pane.setBorder(new TitledBorder(name));
        pane.setBackground(Color.white);
        if (pane instanceof JScrollPane) {
            ((JScrollPane)pane).getViewport().setBackground(Color.white);
        }
        pane.setMinimumSize(new Dimension(150, 0));
    }

    public static void copyHighlightToClipboard(SequentView view, PosInSequent pos) {
        String s = view.getHighlightedText(pos).replace('\u00a0', ' ');
        StringSelection ss = new StringSelection(s);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.getSystemClipboard().setContents(ss, ss);
    }

    public static void setCenter(Component comp) {
        Dimension screenSize = comp.getToolkit().getScreenSize();
        Dimension frameSize = comp.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        comp.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void setCenter(Component comp, Component parent) {
        if (parent == null) {
            GuiUtilities.setCenter(comp);
            return;
        }
        Dimension dlgSize = comp.getPreferredSize();
        Dimension frmSize = parent.getSize();
        Point loc = parent.getLocation();
        if (dlgSize.width < frmSize.width && dlgSize.height < frmSize.height) {
            comp.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        } else {
            GuiUtilities.setCenter(comp);
        }
    }

    public static void attachClickOnEscListener(JButton button) {
        ActionListener escapeListener = event -> {
            if (event.getActionCommand().equals(ESC_COMMAND)) {
                button.doClick();
            }
        };
        button.registerKeyboardAction(escapeListener, ESC_COMMAND, KeyStroke.getKeyStroke(27, 0), 2);
    }
}

