/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.utilities;

import de.uka.ilkd.key.gui.utilities.CheckedUserInput;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.nparser.KeyIO;

public class InspectorForFormulas
implements CheckedUserInput.CheckedUserInputInspector {
    private final Services services;

    public InspectorForFormulas(Services services) {
        this.services = services;
    }

    @Override
    public String check(String toBeChecked) {
        if (toBeChecked.isEmpty()) {
            return " ";
        }
        Term term = InspectorForFormulas.translate(this.services, toBeChecked);
        if (term == null) {
            return " ";
        }
        if (term.sort() != Sort.FORMULA) {
            return "Not a formula.";
        }
        return null;
    }

    public static Term translate(Services services, String toBeChecked) {
        try {
            return new KeyIO(services).parseExpression(toBeChecked);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

