/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.utilities;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class SquigglyUnderlinePainter
implements Highlighter.HighlightPainter {
    private final Color highlightColor;
    private final Stroke stroke;
    private final int squiggleSize;

    public SquigglyUnderlinePainter(Color highlightColor, int squiggleSize, float lineWidth) {
        this.highlightColor = highlightColor;
        this.stroke = new BasicStroke(lineWidth);
        this.squiggleSize = squiggleSize;
    }

    @Override
    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        if (offs0 == offs1) {
            return;
        }
        if (bounds != null) {
            try {
                g.setColor(this.highlightColor);
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setStroke(this.stroke);
                }
                TextUI mapper = c.getUI();
                Rectangle p0 = mapper.modelToView(c, offs0);
                Rectangle p1 = mapper.modelToView(c, offs1);
                int twoSquiggles = this.squiggleSize * 2;
                int y = p0.y + p0.height - this.squiggleSize;
                for (int x = p0.x; x <= p0.x + (p1.x - p0.x) - twoSquiggles; x += twoSquiggles) {
                    g.drawArc(x, y, this.squiggleSize, this.squiggleSize, 180, -180);
                    g.drawArc(x + this.squiggleSize, y, this.squiggleSize, this.squiggleSize, -180, 180);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

