/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.utilities;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class StdDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton helpButton;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okButtonHasBeenPressed = false;
    private boolean cancelButtonHasBeenPressed = false;
    private Box contentBox;

    public StdDialog(String title, int strut, boolean helpButton) {
        this(title, null, strut, helpButton);
    }

    public StdDialog(String title, JComponent content, int strut, boolean helpButton) {
        this.setLocationByPlatform(true);
        this.setTitle(title);
        this.setModal(true);
        Box vertBox = Box.createVerticalBox();
        Box horzBox = Box.createHorizontalBox();
        vertBox.add(Box.createVerticalStrut(strut));
        horzBox.add(Box.createHorizontalStrut(strut));
        horzBox.add(this.getContentBox());
        horzBox.add(Box.createHorizontalGlue());
        horzBox.add(Box.createHorizontalStrut(strut));
        vertBox.add(horzBox);
        vertBox.add(Box.createVerticalStrut(strut));
        horzBox = Box.createHorizontalBox();
        horzBox.add(Box.createHorizontalStrut(strut));
        if (helpButton) {
            horzBox.add(this.getHelpButton());
            horzBox.add(Box.createHorizontalStrut(strut));
        }
        horzBox.add(Box.createHorizontalGlue());
        horzBox.add(this.getOkButton());
        horzBox.add(Box.createHorizontalStrut(strut));
        horzBox.add(this.getCancelButton());
        horzBox.add(Box.createHorizontalStrut(strut));
        vertBox.add(horzBox);
        vertBox.add(Box.createVerticalStrut(strut));
        this.getContentPane().add(vertBox);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StdDialog.this.getCancelButton().doClick();
            }
        });
        if (content != null) {
            this.setContent(content);
        } else {
            this.pack();
        }
    }

    public void setContent(JComponent content) {
        this.getContentBox().removeAll();
        this.getContentBox().add(content);
        content.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.pack();
    }

    public boolean okButtonHasBeenPressed() {
        return this.okButtonHasBeenPressed;
    }

    public boolean cancelButtonHasBeenPressed() {
        return this.cancelButtonHasBeenPressed;
    }

    public JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton("Help");
        }
        return this.helpButton;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StdDialog.this.okButtonHasBeenPressed = true;
                    StdDialog.this.dispose();
                }
            });
            this.okButton.setMnemonic(79);
        }
        return this.okButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StdDialog.this.cancelButtonHasBeenPressed = true;
                    StdDialog.this.dispose();
                }
            });
            this.cancelButton.setMnemonic(67);
        }
        return this.cancelButton;
    }

    private Box getContentBox() {
        if (this.contentBox == null) {
            this.contentBox = Box.createVerticalBox();
            this.contentBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }
        return this.contentBox;
    }

    public static void main(String[] args) {
        final StdDialog dialog = new StdDialog("Test", new JButton("Test"), 5, true);
        dialog.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(dialog, "OK");
            }
        });
        dialog.setModal(true);
        dialog.setVisible(true);
    }
}

