/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof.io;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.notification.events.ExceptionFailureEvent;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.proof.io.AbstractProblemLoader;
import de.uka.ilkd.key.proof.io.ProblemLoaderControl;
import de.uka.ilkd.key.prover.ProverTaskListener;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskFinishedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskStartedInfo;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingWorker;

public final class ProblemLoader
extends AbstractProblemLoader {
    private final ProverTaskListener ptl;
    private final KeYMediator mediator;

    public ProblemLoader(File file, List<File> classPath, File bootClassPath, List<File> includes, Profile profileOfNewProofs, boolean forceNewProfileOfNewProofs, KeYMediator mediator, boolean askUiToSelectAProofObligationIfNotDefinedByLoadedFile, Properties poPropertiesToForce, ProverTaskListener ptl) {
        super(file, classPath, bootClassPath, includes, profileOfNewProofs, forceNewProfileOfNewProofs, (ProblemLoaderControl)mediator.getUI(), askUiToSelectAProofObligationIfNotDefinedByLoadedFile, poPropertiesToForce);
        this.mediator = mediator;
        this.ptl = ptl;
    }

    public void runSynchronously() {
        Throwable message;
        this.mediator.stopInterface(true);
        this.fireTaskStarted();
        long currentTime = System.currentTimeMillis();
        try {
            message = this.doWork();
        }
        catch (Throwable ex) {
            message = ex;
        }
        long runTime = System.currentTimeMillis() - currentTime;
        this.fireTaskFinished(runTime, message);
    }

    private Throwable doWork() {
        try {
            this.load();
            return null;
        }
        catch (Exception exception) {
            String errorMessage = "Failed to load " + (this.getEnvInput() == null ? "problem/proof" : this.getEnvInput().name());
            this.mediator.notify(new ExceptionFailureEvent(errorMessage, exception));
            this.mediator.getUI().reportStatus((Object)this, errorMessage);
            return exception;
        }
    }

    private void fireTaskStarted() {
        if (this.ptl != null) {
            this.ptl.taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Loading, "Loading problem ...", 0));
        }
    }

    private void fireTaskFinished(long runningTime, Throwable message) {
        if (this.ptl != null) {
            DefaultTaskFinishedInfo tfi = new DefaultTaskFinishedInfo((Object)this, (Object)message, this.getProof(), runningTime, this.getProof() != null ? this.getProof().countNodes() : 0, this.getProof() != null ? this.getProof().countBranches() - this.getProof().openGoals().size() : 0);
            this.ptl.taskFinished((TaskFinishedInfo)tfi);
        }
    }

    protected void selectAndLoadProof(ProblemLoaderControl control, InitConfig initConfig) {
        if (control.selectProofObligation(initConfig)) {
            this.setProof(this.mediator.getSelectedProof());
        }
    }

    public void runAsynchronously() {
        SwingWorker<Throwable, Void> worker = new SwingWorker<Throwable, Void>(){
            private long runTime;

            @Override
            protected Throwable doInBackground() throws Exception {
                long currentTime = System.currentTimeMillis();
                Throwable message = ProblemLoader.this.doWork();
                this.runTime = System.currentTimeMillis() - currentTime;
                return message;
            }

            @Override
            protected void done() {
                ProblemLoader.this.mediator.startInterface(true);
                Throwable message = null;
                try {
                    message = (Throwable)this.get();
                }
                catch (Throwable exception) {
                    message = exception;
                }
                finally {
                    ProblemLoader.this.fireTaskFinished(this.runTime, message);
                }
            }
        };
        this.mediator.stopInterface(true);
        this.fireTaskStarted();
        worker.execute();
    }
}

