/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof.mgt;

import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.mgt.EnvNode;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.proof.mgt.ProofStatus;
import de.uka.ilkd.key.proof.mgt.TaskTreeModel;
import de.uka.ilkd.key.proof.mgt.TaskTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class BasicTask
extends DefaultMutableTreeNode
implements TaskTreeNode {
    private static final long serialVersionUID = -6490453248054760812L;
    private ProofAggregate proof;

    public BasicTask(ProofAggregate pl) {
        super(pl);
        this.proof = pl;
    }

    @Override
    public String shortDescr() {
        return this.proof().name().toString();
    }

    @Override
    public String toString() {
        return this.shortDescr();
    }

    @Override
    public ProofEnvironment getProofEnv() {
        return this.proof().getEnv();
    }

    @Override
    public Proof proof() {
        return this.proof.getFirstProof();
    }

    @Override
    public Proof[] allProofs() {
        return new Proof[]{this.proof()};
    }

    @Override
    public void insertNode(TaskTreeModel model, MutableTreeNode parentNode) {
        model.insertNodeInto(this, parentNode, model.getChildCount(parentNode));
    }

    @Override
    public ProofStatus getStatus() {
        return this.proof().mgt().getStatus();
    }

    public TaskTreeNode getRootTask() {
        TaskTreeNode tn = this;
        while (!(tn.getParent() instanceof EnvNode)) {
            tn = (TaskTreeNode)tn.getParent();
        }
        return tn;
    }

    @Override
    public void decoupleFromEnv() {
        this.getProofEnv().removeProofList(this.proof);
    }

    @Override
    public TaskTreeNode[] getChildren() {
        return NO_CHILDREN;
    }
}

