/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof.mgt;

import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.SingleProof;
import de.uka.ilkd.key.proof.mgt.BasicTask;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.proof.mgt.ProofStatus;
import de.uka.ilkd.key.proof.mgt.TaskTreeModel;
import de.uka.ilkd.key.proof.mgt.TaskTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class ProofAggregateTask
extends DefaultMutableTreeNode
implements TaskTreeNode {
    private static final long serialVersionUID = 2292876929382788414L;
    private TaskTreeNode[] proofs;
    private ProofAggregate proofList;
    private String descr;

    public ProofAggregateTask(ProofAggregate ps) {
        super(ps);
        this.proofs = new TaskTreeNode[ps.size()];
        for (int i = 0; i < ps.size(); ++i) {
            this.proofs[i] = ps.getChildrenAt(i) instanceof SingleProof ? new BasicTask(ps.getChildrenAt(i)) : new ProofAggregateTask(ps.getChildrenAt(i));
        }
        this.proofList = ps;
        this.descr = ps.description();
    }

    @Override
    public String shortDescr() {
        return this.descr;
    }

    @Override
    public String toString() {
        return this.shortDescr();
    }

    @Override
    public ProofEnvironment getProofEnv() {
        return this.proofs[0].proof().getEnv();
    }

    public ProofAggregate getProofList() {
        return this.proofList;
    }

    @Override
    public Proof proof() {
        return this.proofs[0].proof();
    }

    @Override
    public Proof[] allProofs() {
        return this.getProofList().getProofs();
    }

    @Override
    public void insertNode(TaskTreeModel model, MutableTreeNode parentNode) {
        model.insertNodeInto(this, parentNode, model.getChildCount(parentNode));
        for (TaskTreeNode proof : this.proofs) {
            proof.insertNode(model, this);
        }
    }

    @Override
    public ProofStatus getStatus() {
        return this.proofList.getStatus();
    }

    @Override
    public void decoupleFromEnv() {
        this.getProofEnv().removeProofList(this.proofList);
    }

    @Override
    public TaskTreeNode[] getChildren() {
        return this.proofs;
    }
}

