/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof.mgt;

import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.mgt.BasicTask;
import de.uka.ilkd.key.proof.mgt.EnvNode;
import de.uka.ilkd.key.proof.mgt.ProofAggregateTask;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.proof.mgt.TaskTreeNode;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class TaskTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = -4168248377205879699L;
    private Map<Proof, TaskTreeNode> proofToTask = new LinkedHashMap<Proof, TaskTreeNode>();

    public TaskTreeModel() {
        super(new DefaultMutableTreeNode("Tasks"));
    }

    public void addTask(TaskTreeNode p) {
        ProofEnvironment env = p.getProofEnv();
        int size = this.getChildCount(this.getRoot());
        for (int i = 0; i < size; ++i) {
            MutableTreeNode envNode = (MutableTreeNode)this.getChild(this.getRoot(), i);
            if (!env.equals((Object)((EnvNode)envNode).getProofEnv())) continue;
            p.insertNode(this, envNode);
            this.updateProofToTask(p);
            return;
        }
        EnvNode envNode = new EnvNode(env);
        this.insertNodeInto(envNode, (MutableTreeNode)this.getRoot(), size);
        this.updateProofToTask(p);
        p.insertNode(this, envNode);
    }

    public void removeTask(TaskTreeNode p) {
        Proof[] allProofs = p.allProofs();
        for (int i = 0; i < allProofs.length; ++i) {
            this.proofToTask.remove(allProofs[i]);
            p.decoupleFromEnv();
        }
        ProofEnvironment env = p.getProofEnv();
        if (p.getParent().getChildCount() == 1) {
            env = null;
            p = (TaskTreeNode)p.getParent();
        }
        if (p.getParent() != null) {
            this.removeNodeFromParent(p);
        }
        if (env != null && !env.getProofs().isEmpty()) {
            ((ProofAggregate)env.getProofs().iterator().next()).getProofs()[0].mgt().updateProofStatus();
        }
    }

    private void updateProofToTask(TaskTreeNode p) {
        this.proofToTask.put(p.proof(), p);
        for (TaskTreeNode child : p.getChildren()) {
            this.updateProofToTask(child);
        }
    }

    public TaskTreeNode getTaskForProof(Proof p) {
        if (p == null) {
            return null;
        }
        return this.proofToTask.get(p);
    }

    public TaskTreeNode addProof(ProofAggregate plist) {
        DefaultMutableTreeNode bp = plist.size() == 1 ? new BasicTask(plist) : new ProofAggregateTask(plist);
        this.addTask((TaskTreeNode)((Object)bp));
        return bp;
    }
}

