/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.ui;

import de.uka.ilkd.key.control.AbstractUserInterfaceControl;
import de.uka.ilkd.key.control.RuleCompletionHandler;
import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.notification.events.NotificationEvent;
import de.uka.ilkd.key.informationflow.macros.StartSideProofMacro;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.macros.ProofMacroFinishedInfo;
import de.uka.ilkd.key.macros.SkipMacro;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.event.ProofDisposedEvent;
import de.uka.ilkd.key.proof.event.ProofDisposedListener;
import de.uka.ilkd.key.proof.init.AbstractProfile;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.proof.io.ProblemLoader;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.proof.mgt.ProofEnvironmentEvent;
import de.uka.ilkd.key.proof.mgt.ProofEnvironmentListener;
import de.uka.ilkd.key.prover.ProverTaskListener;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskStartedInfo;
import de.uka.ilkd.key.ui.MediatorProofControl;
import de.uka.ilkd.key.util.KeYResourceManager;
import de.uka.ilkd.key.util.MiscTools;
import de.uka.ilkd.key.util.ThreadUtilities;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMediatorUserInterfaceControl
extends AbstractUserInterfaceControl
implements RuleCompletionHandler,
ProofEnvironmentListener,
ProofDisposedListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMediatorUserInterfaceControl.class);
    protected boolean saveOnly = false;
    private final MediatorProofControl proofControl = this.createProofControl();
    private ProofMacro autoMacro = new SkipMacro();

    public MediatorProofControl getProofControl() {
        return this.proofControl;
    }

    protected MediatorProofControl createProofControl() {
        return new MediatorProofControl(this);
    }

    public void setSaveOnly(boolean s) {
        this.saveOnly = s;
    }

    public boolean isSaveOnly() {
        return this.saveOnly;
    }

    public void setMacro(ProofMacro macro) {
        assert (macro != null);
        this.autoMacro = macro;
    }

    public ProofMacro getMacro() {
        return this.autoMacro;
    }

    public boolean macroChosen() {
        return !(this.getMacro() instanceof SkipMacro);
    }

    public abstract void openExamples();

    public abstract KeYMediator getMediator();

    public abstract void loadProblem(File var1);

    public abstract void loadProofFromBundle(File var1, File var2);

    public ProblemLoader getProblemLoader(File file, List<File> classPath, File bootClassPath, List<File> includes, KeYMediator mediator) {
        ProblemLoader pl = new ProblemLoader(file, classPath, bootClassPath, includes, AbstractProfile.getDefaultProfile(), false, mediator, true, null, (ProverTaskListener)this);
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyMacro() {
        assert (this.macroChosen());
        ProofMacro macro = this.getMacro();
        if (macro.canApplyTo(this.getMediator().getSelectedNode(), null)) {
            LOGGER.debug("[ APPLY " + this.getMacro().getClass().getSimpleName() + " ]");
            Proof proof = this.getMediator().getSelectedProof();
            ProofMacroFinishedInfo info = ProofMacroFinishedInfo.getDefaultInfo((ProofMacro)macro, (Proof)proof);
            AbstractMediatorUserInterfaceControl ptl = this;
            try {
                this.getMediator().stopInterface(true);
                this.getMediator().setInteractive(false);
                ptl.taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Macro, macro.getName(), 0));
                ProofMacro proofMacro = macro;
                synchronized (proofMacro) {
                    info = macro.applyTo((UserInterfaceControl)this, this.getMediator().getSelectedNode(), null, (ProverTaskListener)ptl);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Proof macro has been interrupted:", (Throwable)ex);
            }
            catch (Exception e) {
                LOGGER.debug("Exception occurred during macro application:", (Throwable)e);
            }
            finally {
                ptl.taskFinished((TaskFinishedInfo)info);
                this.getMediator().setInteractive(true);
                this.getMediator().startInterface(true);
            }
            return true;
        }
        LOGGER.info("{} not applicable!", (Object)macro.getClass().getSimpleName());
        return false;
    }

    protected void macroFinished(final ProofMacroFinishedInfo info) {
        super.macroFinished(info);
        if (info.getMacro() instanceof StartSideProofMacro) {
            final Proof initiatingProof = (Proof)info.getValueFor("originalProof");
            info.getProof().addProofDisposedListener(new ProofDisposedListener(){

                public void proofDisposing(ProofDisposedEvent e) {
                    e.getSource().removeProofDisposedListener((ProofDisposedListener)this);
                    AbstractMediatorUserInterfaceControl.this.macroSideProofDisposing(info, initiatingProof, e.getSource());
                }

                public void proofDisposed(ProofDisposedEvent e) {
                }
            });
            ThreadUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractMediatorUserInterfaceControl.this.getMediator().stopInterface(true);
                    AbstractMediatorUserInterfaceControl.this.getMediator().setInteractive(false);
                }
            });
        }
    }

    protected void macroSideProofDisposing(ProofMacroFinishedInfo initiatingInfo, final Proof initiatingProof, final Proof sideProof) {
        ThreadUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractMediatorUserInterfaceControl.this.saveSideProof(sideProof);
                AbstractMediatorUserInterfaceControl.this.getMediator().startInterface(true);
                if (initiatingProof.closed()) {
                    AbstractMediatorUserInterfaceControl.this.getMediator().getSelectionModel().setSelectedNode(initiatingProof.root());
                } else {
                    AbstractMediatorUserInterfaceControl.this.getMediator().getSelectionModel().setSelectedGoal((Goal)initiatingProof.openGoals().head());
                }
                AbstractMediatorUserInterfaceControl.this.getMediator().stopInterface(true);
            }
        });
    }

    private void saveSideProof(Proof proof) {
        String proofName = proof.name().toString();
        if (proofName.endsWith(".key")) {
            proofName = proofName.substring(0, proofName.lastIndexOf(".key"));
        } else if (proofName.endsWith(".proof")) {
            proofName = proofName.substring(0, proofName.lastIndexOf(".proof"));
        }
        String filename = MiscTools.toValidFileName((String)proofName) + ".proof";
        File proofFolder = proof.getProofFile() != null ? proof.getProofFile().getParentFile() : Main.getWorkingDir();
        File toSave = new File(proofFolder, filename);
        KeYResourceManager krm = KeYResourceManager.getManager();
        ProofSaver ps = new ProofSaver(proof, toSave.getAbsolutePath(), krm.getSHA1());
        try {
            ps.save();
        }
        catch (IOException e) {
            this.reportException((Object)this, null, e);
        }
    }

    public ProofEnvironment createProofEnvironmentAndRegisterProof(ProofOblInput proofOblInput, ProofAggregate proofList, InitConfig initConfig) {
        ProofEnvironment env = new ProofEnvironment(initConfig);
        env.addProofEnvironmentListener((ProofEnvironmentListener)this);
        env.registerProof(proofOblInput, proofList);
        return env;
    }

    public void proofUnregistered(ProofEnvironmentEvent event) {
        if (event.getSource().getProofs().isEmpty()) {
            event.getSource().removeProofEnvironmentListener((ProofEnvironmentListener)this);
        }
    }

    public void notifyAutoModeBeingStarted() {
    }

    public void notifyAutomodeStopped() {
    }

    public abstract void notify(NotificationEvent var1);

    public boolean confirmTaskRemoval(String string) {
        return true;
    }

    public void proofDisposing(ProofDisposedEvent e) {
        e.getSource().removeProofDisposedListener((ProofDisposedListener)this);
    }

    public void proofDisposed(ProofDisposedEvent e) {
    }

    public void proofRegistered(ProofEnvironmentEvent event) {
        this.registerProofAggregate(event.getProofList());
    }

    public void registerProofAggregate(ProofAggregate pa) {
        for (Proof proof : pa.getProofs()) {
            proof.addProofDisposedListener((ProofDisposedListener)this);
        }
    }
}

