/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.ui;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProblemInitializer;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.speclang.Contract;
import de.uka.ilkd.key.ui.ConsoleUserInterfaceControl;
import de.uka.ilkd.key.ui.ProofObligationSelector;
import de.uka.ilkd.key.util.KeYTypeUtil;
import de.uka.ilkd.key.util.ProgressMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.key_project.util.collection.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleProofObligationSelector
implements ProofObligationSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleProofObligationSelector.class);
    public static final String TAB = "   ";
    private final KeYMediator mediator;
    protected InitConfig initConfig;
    protected ConsoleUserInterfaceControl ui;
    protected List<Contract> contracts;

    public ConsoleProofObligationSelector(ConsoleUserInterfaceControl ui, InitConfig initConfig) {
        this.ui = ui;
        this.mediator = ui.getMediator();
        this.initConfig = initConfig;
        this.initializeContractsArray();
    }

    private void initializeContractsArray() {
        ImmutableSet contracts = this.initConfig.getServices().getSpecificationRepository().getAllContracts();
        this.contracts = new ArrayList<Contract>();
        for (Contract c : contracts) {
            if (KeYTypeUtil.isLibraryClass((KeYJavaType)c.getKJT())) continue;
            this.contracts.add(c);
        }
    }

    protected void printAvailableProofObligations() {
        LOGGER.info("Available Contracts: ");
        for (int i = 0; i < this.contracts.size(); ++i) {
            this.printContract(i);
        }
    }

    private void printContract(int i) {
        LOGGER.info("Contract " + i + ":");
        LOGGER.info("   Method: " + this.contracts.get(i).getTarget().name());
        LOGGER.info("   PO:" + this.contracts.get(i).getDisplayName());
    }

    protected ProofOblInput createPOForSelectedContract() {
        Contract contract = this.selectContract();
        LOGGER.info("Contract: " + contract);
        return contract == null ? null : contract.createProofObl(this.initConfig, contract);
    }

    protected void findOrStartProof(ProofOblInput po) {
        Proof proof = this.findPreferablyClosedProof(po);
        if (proof == null) {
            ProblemInitializer pi = new ProblemInitializer((ProgressMonitor)this.ui, this.initConfig.getServices(), (ProblemInitializer.ProblemInitializerListener)this.ui);
            try {
                ProofAggregate pl = pi.startProver(this.initConfig, po);
                this.ui.createProofEnvironmentAndRegisterProof(po, pl, this.initConfig);
                this.mediator.setProof(pl.getFirstProof());
            }
            catch (ProofInputException exc) {
                exc.printStackTrace();
            }
        } else {
            this.mediator.setProof(proof);
        }
    }

    private Proof findPreferablyClosedProof(ProofOblInput po) {
        ImmutableSet proofs = this.initConfig.getServices().getSpecificationRepository().getProofs(po);
        if (proofs.isEmpty()) {
            return null;
        }
        for (Proof proof : proofs) {
            if (!proof.mgt().getStatus().getProofClosed()) continue;
            return proof;
        }
        return (Proof)proofs.iterator().next();
    }

    @Override
    public boolean selectProofObligation() {
        ProofOblInput po = this.createPOForSelectedContract();
        this.findOrStartProof(po);
        return true;
    }

    private Contract selectContract() {
        this.printAvailableProofObligations();
        LOGGER.info("Choose PO, enter number between 0 and " + (this.contracts.size() - 1));
        int cNr = this.readContractNumber();
        return this.contracts.get(cNr);
    }

    private int readContractNumber() {
        int i = -1;
        while (i == -1) {
            try {
                System.out.print("PO nr: ");
                i = this.readInt();
                if (i >= 0 && i < this.contracts.size()) {
                    return i;
                }
                i = -1;
                LOGGER.error("Contract number out of range!");
            }
            catch (NumberFormatException e) {
                LOGGER.info("NumberFormatException!", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("IOException!", (Throwable)e);
            }
        }
        return -1;
    }

    private int readInt() throws NumberFormatException, IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        return Integer.parseInt(br.readLine());
    }
}

