/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.ui;

import de.uka.ilkd.key.control.AbstractProofControl;
import de.uka.ilkd.key.control.AbstractUserInterfaceControl;
import de.uka.ilkd.key.control.TermLabelVisibilityManager;
import de.uka.ilkd.key.control.instantiation_model.TacletInstantiationModel;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.actions.ShowProofStatistics;
import de.uka.ilkd.key.gui.notification.events.NotificationEvent;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.macros.ProofMacroFinishedInfo;
import de.uka.ilkd.key.macros.SkipMacro;
import de.uka.ilkd.key.macros.scripts.ProofScriptEngine;
import de.uka.ilkd.key.parser.Location;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.Statistics;
import de.uka.ilkd.key.proof.event.ProofDisposedEvent;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProblemInitializer;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.proof.io.ProblemLoader;
import de.uka.ilkd.key.prover.ProverCore;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskStartedInfo;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.speclang.PositionedString;
import de.uka.ilkd.key.ui.AbstractMediatorUserInterfaceControl;
import de.uka.ilkd.key.ui.ConsoleProofObligationSelector;
import de.uka.ilkd.key.util.MiscTools;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.ProgressMonitor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.collection.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleUserInterfaceControl
extends AbstractMediatorUserInterfaceControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleUserInterfaceControl.class);
    private static final int PROGRESS_BAR_STEPS = 50;
    private static final String PROGRESS_MARK = ">";
    ImmutableList<Proof> proofStack = ImmutableSLList.nil();
    final byte verbosity;
    final KeYMediator mediator;
    int progressMax = 0;
    private final boolean loadOnly;
    private File keyProblemFile = null;
    public boolean allProofsSuccessful = true;

    public ConsoleUserInterfaceControl(byte verbosity, boolean loadOnly) {
        this.verbosity = verbosity;
        this.mediator = new KeYMediator(this);
        this.loadOnly = loadOnly;
    }

    public ConsoleUserInterfaceControl(boolean verbose, boolean loadOnly) {
        this(verbose ? (byte)4 : 1, loadOnly);
    }

    private void printResults(int openGoals, TaskFinishedInfo info, Object result2) {
        if (this.verbosity >= 3) {
            LOGGER.info("]");
        }
        if (this.verbosity > 0) {
            LOGGER.info("[ DONE  ... rule application ]");
            if (this.verbosity >= 3) {
                LOGGER.info("\n== Proof {} ==", (Object)(openGoals > 0 ? "open" : "closed"));
                Statistics stat = info.getProof().getStatistics();
                LOGGER.info("Proof steps: {}", (Object)stat.nodes);
                LOGGER.info("Branches: {}", (Object)stat.branches);
                LOGGER.info("Automode Time: {} ms", (Object)stat.autoModeTimeInMillis);
                LOGGER.info("Time per step: {} ms", (Object)Float.valueOf(stat.timePerStepInMillis));
            }
            LOGGER.info("Number of goals remaining open: {}", (Object)openGoals);
            if (openGoals == 0) {
                LOGGER.info("Proved");
            } else {
                LOGGER.info("Not proved");
            }
        }
        Runtime.getRuntime().gc();
        assert (this.keyProblemFile != null) : "Unexcpected null pointer. Trying to save a proof but no corresponding key problem file is available.";
        this.allProofsSuccessful &= ConsoleUserInterfaceControl.saveProof(result2, info.getProof(), this.keyProblemFile);
        this.keyProblemFile = null;
    }

    public void taskFinished(TaskFinishedInfo info) {
        ProblemLoader problemLoader;
        super.taskFinished(info);
        this.progressMax = 0;
        Proof proof = info.getProof();
        if (proof == null) {
            if (this.verbosity > 0) {
                LOGGER.info("Proof loading failed");
                Object error = info.getResult();
                if (error instanceof Throwable) {
                    ((Throwable)error).printStackTrace();
                }
            }
            System.exit(1);
        }
        int openGoals = proof.openGoals().size();
        Object result2 = info.getResult();
        if (info.getSource() instanceof ProverCore || info.getSource() instanceof ProofMacro) {
            if (!this.isAtLeastOneMacroRunning()) {
                this.printResults(openGoals, info, result2);
            }
        } else if (info.getSource() instanceof ProblemLoader) {
            LOGGER.debug("{}", result2);
            System.exit(-1);
        }
        if (this.loadOnly || openGoals == 0) {
            LOGGER.info("Number of open goals after loading: {}", (Object)openGoals);
            System.exit(0);
        }
        if ((problemLoader = (ProblemLoader)((Object)info.getSource())).hasProofScript()) {
            try {
                Pair script = problemLoader.readProofScript();
                ProofScriptEngine pse = new ProofScriptEngine((String)script.first, (Location)script.second);
                this.taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Macro, "Script started", 0));
                pse.execute((AbstractUserInterfaceControl)this, proof);
                this.taskFinished((TaskFinishedInfo)new ProofMacroFinishedInfo((ProofMacro)new SkipMacro(), proof));
            }
            catch (Exception e) {
                LOGGER.debug("", (Throwable)e);
                System.exit(-1);
            }
        } else if (this.macroChosen()) {
            this.applyMacro();
        } else {
            this.finish(proof);
        }
    }

    public void taskStarted(TaskStartedInfo info) {
        super.taskStarted(info);
        this.progressMax = info.getSize();
        if (TaskStartedInfo.TaskKind.Strategy.equals((Object)info.getKind())) {
            System.out.println(info.getMessage() + " [");
        } else {
            System.out.println(info.getMessage());
        }
    }

    @Override
    public void loadProblem(File file) {
        this.keyProblemFile = file;
        this.getProblemLoader(file, null, null, null, this.mediator).runSynchronously();
    }

    public void loadProblem(File file, List<File> classPath, File bootClassPath, List<File> includes) {
        ProblemLoader problemLoader = this.getProblemLoader(file, classPath, bootClassPath, includes, this.getMediator());
        problemLoader.runAsynchronously();
    }

    @Override
    public void loadProofFromBundle(File proofBundle, File proofFilename) {
        ProblemLoader problemLoader = this.getProblemLoader(proofBundle, null, null, null, this.getMediator());
        problemLoader.setProofPath(proofFilename);
        problemLoader.runAsynchronously();
    }

    @Override
    public void registerProofAggregate(ProofAggregate pa) {
        super.registerProofAggregate(pa);
        this.mediator.setProof(pa.getFirstProof());
        this.proofStack = this.proofStack.prepend((Object)pa.getFirstProof());
    }

    void finish(Proof proof) {
        this.mediator.setInteractive(false);
        this.getProofControl().startAndWaitForAutoMode(proof);
        LOGGER.debug("{}", (Object)proof.getStatistics());
    }

    public final void progressStarted(Object sender) {
        LOGGER.debug("ConsoleUserInterfaceControl.progressStarted({})", sender);
    }

    public final void progressStopped(Object sender) {
        LOGGER.debug("ConsoleUserInterfaceControl.progressStopped({})", sender);
    }

    public final void reportException(Object sender, ProofOblInput input, Exception e) {
        LOGGER.debug("ConsoleUserInterfaceControl.reportException({},{},{})", new Object[]{sender, input, e});
    }

    public final void reportStatus(Object sender, String status, int progress) {
        LOGGER.debug("ConsoleUserInterfaceControl.reportStatus({},{},{})", new Object[]{sender, status, progress});
    }

    public final void reportStatus(Object sender, String status) {
        LOGGER.debug("ConsoleUserInterfaceControl.reportStatus({},{})", sender, (Object)status);
    }

    public final void resetStatus(Object sender) {
        LOGGER.debug("ConsoleUserInterfaceControl.resetStatus({})", sender);
    }

    public final void taskProgress(int position) {
        super.taskProgress(position);
        if (this.verbosity >= 3 && this.progressMax > 0 && position * 50 % this.progressMax == 0) {
            System.out.print(PROGRESS_MARK);
        }
    }

    public final void setMaximum(int maximum) {
        LOGGER.debug("ConsoleUserInterfaceControl.setMaximum({})", (Object)maximum);
    }

    public final void setProgress(int progress) {
        LOGGER.debug("ConsoleUserInterfaceControl.setProgress({})", (Object)progress);
    }

    public void completeAndApplyTacletMatch(TacletInstantiationModel[] models, Goal goal) {
        LOGGER.debug("Taclet match completion not supported by console.");
    }

    @Override
    public final void openExamples() {
        LOGGER.info("Open Examples not suported by console UI.");
    }

    public final ProblemInitializer createProblemInitializer(Profile profile) {
        return new ProblemInitializer((ProgressMonitor)this, new Services(profile), (ProblemInitializer.ProblemInitializerListener)this);
    }

    @Override
    public void proofDisposing(ProofDisposedEvent e) {
        super.proofDisposing(e);
        if (!this.proofStack.isEmpty()) {
            Proof p = (Proof)this.proofStack.head();
            this.proofStack = this.proofStack.removeAll((Object)p);
            assert (p.name().equals((Object)e.getSource().name()));
            this.mediator.setProof((Proof)this.proofStack.head());
        }
    }

    public final boolean selectProofObligation(InitConfig initConfig) {
        ConsoleProofObligationSelector sel = new ConsoleProofObligationSelector(this, initConfig);
        return sel.selectProofObligation();
    }

    @Override
    public KeYMediator getMediator() {
        return this.mediator;
    }

    @Override
    public void notify(NotificationEvent event) {
        LOGGER.trace("{}", (Object)event);
    }

    public IBuiltInRuleApp completeBuiltInRuleApp(IBuiltInRuleApp app, Goal goal, boolean forced) {
        return AbstractProofControl.completeBuiltInRuleAppByDefault((IBuiltInRuleApp)app, (Goal)goal, (boolean)forced);
    }

    public void reportWarnings(ImmutableSet<PositionedString> warnings) {
        warnings.forEach(it -> LOGGER.info("{}", it));
    }

    public static boolean saveProof(Object result, Proof proof, File keyProblemFile) {
        File f;
        if (result instanceof Throwable) {
            throw new RuntimeException("Error in batchmode.", (Throwable)result);
        }
        String baseName = keyProblemFile.getAbsolutePath();
        int idx = baseName.indexOf(".key");
        if (idx == -1) {
            idx = baseName.indexOf(".proof");
        }
        baseName = baseName.substring(0, idx == -1 ? baseName.length() : idx);
        int counter = 0;
        do {
            f = new File(baseName + ".auto." + counter + ".proof");
            ++counter;
        } while (f.exists());
        try {
            proof.saveToFile(new File(f.getAbsolutePath()));
            proof.saveToFile(new File(baseName + ".auto.proof"));
            ShowProofStatistics.getCSVStatisticsMessage(proof);
            File file = new File(MiscTools.toValidFileName((String)proof.name().toString()) + ".csv");
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
                writer.write(ShowProofStatistics.getCSVStatisticsMessage(proof));
            }
            catch (IOException e) {
                e.printStackTrace();
                assert (false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return proof.openGoals().size() == 0;
    }

    public TermLabelVisibilityManager getTermLabelVisibilityManager() {
        return null;
    }
}

