/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.ui;

import de.uka.ilkd.key.control.AbstractProofControl;
import de.uka.ilkd.key.control.RuleCompletionHandler;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.ProofMacroWorker;
import de.uka.ilkd.key.gui.notification.events.GeneralFailureEvent;
import de.uka.ilkd.key.gui.notification.events.GeneralInformationEvent;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.prover.ProverTaskListener;
import de.uka.ilkd.key.prover.impl.ApplyStrategy;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.ui.AbstractMediatorUserInterfaceControl;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import org.key_project.util.collection.ImmutableList;

public class MediatorProofControl
extends AbstractProofControl {
    private final AbstractMediatorUserInterfaceControl ui;
    private AutoModeWorker worker;

    public MediatorProofControl(AbstractMediatorUserInterfaceControl ui) {
        super((ProverTaskListener)ui, (RuleCompletionHandler)ui);
        this.ui = ui;
    }

    public boolean selectedTaclet(Taclet taclet, Goal goal, PosInOccurrence pos) {
        boolean result = super.selectedTaclet(taclet, goal, pos);
        if (!result) {
            this.ui.notify(new GeneralFailureEvent("Taclet application failed." + taclet.name()));
        }
        return result;
    }

    public void fireAutoModeStarted(ProofEvent e) {
        super.fireAutoModeStarted(e);
    }

    public void fireAutoModeStopped(ProofEvent e) {
        super.fireAutoModeStopped(e);
    }

    public void startAutoMode(Proof proof, ImmutableList<Goal> goals, ProverTaskListener ptl) {
        if (goals.isEmpty()) {
            this.ui.notify(new GeneralInformationEvent("No enabled goals available."));
            return;
        }
        this.worker = new AutoModeWorker(proof, goals, ptl);
        this.ui.getMediator().stopInterface(true);
        this.ui.getMediator().setInteractive(false);
        this.worker.execute();
    }

    public void stopAutoMode() {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.ui.getMediator().interrupt();
    }

    public void waitWhileAutoMode() {
        while (this.ui.getMediator().isInAutoMode()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isInAutoMode() {
        return this.ui.getMediator().isInAutoMode();
    }

    public boolean isAutoModeSupported(Proof proof) {
        return super.isAutoModeSupported(proof) && this.ui.getMediator().getSelectedProof() == proof;
    }

    public void runMacro(Node node, ProofMacro macro, PosInOccurrence posInOcc) {
        KeYMediator mediator = this.ui.getMediator();
        ProofMacroWorker worker = new ProofMacroWorker(node, macro, mediator, posInOcc);
        this.interactionListeners.forEach(worker::addInteractionListener);
        mediator.stopInterface(true);
        mediator.setInteractive(false);
        mediator.addInterruptedListener(worker);
        worker.execute();
    }

    private class AutoModeWorker
    extends SwingWorker<ApplyStrategyInfo, Object> {
        private final Proof proof;
        private final List<Node> initialGoals;
        private final ImmutableList<Goal> goals;
        private final ApplyStrategy applyStrategy;
        private ApplyStrategyInfo info;

        public AutoModeWorker(Proof proof, ImmutableList<Goal> goals, ProverTaskListener ptl) {
            this.proof = proof;
            this.goals = goals;
            this.initialGoals = goals.stream().map(Goal::node).collect(Collectors.toList());
            this.applyStrategy = new ApplyStrategy(proof.getInitConfig().getProfile().getSelectedGoalChooserBuilder().create());
            if (ptl != null) {
                this.applyStrategy.addProverTaskObserver(ptl);
            }
            this.applyStrategy.addProverTaskObserver(MediatorProofControl.this.getDefaultProverTaskListener());
            if (MediatorProofControl.this.ui.getMediator().getAutoSaver() != null) {
                this.applyStrategy.addProverTaskObserver((ProverTaskListener)MediatorProofControl.this.ui.getMediator().getAutoSaver());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (InterruptedException exception) {
                this.notifyException(exception);
            }
            catch (ExecutionException exception) {
                this.notifyException(exception);
            }
            catch (CancellationException cancellationException) {
            }
            finally {
                MediatorProofControl.this.worker = null;
                ApplyStrategy exception = this.applyStrategy;
                synchronized (exception) {
                    this.applyStrategy.removeProverTaskObserver((ProverTaskListener)MediatorProofControl.this.ui);
                    this.applyStrategy.clear();
                }
                MediatorProofControl.this.ui.getMediator().setInteractive(true);
                MediatorProofControl.this.ui.getMediator().startInterface(true);
                this.emitInteractiveAutoMode(this.initialGoals, this.proof, this.info);
            }
        }

        protected void emitInteractiveAutoMode(List<Node> initialGoals, Proof proof, ApplyStrategyInfo info) {
            MediatorProofControl.this.interactionListeners.forEach(l -> l.runAutoMode(initialGoals, proof, info));
        }

        private void notifyException(Exception exception) {
            MediatorProofControl.this.ui.notify(new GeneralFailureEvent("An exception occurred during strategy execution.\n Exception:" + exception));
        }

        @Override
        protected ApplyStrategyInfo doInBackground() throws Exception {
            boolean stopMode = this.proof.getSettings().getStrategySettings().getActiveStrategyProperties().getProperty("STOPMODE_OPTIONS_KEY").equals("STOPMODE_NONCLOSE");
            this.info = this.applyStrategy.start(this.proof, this.goals, MediatorProofControl.this.ui.getMediator().getMaxAutomaticSteps(), MediatorProofControl.this.ui.getMediator().getAutomaticApplicationTimeout(), stopMode);
            return this.info;
        }
    }
}

