/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util;

import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.util.CommandLineException;
import de.uka.ilkd.key.util.LinkedHashMap;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class CommandLine {
    private static final String MINUS = "--";
    private static final int DEFAULT_LINE_LENGTH = 80;
    private final Map<String, Option> options = new LinkedHashMap();
    private final List<HelpElement> helpElements = new ArrayList<HelpElement>();
    private final List<String> arguments = new LinkedList<String>();
    private int lineLength = 80;
    private int indentSize = 0;

    public void addOption(String image, String parameter, String description) {
        if (!image.startsWith(MINUS)) {
            throw new IllegalArgumentException("Parameters need to start with '--': " + image);
        }
        if (this.options.containsKey(image)) {
            throw new IllegalArgumentException(image + " has already been registered");
        }
        Option o = new Option();
        o.image = image;
        o.parameter = parameter;
        o.description = description + "\n";
        this.options.put(image, o);
        this.helpElements.add(o);
    }

    public void addText(String description, boolean identToDescriptionColumn) {
        AdditionalHelpText text = new AdditionalHelpText();
        text.description = description;
        text.indentToDescriptionColumn = identToDescriptionColumn;
        this.helpElements.add(text);
    }

    public void addTextPart(String command, String description, boolean identToDescriptionColumn) {
        AdditionalHelpTextParts text = new AdditionalHelpTextParts();
        text.command = command;
        text.description = description;
        text.indentToDescriptionColumn = identToDescriptionColumn;
        this.helpElements.add(text);
    }

    public void addSection(String text) {
        AdditionalHelpTextSection head = new AdditionalHelpTextSection();
        head.text = "\n" + text + "\n\n";
        this.helpElements.add(head);
    }

    public void parse(String[] args) throws CommandLineException {
        int cnt;
        for (cnt = 0; cnt < args.length && args[cnt].startsWith(MINUS); ++cnt) {
            if (MINUS.equals(args[cnt])) {
                ++cnt;
                break;
            }
            String current = args[cnt];
            Option option = this.options.get(current);
            if (option == null) {
                throw new CommandLineException("Unknown command line option: " + current);
            }
            if (option.parameter != null) {
                if (cnt == args.length - 1) {
                    throw new CommandLineException("Command line option " + current + " expects a parameter but did not receive one");
                }
                option.value = args[++cnt];
                continue;
            }
            option.value = "true";
        }
        while (cnt < args.length) {
            this.arguments.add(args[cnt]);
            ++cnt;
        }
    }

    public ArrayList<File> getFileArguments() {
        ArrayList<File> ret = new ArrayList<File>();
        List<String> FileNameList = Collections.unmodifiableList(this.arguments);
        for (int i = 0; i < FileNameList.size(); ++i) {
            String fileArg = FileNameList.get(i);
            File tmp = new File(fileArg);
            if (tmp.exists()) {
                ret.add(tmp);
                continue;
            }
            Main.printUsageAndExit(false, "File not found: " + fileArg, -4);
        }
        return ret;
    }

    public boolean isSet(String param) {
        Option option = this.options.get(param);
        assert (option != null) : param + " is unknown option";
        return option.value != null;
    }

    public String getString(String param, String defaultValue) {
        Option option = this.options.get(param);
        assert (option != null) : param + " is unknown option";
        assert (option.parameter != null) : param + " does not take arguments";
        String value = option.value;
        return value == null ? defaultValue : value;
    }

    public int getInteger(String param, int defaultValue) throws CommandLineException {
        Option option = this.options.get(param);
        assert (option != null) : param + " is unknown option";
        String value = option.value;
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException e) {
            throw new CommandLineException(param + " expects an integer argument, but received: " + option.value, e);
        }
    }

    public long getLong(String param, long defaultValue) throws CommandLineException {
        Option option = this.options.get(param);
        assert (option != null) : param + " is unknown option";
        String value = option.value;
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.decode(value);
        }
        catch (NumberFormatException e) {
            throw new CommandLineException(param + " expects a long integer argument, but received: " + option.value, e);
        }
    }

    public void printUsage(PrintStream stream) {
        int descriptionCol = 0;
        for (Option option : this.options.values()) {
            int len = option.image.length();
            if (option.parameter != null) {
                len += 1 + option.parameter.length();
            }
            descriptionCol = Math.max(len, descriptionCol);
        }
        descriptionCol += 2;
        for (HelpElement element : this.helpElements) {
            element.print(stream, descriptionCol);
        }
        stream.flush();
    }

    private void indent(PrintStream stream, int len) {
        for (int i = len; i > 0; --i) {
            stream.print(" ");
        }
    }

    private void printIndentedMessage(PrintStream stream, String text, int indentationLevel) {
        int textWidth = this.getLineLength() - indentationLevel;
        while (text.length() > textWidth) {
            int p = text.lastIndexOf(32, textWidth);
            if (p > 0) {
                stream.println(text.substring(0, p));
                text = text.substring(p + 1);
            } else {
                stream.println(text);
                text = "";
            }
            this.indent(stream, indentationLevel);
        }
        stream.print(text);
    }

    public int getIndentation() {
        return this.indentSize;
    }

    public void setIndentation(int indentSize) {
        this.indentSize = indentSize;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    private class AdditionalHelpTextSection
    extends HelpElement {
        private String text;

        private AdditionalHelpTextSection() {
        }

        @Override
        protected void print(PrintStream ps, int descriptionCol) {
            CommandLine.this.printIndentedMessage(ps, this.text, 0);
        }
    }

    private class AdditionalHelpText
    extends HelpElement {
        private String description;
        private boolean indentToDescriptionColumn;

        private AdditionalHelpText() {
        }

        @Override
        protected void print(PrintStream ps, int descriptionCol) {
            int indent = CommandLine.this.indentSize;
            if (this.indentToDescriptionColumn) {
                indent += descriptionCol;
            }
            CommandLine.this.indent(ps, indent);
            CommandLine.this.printIndentedMessage(ps, this.description, indent);
        }
    }

    private class AdditionalHelpTextParts
    extends HelpElement {
        private String description;
        private String command;
        private boolean indentToDescriptionColumn;

        private AdditionalHelpTextParts() {
        }

        @Override
        protected void print(PrintStream ps, int descriptionCol) {
            int indent = CommandLine.this.indentSize;
            CommandLine.this.indent(ps, indent);
            CommandLine.this.printIndentedMessage(ps, this.command, descriptionCol);
            CommandLine.this.indent(ps, descriptionCol - this.command.length());
            CommandLine.this.printIndentedMessage(ps, this.description, 0);
        }
    }

    private class Option
    extends HelpElement {
        private String description;
        private String image;
        private String value;
        private String parameter;

        private Option() {
        }

        @Override
        protected void print(PrintStream stream, int descriptionCol) {
            Object s = this.image;
            if (this.parameter != null) {
                s = (String)s + " " + this.parameter;
            }
            CommandLine.this.indent(stream, CommandLine.this.indentSize);
            stream.print((String)s);
            CommandLine.this.indent(stream, descriptionCol - ((String)s).length());
            CommandLine.this.printIndentedMessage(stream, this.description, descriptionCol + CommandLine.this.indentSize);
        }
    }

    private static abstract class HelpElement {
        private HelpElement() {
        }

        protected abstract void print(PrintStream var1, int var2);
    }
}

