/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class PreferenceSaver {
    private static Saver<?>[] SAVERS = new Saver[]{new WindowSaver(), new SplitPaneSaver(), new TabbedPaneSaver(), new AbstractButtonSaver()};
    private final Preferences prefs;

    private static <C extends Component> Saver<C> getSaver(C component) {
        for (Saver<?> saver : SAVERS) {
            if (!saver.supportedClass().isInstance(component)) continue;
            return saver;
        }
        return null;
    }

    public PreferenceSaver(Preferences prefs) {
        assert (prefs != null);
        this.prefs = prefs;
    }

    private Component[] getChildren(Component component) {
        Component[] children = component instanceof JMenu ? ((JMenu)component).getMenuComponents() : ((Container)component).getComponents();
        return children;
    }

    public void save(Component component) {
        assert (component != null);
        this.saveComponent(component);
        this.saveChildren(component);
    }

    private <C extends Component> void saveComponent(C component) {
        Saver<C> saver;
        String name = component.getName();
        if (name != null && (saver = PreferenceSaver.getSaver(component)) != null) {
            saver.save(component, this.prefs);
        }
    }

    private void saveChildren(Component component) {
        Component[] children;
        if (component instanceof Container && (children = this.getChildren(component)) != null) {
            for (Component child : children) {
                this.saveComponent(child);
                this.saveChildren(child);
            }
        }
    }

    public void load(Component component) {
        assert (component != null);
        this.loadComponent(component);
        this.loadChildren(component);
    }

    private <C extends Component> void loadComponent(C component) {
        Saver<C> saver;
        String name = component.getName();
        if (name != null && (saver = PreferenceSaver.getSaver(component)) != null) {
            saver.load(component, this.prefs);
        }
    }

    private void loadChildren(Component component) {
        Component[] children;
        if (component instanceof Container && (children = this.getChildren(component)) != null) {
            for (Component child : children) {
                this.load(child);
            }
        }
    }

    public void flush() throws BackingStoreException {
        this.prefs.flush();
    }

    private static class AbstractButtonSaver
    implements Saver<AbstractButton> {
        private AbstractButtonSaver() {
        }

        private static String getButtonId(AbstractButton component) {
            return component.getClass().getSimpleName() + "." + component.getName() + ".selected";
        }

        @Override
        public void load(AbstractButton component, Preferences prefs) {
            assert (component.getName() != null);
            boolean selected = prefs.getBoolean(AbstractButtonSaver.getButtonId(component), component.isSelected());
            component.setSelected(selected);
        }

        @Override
        public void save(AbstractButton component, Preferences prefs) {
            assert (component.getName() != null);
            boolean selected = component.isSelected();
            prefs.putBoolean(AbstractButtonSaver.getButtonId(component), selected);
        }

        @Override
        public Class<AbstractButton> supportedClass() {
            return AbstractButton.class;
        }
    }

    private static class TabbedPaneSaver
    implements Saver<JTabbedPane> {
        private TabbedPaneSaver() {
        }

        @Override
        public void load(JTabbedPane component, Preferences prefs) {
            String name = component.getName();
            assert (name != null);
            int index = component.getSelectedIndex();
            int pref = prefs.getInt(name + ".selectedIndex", index);
            component.setSelectedIndex(Math.min(pref, component.getTabCount() - 1));
        }

        @Override
        public void save(JTabbedPane component, Preferences prefs) {
            String name = component.getName();
            assert (name != null);
            int index = component.getSelectedIndex();
            prefs.putInt(name + ".selectedIndex", index);
        }

        @Override
        public Class<JTabbedPane> supportedClass() {
            return JTabbedPane.class;
        }
    }

    private static class SplitPaneSaver
    implements Saver<JSplitPane> {
        private SplitPaneSaver() {
        }

        @Override
        public void load(JSplitPane component, Preferences prefs) {
            String name = component.getName();
            assert (name != null);
            int splitPoint = component.getDividerLocation();
            component.setDividerLocation(prefs.getInt(name + ".dividerLocation", splitPoint));
        }

        @Override
        public void save(JSplitPane component, Preferences prefs) {
            String name = component.getName();
            assert (name != null);
            int splitPoint = component.getDividerLocation();
            prefs.putInt(name + ".dividerLocation", splitPoint);
        }

        @Override
        public Class<JSplitPane> supportedClass() {
            return JSplitPane.class;
        }
    }

    private static class WindowSaver
    implements Saver<Window> {
        private WindowSaver() {
        }

        @Override
        public void load(Window component, Preferences prefs) {
            String name = component.getName();
            assert (name != null);
            Rectangle bounds = component.getBounds();
            bounds.x = prefs.getInt(name + ".x", bounds.x);
            bounds.y = prefs.getInt(name + ".y", bounds.y);
            bounds.width = prefs.getInt(name + ".width", bounds.width);
            bounds.height = prefs.getInt(name + ".height", bounds.height);
            component.setBounds(bounds);
        }

        @Override
        public void save(Window component, Preferences prefs) {
            String name = component.getName();
            assert (name != null);
            Rectangle bounds = component.getBounds();
            prefs.putInt(name + ".x", bounds.x);
            prefs.putInt(name + ".y", bounds.y);
            prefs.putInt(name + ".width", bounds.width);
            prefs.putInt(name + ".height", bounds.height);
        }

        @Override
        public Class<Window> supportedClass() {
            return Window.class;
        }
    }

    private static interface Saver<C extends Component> {
        public Class<C> supportedClass();

        public void save(C var1, Preferences var2);

        public void load(C var1, Preferences var2);
    }
}

