/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtilities {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtilities.class);

    public static void invokeAndWait(Runnable runner) {
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException e) {
                LOGGER.debug("", (Throwable)e);
            }
            catch (InvocationTargetException ite) {
                Throwable targetExc = ite.getTargetException();
                LOGGER.debug("", targetExc);
                LOGGER.debug("", (Throwable)ite);
            }
        }
    }

    public static void invokeOnEventQueue(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

