/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLResources {
    private static final String RULE_RESOURCE = "/de/uka/ilkd/key/gui/help/ruleExplanations.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLResources.class);
    protected final Properties ruleExplanations = XMLResources.getResource("/de/uka/ilkd/key/gui/help/ruleExplanations.xml");
    private static final String LABEL_RESOURCE = "/de/uka/ilkd/key/gui/help/termLabelExplanations.xml";
    protected final Properties termLabelExplanations = XMLResources.getResource("/de/uka/ilkd/key/gui/help/termLabelExplanations.xml");
    static final String FUNCTION_RESOURCE = "/de/uka/ilkd/key/gui/help/functionExplanations.xml";
    protected final Properties functionExplanations = XMLResources.getResource("/de/uka/ilkd/key/gui/help/functionExplanations.xml");

    public Properties getRuleExplanations() {
        return this.ruleExplanations;
    }

    public Properties getTermLabelExplanations() {
        return this.termLabelExplanations;
    }

    public Properties getFunctionExplanations() {
        return this.functionExplanations;
    }

    private static Properties getResource(String xmlFile) {
        Properties ret = new Properties();
        try (InputStream is = XMLResources.class.getResourceAsStream(xmlFile);){
            if (is == null) {
                throw new FileNotFoundException("Descriptions file " + xmlFile + " not found.");
            }
            ret.loadFromXML(is);
        }
        catch (IOException e) {
            LOGGER.error("Cannot not load help messages in info view", (Throwable)e);
        }
        return ret;
    }
}

