/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.macros;

import de.uka.ilkd.key.macros.AbstractBlastingMacro;
import de.uka.ilkd.key.proof.rulefilter.RuleFilter;
import de.uka.ilkd.key.rule.Rule;
import java.util.HashSet;
import java.util.Set;

public final class SemanticsBlastingMacro
extends AbstractBlastingMacro {
    private final SemanticsRuleFilter semanticsFilter = new SemanticsRuleFilter();
    private final EqualityRuleFilter equalityRuleFilter = new EqualityRuleFilter();
    private final HashSet<String> allowedPullOut = new HashSet(20);

    public SemanticsBlastingMacro() {
        this.allowedPullOut.add("store");
        this.allowedPullOut.add("create");
        this.allowedPullOut.add("anon");
        this.allowedPullOut.add("memset");
        this.allowedPullOut.add("empty");
        this.allowedPullOut.add("allLocs");
        this.allowedPullOut.add("singleton");
        this.allowedPullOut.add("union");
        this.allowedPullOut.add("intersect");
        this.allowedPullOut.add("setMinus");
        this.allowedPullOut.add("allFields");
        this.allowedPullOut.add("allObjects");
        this.allowedPullOut.add("arrayRange");
        this.allowedPullOut.add("freshLocs");
        this.allowedPullOut.add("seqDef");
        this.allowedPullOut.add("seqReverse");
        this.allowedPullOut.add("seqSub");
        this.allowedPullOut.add("seqConcat");
        this.allowedPullOut.add("seqSingleton");
        this.allowedPullOut.add("infiniteUnion");
    }

    protected RuleFilter getSemanticsRuleFilter() {
        return this.semanticsFilter;
    }

    protected RuleFilter getEqualityRuleFilter() {
        return this.equalityRuleFilter;
    }

    protected Set<String> getAllowedPullOut() {
        return this.allowedPullOut;
    }

    public String getName() {
        return "Semantics Blasting";
    }

    public String getCategory() {
        return null;
    }

    public String getDescription() {
        return "Semantics Blasting";
    }

    private class EqualityRuleFilter
    implements RuleFilter {
        private HashSet<String> allowedRulesNames = new HashSet();

        private EqualityRuleFilter() {
            this.allowedRulesNames.add("equalityToElementOf");
            this.allowedRulesNames.add("equalityToSelect");
            this.allowedRulesNames.add("equalityToSeqGetAndSeqLen");
        }

        public boolean filter(Rule rule) {
            return this.allowedRulesNames.contains(rule.name().toString());
        }
    }

    private class SemanticsRuleFilter
    implements RuleFilter {
        protected HashSet<String> allowedRulesNames = new HashSet(100);

        private SemanticsRuleFilter() {
            this.allowedRulesNames.add("selectOfStore");
            this.allowedRulesNames.add("selectOfCreate");
            this.allowedRulesNames.add("selectOfAnon");
            this.allowedRulesNames.add("selectOfMemset");
            this.allowedRulesNames.add("elementOfEmpty");
            this.allowedRulesNames.add("elementOfAllLocs");
            this.allowedRulesNames.add("elementOfSingleton");
            this.allowedRulesNames.add("elementOfUnion");
            this.allowedRulesNames.add("elementOfIntersect");
            this.allowedRulesNames.add("elementOfSetMinus");
            this.allowedRulesNames.add("elementOfAllFields");
            this.allowedRulesNames.add("elementOfAllObjects");
            this.allowedRulesNames.add("elementOfArrayRange");
            this.allowedRulesNames.add("elementOfFreshLocs");
            this.allowedRulesNames.add("elementOfInfiniteUnion");
            this.allowedRulesNames.add("subsetToElementOf");
            this.allowedRulesNames.add("disjointToElementOf");
            this.allowedRulesNames.add("createdInHeapToElementOf");
            this.allowedRulesNames.add("getOfSeqDef");
            this.allowedRulesNames.add("getOfSeqSingleton");
            this.allowedRulesNames.add("getOfSeqConcat");
            this.allowedRulesNames.add("getOfSeqSub");
            this.allowedRulesNames.add("getOfSeqReverse");
            this.allowedRulesNames.add("lenOfSeqDef");
            this.allowedRulesNames.add("lenOfSeqSingleton");
            this.allowedRulesNames.add("lenOfSeqConcat");
            this.allowedRulesNames.add("lenOfSeqSub");
            this.allowedRulesNames.add("lenOfSeqReverse");
            this.allowedRulesNames.add("inByte");
            this.allowedRulesNames.add("inChar");
            this.allowedRulesNames.add("inShort");
            this.allowedRulesNames.add("inInt");
            this.allowedRulesNames.add("inLong");
            this.allowedRulesNames.add("translateJavaUnaryMinusInt");
            this.allowedRulesNames.add("translateJavaUnaryMinusLong");
            this.allowedRulesNames.add("translateJavaAddInt");
            this.allowedRulesNames.add("translateJavaAddLong");
            this.allowedRulesNames.add("translateJavaSubInt");
            this.allowedRulesNames.add("translateJavaSubLong");
            this.allowedRulesNames.add("translateJavaMulInt");
            this.allowedRulesNames.add("translateJavaMulLong");
            this.allowedRulesNames.add("translateJavaMod");
            this.allowedRulesNames.add("translateJavaDivInt");
            this.allowedRulesNames.add("translateJavaDivLong");
            this.allowedRulesNames.add("translateJavaCastByte");
            this.allowedRulesNames.add("translateJavaCastShort");
            this.allowedRulesNames.add("translateJavaCastInt");
            this.allowedRulesNames.add("translateJavaCastLong");
            this.allowedRulesNames.add("translateJavaCastChar");
            this.allowedRulesNames.add("jdiv_axiom_inline");
            this.allowedRulesNames.add("array_store_known_dynamic_array_type");
            this.allowedRulesNames.add("nonNull");
            this.allowedRulesNames.add("nonNullZero");
            this.allowedRulesNames.add("sub_literals");
            this.allowedRulesNames.add("equal_literals");
        }

        public boolean filter(Rule rule) {
            return this.allowedRulesNames.contains(rule.name().toString());
        }
    }
}

