/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.macros;

import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.Modality;
import de.uka.ilkd.key.macros.FilterStrategy;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.rule.Rule;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.settings.TestGenerationSettings;
import de.uka.ilkd.key.strategy.NumberRuleAppCost;
import de.uka.ilkd.key.strategy.RuleAppCost;
import de.uka.ilkd.key.strategy.Strategy;
import java.util.HashSet;
import java.util.Set;

class TestGenStrategy
extends FilterStrategy {
    private static final Name NAME = new Name(TestGenStrategy.class.getSimpleName());
    private static final Set<String> unwindRules = new HashSet<String>();
    private static final int UNWIND_COST = 1000;
    private final int limit = TestGenerationSettings.getInstance().getMaximalUnwinds();

    private static boolean hasModality(Term term) {
        if (term.op() instanceof Modality) {
            return true;
        }
        for (Term sub : term.subs()) {
            if (!TestGenStrategy.hasModality(sub)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModality(Node node) {
        Sequent sequent = node.sequent();
        for (SequentFormula sequentFormula : sequent) {
            if (!TestGenStrategy.hasModality(sequentFormula.formula())) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnwindRule(Rule rule) {
        if (rule == null) {
            return false;
        }
        String name = rule.name().toString();
        return unwindRules.contains(name);
    }

    public TestGenStrategy(Strategy delegate) {
        super(delegate);
    }

    public RuleAppCost computeCost(RuleApp app, PosInOccurrence pio, Goal goal) {
        if (TestGenStrategy.isUnwindRule(app.rule())) {
            return NumberRuleAppCost.create((int)1000);
        }
        return super.computeCost(app, pio, goal);
    }

    private int computeUnwindRules(Goal goal) {
        int totalUnwinds = 0;
        Node node = goal.node();
        while (!node.root()) {
            Rule rule;
            RuleApp app = node.getAppliedRuleApp();
            if (app != null && TestGenStrategy.isUnwindRule(rule = app.rule())) {
                ++totalUnwinds;
            }
            node = node.parent();
        }
        return totalUnwinds;
    }

    public boolean isApprovedApp(RuleApp app, PosInOccurrence pio, Goal goal) {
        if (!TestGenStrategy.hasModality(goal.node())) {
            return false;
        }
        if (TestGenStrategy.isUnwindRule(app.rule())) {
            int noUnwindRules = this.computeUnwindRules(goal);
            return noUnwindRules < this.limit;
        }
        return super.isApprovedApp(app, pio, goal);
    }

    public Name name() {
        return NAME;
    }

    public boolean isStopAtFirstNonCloseableGoal() {
        return false;
    }

    static {
        unwindRules.add("loopUnwind");
        unwindRules.add("doWhileUnwind");
        unwindRules.add("methodCall");
        unwindRules.add("methodCallWithAssignment");
        unwindRules.add("staticMethodCall");
        unwindRules.add("staticMethodCallWithAssignment");
    }
}

