/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.settings;

import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.Settings;
import de.uka.ilkd.key.settings.SettingsConverter;
import de.uka.ilkd.key.settings.SettingsListener;
import java.io.File;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestGenerationSettings
implements Settings,
Cloneable {
    private static final boolean DEFAULT_APPLYSYMBOLICEX = false;
    private static final int DEFAULT_MAXUNWINDS = 3;
    private static final int DEFAULT_CONCURRENTPROCESSES = 1;
    private static final String DEFAULT_OUTPUTPATH = System.getProperty("user.home") + File.separator + "testFiles";
    private static final boolean DEFAULT_REMOVEDUPLICATES = true;
    private static final boolean DEFAULT_USERFL = false;
    private static final boolean DEFAULT_USEJUNIT = false;
    private static final boolean DEFAULT_INVARIANTFORALL = true;
    private static final String DEFAULT_OPENJMLPATH = ".";
    private static final String DEFAULT_OBJENESISPATH = ".";
    private static final boolean DEFAULT_INCLUDEPOSTCONDITION = false;
    private static final String PROP_APPLY_SYMBOLIC_EXECUTION = "[TestGenSettings]applySymbolicExecution";
    private static final String PROP_MAX_UWINDS = "[TestGenSettings]maxUnwinds";
    private static final String PROP_OUTPUT_PATH = "[TestGenSettings]OutputPath";
    private static final String PROP_REMOVE_DUPLICATES = "[TestGenSettings]RemoveDuplicates";
    private static final String PROP_USE_RFL = "[TestGenSettings]UseRFL";
    private static final String PROP_USE_JUNIT = "[TestGenSettings]UseJUnit";
    private static final String PROP_CONCURRENT_PROCESSES = "[TestGenSettings]ConcurrentProcesses";
    private static final String PROP_INVARIANT_FOR_ALL = "[TestGenSettings]InvariantForAll";
    private static final String PROP_OPENJML_PATH = "[TestGenSettings]OpenJMLPath";
    private static final String PROP_OBJENESIS_PATH = "[TestGenSettings]ObjenesisPath";
    private static final String PROP_INCLUDE_POST_CONDITION = "[TestGenSettings]IncludePostCondition";
    private final Collection<SettingsListener> listeners = new LinkedHashSet<SettingsListener>();
    private boolean applySymbolicExecution;
    private int maxUnwinds;
    private String outputPath;
    private String openjmlPath;
    private String objenesisPath;
    private boolean removeDuplicates;
    private boolean useRFL;
    private boolean useJunit;
    private int concurrentProcesses;
    private boolean invariantForAll;
    private boolean includePostCondition;
    @Nullable
    private static TestGenerationSettings instance;

    public TestGenerationSettings() {
        this.applySymbolicExecution = false;
        this.maxUnwinds = 3;
        this.outputPath = DEFAULT_OUTPUTPATH;
        this.removeDuplicates = true;
        this.useRFL = false;
        this.useJunit = false;
        this.concurrentProcesses = 1;
        this.invariantForAll = true;
        this.openjmlPath = ".";
        this.objenesisPath = ".";
        this.includePostCondition = false;
    }

    public TestGenerationSettings(TestGenerationSettings data) {
        this.listeners.addAll(data.listeners);
        this.applySymbolicExecution = data.applySymbolicExecution;
        this.maxUnwinds = data.maxUnwinds;
        this.outputPath = data.outputPath;
        this.removeDuplicates = data.removeDuplicates;
        this.useJunit = data.useJunit;
        this.useRFL = data.useRFL;
        this.concurrentProcesses = data.concurrentProcesses;
        this.invariantForAll = data.invariantForAll;
        this.openjmlPath = data.openjmlPath;
        this.objenesisPath = data.objenesisPath;
        this.includePostCondition = data.includePostCondition;
    }

    public void addSettingsListener(SettingsListener l) {
        this.listeners.add(l);
    }

    public void removeSettingsListener(SettingsListener l) {
        this.listeners.remove(l);
    }

    public TestGenerationSettings clone(TestGenerationSettings data) {
        return new TestGenerationSettings(data);
    }

    public void fireSettingsChanged() {
        for (SettingsListener aListenerList : this.listeners) {
            aListenerList.settingsChanged(new EventObject(this));
        }
    }

    public boolean getApplySymbolicExecution() {
        return this.applySymbolicExecution;
    }

    public void setApplySymbolicExecution(boolean applySymbolicExecution) {
        this.applySymbolicExecution = applySymbolicExecution;
    }

    public int getMaximalUnwinds() {
        return this.maxUnwinds;
    }

    public int getNumberOfProcesses() {
        return this.concurrentProcesses;
    }

    public String getOutputFolderPath() {
        return this.outputPath;
    }

    public boolean invariantForAll() {
        return this.invariantForAll;
    }

    public boolean includePostCondition() {
        return this.includePostCondition;
    }

    public void readSettings(Properties props) {
        this.applySymbolicExecution = SettingsConverter.read((Properties)props, (String)PROP_APPLY_SYMBOLIC_EXECUTION, (boolean)false);
        this.maxUnwinds = SettingsConverter.read((Properties)props, (String)PROP_MAX_UWINDS, (int)3);
        this.outputPath = SettingsConverter.read((Properties)props, (String)PROP_OUTPUT_PATH, (String)DEFAULT_OUTPUTPATH);
        this.removeDuplicates = SettingsConverter.read((Properties)props, (String)PROP_REMOVE_DUPLICATES, (boolean)true);
        this.useRFL = SettingsConverter.read((Properties)props, (String)PROP_USE_RFL, (boolean)false);
        this.useJunit = SettingsConverter.read((Properties)props, (String)PROP_USE_JUNIT, (boolean)false);
        this.concurrentProcesses = SettingsConverter.read((Properties)props, (String)PROP_CONCURRENT_PROCESSES, (int)1);
        this.invariantForAll = SettingsConverter.read((Properties)props, (String)PROP_INVARIANT_FOR_ALL, (boolean)true);
        this.openjmlPath = SettingsConverter.read((Properties)props, (String)PROP_OPENJML_PATH, (String)".");
        this.objenesisPath = SettingsConverter.read((Properties)props, (String)PROP_OBJENESIS_PATH, (String)".");
        this.includePostCondition = SettingsConverter.read((Properties)props, (String)PROP_INCLUDE_POST_CONDITION, (boolean)false);
    }

    public boolean removeDuplicates() {
        return this.removeDuplicates;
    }

    public void setConcurrentProcesses(int concurrentProcesses) {
        this.concurrentProcesses = concurrentProcesses;
    }

    public void setInvariantForAll(boolean invariantForAll) {
        this.invariantForAll = invariantForAll;
    }

    public void setMaxUnwinds(int maxUnwinds) {
        this.maxUnwinds = maxUnwinds;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setRemoveDuplicates(boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
    }

    public void setIncludePostCondition(boolean includePostCondition) {
        this.includePostCondition = includePostCondition;
    }

    public void setRFL(boolean useRFL) {
        this.useRFL = useRFL;
    }

    public void setUseJunit(boolean useJunit) {
        this.useJunit = useJunit;
    }

    public String getObjenesisPath() {
        return this.objenesisPath;
    }

    public void setObjenesisPath(String objenesisPath) {
        this.objenesisPath = objenesisPath;
    }

    public String getOpenjmlPath() {
        return this.openjmlPath;
    }

    public void setOpenjmlPath(String openjmlPath) {
        this.openjmlPath = openjmlPath;
    }

    public boolean useRFL() {
        return this.useRFL;
    }

    public boolean useJunit() {
        return this.useJunit;
    }

    public void writeSettings(Properties props) {
        SettingsConverter.store((Properties)props, (String)PROP_APPLY_SYMBOLIC_EXECUTION, (boolean)this.applySymbolicExecution);
        SettingsConverter.store((Properties)props, (String)PROP_CONCURRENT_PROCESSES, (long)this.concurrentProcesses);
        SettingsConverter.store((Properties)props, (String)PROP_INVARIANT_FOR_ALL, (boolean)this.invariantForAll);
        SettingsConverter.store((Properties)props, (String)PROP_MAX_UWINDS, (long)this.maxUnwinds);
        SettingsConverter.store((Properties)props, (String)PROP_OUTPUT_PATH, (String)this.outputPath);
        SettingsConverter.store((Properties)props, (String)PROP_REMOVE_DUPLICATES, (boolean)this.removeDuplicates);
        SettingsConverter.store((Properties)props, (String)PROP_USE_RFL, (boolean)this.useRFL);
        SettingsConverter.store((Properties)props, (String)PROP_USE_JUNIT, (boolean)this.useJunit);
        SettingsConverter.store((Properties)props, (String)PROP_OPENJML_PATH, (String)this.openjmlPath);
        SettingsConverter.store((Properties)props, (String)PROP_OBJENESIS_PATH, (String)this.objenesisPath);
        SettingsConverter.store((Properties)props, (String)PROP_INCLUDE_POST_CONDITION, (boolean)this.includePostCondition);
    }

    public void set(TestGenerationSettings settings) {
        Properties p = new Properties();
        settings.writeSettings(p);
        this.readSettings(p);
    }

    @Nonnull
    public static TestGenerationSettings getInstance() {
        if (instance == null) {
            instance = new TestGenerationSettings();
            ProofIndependentSettings.DEFAULT_INSTANCE.addSettings((Settings)instance);
        }
        return instance;
    }
}

