/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.smt.counterexample;

import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.logic.Semisequent;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.macros.ProofMacroFinishedInfo;
import de.uka.ilkd.key.macros.SemanticsBlastingMacro;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.prover.ProverTaskListener;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskStartedInfo;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.smt.SMTProblem;
import de.uka.ilkd.key.smt.SMTSettings;
import de.uka.ilkd.key.smt.SolverLauncher;
import de.uka.ilkd.key.smt.SolverLauncherListener;
import de.uka.ilkd.key.smt.solvertypes.SolverType;
import de.uka.ilkd.key.smt.solvertypes.SolverTypes;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCounterExampleGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCounterExampleGenerator.class);

    public static boolean isSolverAvailable() {
        return SolverTypes.Z3_CE_SOLVER.isInstalled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchCounterExample(UserInterfaceControl ui, Proof oldProof, Sequent oldSequent) throws ProofInputException {
        if (!AbstractCounterExampleGenerator.isSolverAvailable()) {
            throw new IllegalStateException("Can't find SMT solver " + SolverTypes.Z3_CE_SOLVER.getName());
        }
        Proof proof = this.createProof(ui, oldProof, oldSequent, "Semantics Blasting: " + oldProof.name());
        SemanticsBlastingMacro macro = new SemanticsBlastingMacro();
        ProofMacroFinishedInfo info = ProofMacroFinishedInfo.getDefaultInfo((ProofMacro)macro, (Proof)proof);
        ProverTaskListener ptl = ui.getProofControl().getDefaultProverTaskListener();
        ptl.taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Macro, macro.getName(), 0));
        try {
            SemanticsBlastingMacro semanticsBlastingMacro = macro;
            synchronized (semanticsBlastingMacro) {
                info = macro.applyTo(ui, proof, proof.openEnabledGoals(), null, ptl);
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Semantics blasting interrupted");
        }
        finally {
            this.semanticsBlastingCompleted(ui);
            ptl.taskFinished((TaskFinishedInfo)info);
        }
        DefaultSMTSettings settings = new DefaultSMTSettings(proof.getSettings().getSMTSettings(), ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings(), proof.getSettings().getNewSMTSettings(), proof);
        SolverLauncher launcher = new SolverLauncher((SMTSettings)settings);
        launcher.addListener(this.createSolverListener(settings, proof));
        LinkedList<SolverType> solvers = new LinkedList<SolverType>();
        solvers.add(SolverTypes.Z3_CE_SOLVER);
        launcher.launch(solvers, SMTProblem.createSMTProblems((Proof)proof), proof.getServices());
    }

    protected abstract Proof createProof(UserInterfaceControl var1, Proof var2, Sequent var3, String var4) throws ProofInputException;

    protected Sequent createNewSequent(Sequent oldSequent) {
        return Sequent.createSequent((Semisequent)oldSequent.antecedent(), (Semisequent)oldSequent.succedent());
    }

    protected void semanticsBlastingCompleted(UserInterfaceControl ui) {
    }

    protected abstract SolverLauncherListener createSolverListener(DefaultSMTSettings var1, Proof var2);
}

