/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.smt.testgen;

import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.logic.Choice;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Semisequent;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.macros.ProofMacroFinishedInfo;
import de.uka.ilkd.key.macros.SemanticsBlastingMacro;
import de.uka.ilkd.key.macros.TestGenMacro;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.ProverTaskListener;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskStartedInfo;
import de.uka.ilkd.key.rule.OneStepSimplifier;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.settings.NewSMTTranslationSettings;
import de.uka.ilkd.key.settings.ProofDependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.TestGenerationSettings;
import de.uka.ilkd.key.smt.SMTProblem;
import de.uka.ilkd.key.smt.SMTSettings;
import de.uka.ilkd.key.smt.SMTSolver;
import de.uka.ilkd.key.smt.SMTSolverResult;
import de.uka.ilkd.key.smt.SolverLauncher;
import de.uka.ilkd.key.smt.SolverLauncherListener;
import de.uka.ilkd.key.smt.model.Model;
import de.uka.ilkd.key.smt.solvertypes.SolverType;
import de.uka.ilkd.key.smt.solvertypes.SolverTypes;
import de.uka.ilkd.key.smt.testgen.StopRequest;
import de.uka.ilkd.key.smt.testgen.TestGenerationLog;
import de.uka.ilkd.key.testgen.TestCaseGenerator;
import de.uka.ilkd.key.util.ProofStarter;
import de.uka.ilkd.key.util.SideProofUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.key_project.util.collection.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestGenerator.class);
    private final UserInterfaceControl ui;
    private final Proof originalProof;
    private SolverLauncher launcher;
    private List<Proof> proofs;

    protected AbstractTestGenerator(UserInterfaceControl ui, Proof originalProof) {
        this.ui = ui;
        this.originalProof = originalProof;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTestCases(StopRequest stopRequest, final TestGenerationLog log) {
        TestGenerationSettings settings = TestGenerationSettings.getInstance();
        if (!SolverTypes.Z3_CE_SOLVER.isInstalled(true)) {
            log.writeln("Could not find the z3 SMT solver. Aborting.");
            return;
        }
        if (!SolverTypes.Z3_CE_SOLVER.isSupportedVersion()) {
            log.writeln("Warning: z3 supported minimum supported version is: " + SolverTypes.Z3_CE_SOLVER.getMinimumSupportedVersion());
        }
        if (this.originalProof.closed() && settings.includePostCondition()) {
            log.writeln("Cannot generate test cases from closed proof with \nInclude Postcondition option activated. Aborting.");
            return;
        }
        if (settings.getApplySymbolicExecution()) {
            log.writeln("Applying TestGen Macro (bounded symbolic execution)...");
            try {
                TestGenMacro macro = new TestGenMacro();
                macro.applyTo(this.ui, this.originalProof, this.originalProof.openEnabledGoals(), null, null);
                log.writeln("Finished symbolic execution.");
            }
            catch (Exception ex) {
                log.writeException(ex);
            }
        }
        log.writeln("Extracting test data constraints (path conditions).");
        this.proofs = this.createProofsForTesting(settings.removeDuplicates(), !settings.includePostCondition());
        if (stopRequest != null && stopRequest.shouldStop()) {
            return;
        }
        if (!this.proofs.isEmpty()) {
            log.writeln("Extracted " + this.proofs.size() + " test data constraints.");
        } else {
            log.writeln("No test data constraints were extracted.");
        }
        LinkedList problems = new LinkedList();
        log.writeln("Test data generation: appling semantic blasting macro on proofs");
        try {
            for (Proof proof : this.proofs) {
                if (stopRequest != null && stopRequest.shouldStop()) {
                    return;
                }
                log.write(".");
                SemanticsBlastingMacro macro = new SemanticsBlastingMacro();
                ProofMacroFinishedInfo info = ProofMacroFinishedInfo.getDefaultInfo((ProofMacro)macro, (Proof)proof);
                ProverTaskListener ptl = this.ui.getProofControl().getDefaultProverTaskListener();
                try {
                    if (stopRequest != null && stopRequest.shouldStop()) {
                        return;
                    }
                    this.selectProof(this.ui, proof);
                    ptl.taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Macro, macro.getName(), 0));
                    info = macro.applyTo(this.ui, proof, proof.openEnabledGoals(), null, ptl);
                    problems.addAll(SMTProblem.createSMTProblems((Proof)proof));
                }
                catch (InterruptedException e) {
                    LOGGER.debug("Semantics blasting interrupted");
                    log.writeln("\n Warning: semantics blasting was interrupted. A test case will not be generated.");
                }
                catch (Exception e) {
                    log.writeln(e.getLocalizedMessage());
                    LOGGER.warn("", (Throwable)e);
                }
                finally {
                    ptl.taskFinished((TaskFinishedInfo)info);
                }
            }
        }
        finally {
            this.handleAllProofsPerformed(this.ui);
        }
        log.writeln("\nDone applying semantic blasting.");
        this.selectProof(this.ui, this.originalProof);
        Proof proof = this.originalProof;
        ProofIndependentSMTSettings piSettings = ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings().clone();
        piSettings.setMaxConcurrentProcesses(settings.getNumberOfProcesses());
        ProofDependentSMTSettings pdSettings = proof.getSettings().getSMTSettings().clone();
        NewSMTTranslationSettings newSettings = new NewSMTTranslationSettings(proof.getSettings().getNewSMTSettings());
        pdSettings.invariantForall = settings.invariantForAll();
        DefaultSMTSettings smtsettings = new DefaultSMTSettings(pdSettings, piSettings, newSettings, proof);
        this.launcher = new SolverLauncher((SMTSettings)smtsettings);
        this.launcher.addListener(new SolverLauncherListener(){

            public void launcherStopped(SolverLauncher launcher, Collection<SMTSolver> finishedSolvers) {
                AbstractTestGenerator.this.handleLauncherStopped(launcher, finishedSolvers, log);
            }

            public void launcherStarted(Collection<SMTProblem> problems, Collection<SolverType> solverTypes, SolverLauncher launcher) {
                AbstractTestGenerator.this.handleLauncherStarted(problems, solverTypes, launcher, log);
            }
        });
        LinkedList<SolverType> solvers = new LinkedList<SolverType>();
        solvers.add(SolverTypes.Z3_CE_SOLVER);
        SolverTypes.Z3_CE_SOLVER.checkForSupport();
        if (stopRequest != null && stopRequest.shouldStop()) {
            return;
        }
        if (Thread.interrupted()) {
            return;
        }
        this.launcher.launch(solvers, problems, proof.getServices());
    }

    protected void handleAllProofsPerformed(UserInterfaceControl ui) {
    }

    public void dispose() {
        if (this.proofs != null) {
            for (Proof p : this.proofs) {
                p.dispose();
            }
        }
    }

    protected void selectProof(UserInterfaceControl ui, Proof proof) {
    }

    private List<Proof> createProofsForTesting(boolean removeDuplicatePathConditions, boolean removePostCondition) {
        LinkedList<Proof> res = new LinkedList<Proof>();
        LinkedList<Node> nodes = new LinkedList<Node>();
        ImmutableList oldGoals = this.originalProof.openGoals();
        if (this.originalProof.closed()) {
            this.getNodesWithEmptyModalities(this.originalProof.root(), nodes);
        } else {
            for (Goal goal : oldGoals) {
                nodes.add(goal.node());
            }
        }
        Iterator oldGoalIter = nodes.iterator();
        while (oldGoalIter.hasNext()) {
            try {
                Proof p = removeDuplicatePathConditions ? this.createProofForTestingNoDuplicate((Node)oldGoalIter.next(), res, removePostCondition) : this.createProofForTestingNoDuplicate((Node)oldGoalIter.next(), null, removePostCondition);
                if (p == null) continue;
                res.add(p);
            }
            catch (Exception e) {
                LOGGER.error("Could not create a proof for testing", (Throwable)e);
            }
        }
        return res;
    }

    private void getNodesWithEmptyModalities(Node root, List<Node> nodes) {
        RuleApp app;
        if (root.getAppliedRuleApp() != null && (app = root.getAppliedRuleApp()).rule().name().toString().equals("emptyModality")) {
            nodes.add(root);
        }
        for (int i = 0; i < root.childrenCount(); ++i) {
            this.getNodesWithEmptyModalities(root.child(i), nodes);
        }
    }

    private Proof createProofForTestingNoDuplicate(Node node, List<Proof> otherProofs, boolean removePostCondition) throws ProofInputException {
        Proof oldProof = node.proof();
        Sequent oldSequent = node.sequent();
        Sequent newSequent = Sequent.createSequent((Semisequent)Semisequent.EMPTY_SEMISEQUENT, (Semisequent)Semisequent.EMPTY_SEMISEQUENT);
        for (SequentFormula sf : oldSequent.antecedent()) {
            if (this.hasModalities(sf.formula(), false)) continue;
            newSequent = newSequent.addFormula(sf, true, false).sequent();
        }
        for (SequentFormula sf : oldSequent.succedent()) {
            if (this.hasModalities(sf.formula(), removePostCondition)) continue;
            newSequent = newSequent.addFormula(sf, false, false).sequent();
        }
        if (otherProofs != null) {
            for (Proof otherProof : otherProofs) {
                if (!otherProof.root().sequent().equals((Object)newSequent)) continue;
                return null;
            }
        }
        return this.createProof(this.ui, oldProof, "Test Case for NodeNr: " + node.serialNr(), newSequent);
    }

    protected Proof createProof(UserInterfaceControl ui, Proof oldProof, String newName, Sequent newSequent) throws ProofInputException {
        ProofEnvironment env = SideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier((Proof)oldProof, (Choice[])new Choice[]{new Choice("ban", "runtimeExceptions")});
        ProofStarter starter = SideProofUtil.createSideProof((ProofEnvironment)env, (Sequent)newSequent, (String)newName);
        Proof proof = starter.getProof();
        proof.getServices().getSpecificationRepository().registerProof(proof.getServices().getSpecificationRepository().getProofOblInput(oldProof), proof);
        OneStepSimplifier.refreshOSS((Proof)proof);
        return proof;
    }

    private boolean hasModalities(Term t, boolean checkUpdates) {
        JavaBlock jb = t.javaBlock();
        if (jb != null && !jb.isEmpty()) {
            return true;
        }
        if (t.op() == UpdateApplication.UPDATE_APPLICATION && checkUpdates) {
            return true;
        }
        boolean res = false;
        for (int i = 0; i < t.arity() && !res; res |= this.hasModalities(t.sub(i), checkUpdates), ++i) {
        }
        return res;
    }

    protected void handleLauncherStarted(Collection<SMTProblem> problems, Collection<SolverType> solverTypes, SolverLauncher launcher, TestGenerationLog log) {
        log.writeln("Test data generation: solving " + problems.size() + " SMT problems... \n please wait...");
    }

    protected void handleLauncherStopped(SolverLauncher launcher, Collection<SMTSolver> problemSolvers, TestGenerationLog log) {
        try {
            log.writeln("Finished solving SMT problems: " + problemSolvers.size());
            problemSolvers = this.filterSolverResultsAndShowSolverStatistics(problemSolvers, log);
            if (!problemSolvers.isEmpty()) {
                this.generateFiles(problemSolvers, log, this.originalProof);
            } else {
                log.writeln("No test data was generated.");
                this.informAboutNoTestResults(launcher, problemSolvers, log, this.originalProof);
            }
            log.testGenerationCompleted();
        }
        catch (Exception e) {
            log.writeException(e);
        }
    }

    protected void generateFiles(Collection<SMTSolver> problemSolvers, TestGenerationLog log, Proof originalProof) throws IOException {
        TestCaseGenerator tg = new TestCaseGenerator(originalProof);
        tg.setLogger(log);
        tg.generateJUnitTestSuite(problemSolvers);
        if (tg.isJunit()) {
            log.writeln("Compile the generated files using a Java compiler.");
        } else {
            log.writeln("Compile and run the file with openjml!");
        }
    }

    protected void informAboutNoTestResults(SolverLauncher launcher, Collection<SMTSolver> problemSolvers, TestGenerationLog log, Proof originalProof) {
    }

    public Collection<SMTSolver> filterSolverResultsAndShowSolverStatistics(Collection<SMTSolver> problemSolvers, TestGenerationLog log) {
        int unknown = 0;
        int infeasiblePaths = 0;
        int solvedPaths = 0;
        int problem = 0;
        ArrayList<SMTSolver> output = new ArrayList<SMTSolver>();
        for (SMTSolver solver : problemSolvers) {
            try {
                SMTSolverResult.ThreeValuedTruth res = solver.getFinalResult().isValid();
                if (res == SMTSolverResult.ThreeValuedTruth.UNKNOWN) {
                    ++unknown;
                    if (solver.getException() == null) continue;
                    solver.getException().printStackTrace();
                    continue;
                }
                if (res == SMTSolverResult.ThreeValuedTruth.FALSIFIABLE) {
                    ++solvedPaths;
                    if (solver.getSocket().getQuery() != null) {
                        Model m = solver.getSocket().getQuery().getModel();
                        if (TestCaseGenerator.modelIsOK(m)) {
                            output.add(solver);
                            continue;
                        }
                        ++problem;
                        continue;
                    }
                    ++problem;
                    continue;
                }
                if (res != SMTSolverResult.ThreeValuedTruth.VALID) continue;
                ++infeasiblePaths;
            }
            catch (Exception ex) {
                log.writeln(ex.getMessage());
            }
        }
        log.writeln("--- SMT Solver Results ---\n solved pathconditions:" + solvedPaths + "\n invalid pre-/pathconditions:" + infeasiblePaths + "\n unknown:" + unknown);
        if (problem > 0) {
            log.writeln(" problems             :" + problem);
        }
        if (unknown > 0) {
            log.writeln(" Adjust the SMT solver settings (e.g. timeout) in Options->SMT Solvers and restart key.\n Make sure you use Z3 version 4.3.1.");
        }
        log.writeln("----------------------");
        return output;
    }

    public void stopSMTLauncher() {
        if (this.launcher != null) {
            this.launcher.stop();
        }
    }

    protected Proof getOriginalProof() {
        return this.originalProof;
    }

    protected List<Proof> getProofs() {
        return this.proofs;
    }

    protected UserInterfaceControl getUI() {
        return this.ui;
    }

    public static boolean isSolverAvailable() {
        return SolverTypes.Z3_CE_SOLVER.isInstalled(true);
    }
}

