/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.testgen;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Namespace;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.settings.NewSMTTranslationSettings;
import de.uka.ilkd.key.settings.ProofDependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.TestGenerationSettings;
import de.uka.ilkd.key.smt.SMTProblem;
import de.uka.ilkd.key.smt.SMTSettings;
import de.uka.ilkd.key.smt.SMTSolver;
import de.uka.ilkd.key.smt.SMTSolverResult;
import de.uka.ilkd.key.smt.SolverLauncher;
import de.uka.ilkd.key.smt.SolverLauncherListener;
import de.uka.ilkd.key.smt.lang.SMTSort;
import de.uka.ilkd.key.smt.model.Model;
import de.uka.ilkd.key.smt.solvertypes.SolverType;
import de.uka.ilkd.key.smt.solvertypes.SolverTypes;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.key_project.util.collection.ImmutableSLList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGenerator
implements SolverLauncherListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelGenerator.class);
    private final Services services;
    private Goal goal;
    private int count;
    private final List<Model> models;
    private final int target;

    public ModelGenerator(Goal s, int target, Services services) {
        this.goal = s;
        this.services = services;
        this.target = target;
        this.models = new LinkedList<Model>();
        this.count = 0;
    }

    public void launch() {
        LOGGER.debug("Launch {}", (Object)this.count++);
        SolverLauncher launcher = this.prepareLauncher();
        SolverType solver = SolverTypes.Z3_CE_SOLVER;
        SMTProblem problem = new SMTProblem(this.goal);
        launcher.addListener((SolverLauncherListener)this);
        launcher.launch(problem, this.services, new SolverType[]{solver});
    }

    private SolverLauncher prepareLauncher() {
        TestGenerationSettings settings = TestGenerationSettings.getInstance();
        ProofIndependentSMTSettings piSettings = ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings().clone();
        piSettings.setMaxConcurrentProcesses(settings.getNumberOfProcesses());
        ProofDependentSMTSettings pdSettings = ProofDependentSMTSettings.getDefaultSettingsData();
        pdSettings.invariantForall = settings.invariantForAll();
        DefaultSMTSettings smtsettings = new DefaultSMTSettings(pdSettings, piSettings, new NewSMTTranslationSettings(), null);
        return new SolverLauncher((SMTSettings)smtsettings);
    }

    public void launcherStopped(SolverLauncher launcher, Collection<SMTSolver> finishedSolvers) {
        for (SMTSolver solver : finishedSolvers) {
            SMTSolverResult result = solver.getFinalResult();
            if (result.isValid().equals((Object)SMTSolverResult.ThreeValuedTruth.FALSIFIABLE) && this.models.size() < this.target) {
                Model model = solver.getSocket().getQuery().getModel();
                this.models.add(model);
                this.addModelToTerm(model);
                if (this.models.size() >= this.target) {
                    this.finish();
                    continue;
                }
                this.launch();
                continue;
            }
            this.finish();
        }
    }

    private boolean addModelToTerm(Model m) {
        TermBuilder tb = this.services.getTermBuilder();
        Namespace variables = this.services.getNamespaces().programVariables();
        Term tmodel = tb.tt();
        for (String c : m.getConstants().keySet()) {
            SMTSort sort = m.getTypes().getTypeForConstant((Object)c);
            if (sort == null || !sort.getId().equals("IntB")) continue;
            String val = (String)m.getConstants().get(c);
            int value = Integer.parseInt(val);
            ProgramVariable v = (ProgramVariable)variables.lookup(c);
            Term termConst = tb.var(v);
            Term termVal = tb.zTerm((long)value);
            Term termEquals = tb.equals(termConst, termVal);
            tmodel = tb.and(tmodel, termEquals);
        }
        if (!tmodel.equals(tb.tt())) {
            Term notTerm = tb.not(tmodel);
            SequentFormula sf = new SequentFormula(notTerm);
            this.goal.addFormula(sf, true, true);
            return true;
        }
        return false;
    }

    private void finish() {
        LOGGER.info("Finished: found {}", (Object)this.models.size());
        for (Model m : this.models) {
            LOGGER.info("\t{}", (Object)m.toString());
        }
    }

    public void launcherStarted(Collection<SMTProblem> problems, Collection<SolverType> solverTypes, SolverLauncher launcher) {
    }

    public Term sequentToTerm(Sequent s) {
        ImmutableSLList ante = ImmutableSLList.nil();
        TermBuilder tb = this.services.getTermBuilder();
        ante = ante.append((Object)tb.tt());
        for (SequentFormula f : s.antecedent()) {
            ante = ante.append((Object)f.formula());
        }
        ImmutableSLList succ = ImmutableSLList.nil();
        succ = succ.append((Object)tb.ff());
        for (SequentFormula f : s.succedent()) {
            succ = succ.append((Object)f.formula());
        }
        return tb.imp(tb.and((Iterable)ante), tb.or((Iterable)succ));
    }
}

