/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.testgen;

import de.uka.ilkd.key.java.PrettyPrinter;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.TermLabel;
import de.uka.ilkd.key.logic.op.ElementaryUpdate;
import de.uka.ilkd.key.logic.op.IObserverFunction;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.ContractPO;
import de.uka.ilkd.key.proof.mgt.SpecificationRepository;
import de.uka.ilkd.key.speclang.Contract;
import de.uka.ilkd.key.speclang.FunctionalOperationContract;
import de.uka.ilkd.key.testgen.CustomPrettyPrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProofInfo.class);
    private final Proof proof;
    private final Services services;

    public ProofInfo(Proof proof) {
        this.proof = proof;
        this.services = proof.getServices();
    }

    public IProgramMethod getMUT() {
        SpecificationRepository spec = this.services.getSpecificationRepository();
        IObserverFunction f = spec.getTargetOfProof(this.proof);
        if (f instanceof IProgramMethod) {
            return (IProgramMethod)f;
        }
        return null;
    }

    public KeYJavaType getTypeOfClassUnderTest() {
        if (this.getMUT() == null) {
            return null;
        }
        return this.getMUT().getContainerType();
    }

    public KeYJavaType getReturnType() {
        return this.getMUT().getType();
    }

    public Contract getContract() {
        ContractPO po = this.services.getSpecificationRepository().getPOForProof(this.proof);
        return po.getContract();
    }

    public Term getPostCondition() {
        Term t = this.getPO();
        Term post = this.services.getTermBuilder().tt();
        try {
            post = t.sub(1).sub(1).sub(0);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get PostCondition", (Throwable)e);
        }
        return post;
    }

    public Term getPreConTerm() {
        Contract c = this.getContract();
        if (c instanceof FunctionalOperationContract) {
            FunctionalOperationContract t = (FunctionalOperationContract)c;
            Contract.OriginalVariables orig = t.getOrigVars();
            Term post = t.getPre(this.services.getTypeConverter().getHeapLDT().getHeap(), orig.self, orig.params, orig.atPres, this.services);
            return post;
        }
        return this.services.getTermBuilder().ff();
    }

    public Term getAssignable() {
        Contract c = this.getContract();
        return c.getAssignable(this.services.getTypeConverter().getHeapLDT().getHeap());
    }

    public String getCode() {
        Term f = this.getPO();
        JavaBlock block = this.getJavaBlock(f);
        StringWriter sw = new StringWriter();
        sw.write("   " + this.getUpdate(f) + "\n");
        CustomPrettyPrinter pw = new CustomPrettyPrinter((Writer)sw, false);
        try {
            block.program().prettyPrint((PrettyPrinter)pw);
            return sw.getBuffer().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void getProgramVariables(Term t, Set<Term> vars) {
        if (t.op() instanceof ProgramVariable && this.isRelevantConstant(t)) {
            vars.add(TermLabel.removeIrrelevantLabels((Term)t, (Services)this.services));
        }
        for (Term sub : t.subs()) {
            this.getProgramVariables(sub, vars);
        }
    }

    private boolean isRelevantConstant(Term c) {
        Operator op = c.op();
        if (this.isTrueConstant(op) || this.isFalseConstant(op)) {
            return false;
        }
        Sort s = c.sort();
        Sort nullSort = this.services.getJavaInfo().getNullType().getSort();
        Sort objSort = this.services.getJavaInfo().getJavaLangObject().getSort();
        Sort intSort = this.services.getTypeConverter().getIntegerLDT().targetSort();
        Sort boolSort = this.services.getTypeConverter().getBooleanLDT().targetSort();
        if (s.equals(nullSort)) {
            return false;
        }
        return s.extendsTrans(objSort) || s.equals(intSort) || s.equals(boolSort);
    }

    private boolean isTrueConstant(Operator o) {
        return o.equals(this.services.getTypeConverter().getBooleanLDT().getTrueConst());
    }

    private boolean isFalseConstant(Operator o) {
        return o.equals(this.services.getTypeConverter().getBooleanLDT().getFalseConst());
    }

    public Term getPO() {
        return this.proof.root().sequent().succedent().get(0).formula();
    }

    public String getUpdate(Term t) {
        if (t.op() instanceof UpdateApplication) {
            return this.processUpdate(UpdateApplication.getUpdate((Term)t));
        }
        StringBuilder result = new StringBuilder();
        for (Term s : t.subs()) {
            result.append(this.getUpdate(s));
        }
        return result.toString();
    }

    private String processUpdate(Term update) {
        if (update.op() instanceof ElementaryUpdate) {
            ElementaryUpdate up = (ElementaryUpdate)update.op();
            if (up.lhs().sort().extendsTrans(this.services.getTypeConverter().getHeapLDT().targetSort())) {
                return "";
            }
            return "   \n" + up.lhs().sort() + " " + up.lhs().toString() + " = " + update.sub(0) + ";";
        }
        StringBuilder result = new StringBuilder();
        for (Term sub : update.subs()) {
            result.append(this.processUpdate(sub));
        }
        return result.toString();
    }

    public JavaBlock getJavaBlock(Term t) {
        if (t.containsJavaBlockRecursive()) {
            if (!t.javaBlock().isEmpty()) {
                return t.javaBlock();
            }
            for (Term s : t.subs()) {
                if (!s.containsJavaBlockRecursive()) continue;
                return this.getJavaBlock(s);
            }
        }
        return null;
    }
}

