/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.testgen;

import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.util.KeYConstants;
import java.util.HashSet;
import org.key_project.util.java.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionClassCreator {
    public static final String NEW_LINE = StringUtil.NEW_LINE;
    public static final String NAME_OF_CLASS = "RFL";
    public static final String ARRAY = "_ARRAY_";
    public static final String SET_PREFIX = "_set_";
    public static final String GET_PREFIX = "_get_";
    private static final String[] PRIMITIVE_TYPES = new String[]{"int", "long", "byte", "char", "boolean", "float", "double"};
    private static final String[] PRIM_TYP_DEF_VAL = new String[]{"0", "0", "0", "' '", "false", "0", "0"};
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionClassCreator.class);
    private final HashSet<Sort> usedObjectSorts = new HashSet();
    private final HashSet<String> usedObjectSortsStrings = new HashSet();

    public StringBuilder createClass(boolean staticClass) {
        HashSet<String> sorts = this.sortsToString();
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)this.classDecl(staticClass));
        result.append((CharSequence)this.ghostMapDecls(true));
        result.append((CharSequence)this.staticInitializer(true));
        result.append((CharSequence)this.instanceMethod());
        result.append((CharSequence)this.instances(sorts));
        result.append((CharSequence)this.getterAndSetter(sorts));
        result.append(this.footer());
        if (!this.checkBraces(result)) {
            throw new IllegalStateException("ReflectionClassCreator.createClass(): Problem: the number of opening and closing braces of the generated RFL file is not equal!");
        }
        return result;
    }

    public void addSort(Sort s) {
        this.usedObjectSorts.add(s);
    }

    public void addSort(String s) {
        this.usedObjectSortsStrings.add(s);
    }

    private HashSet<String> sortsToString() {
        HashSet<String> result = new HashSet<String>();
        for (Sort var : this.usedObjectSorts) {
            String sort = var.toString();
            if (" jbyte jint jlong jfloat jdouble jboolean jchar ".contains(" " + sort + " ")) continue;
            if (" jbyte[] jint[] jlong[] jfloat[] jdouble[] jboolean[] jchar[] ".contains(" " + sort + " ")) {
                sort = sort.substring(1);
            }
            if (this.isPrimitiveType(sort)) continue;
            result.add(sort);
        }
        for (String sort : this.usedObjectSortsStrings) {
            if (" jbyte jint jlong jfloat jdouble jboolean jchar ".contains(" " + sort + " ")) continue;
            if (" jbyte[] jint[] jlong[] jfloat[] jdouble[] jboolean[] jchar[] ".contains(" " + sort + " ")) {
                sort = sort.substring(1);
            }
            if (this.isPrimitiveType(sort)) continue;
            result.add(sort);
        }
        return result;
    }

    private StringBuilder classDecl(boolean staticClass) {
        StringBuilder r = new StringBuilder();
        r.append(NEW_LINE);
        r.append("// This file was generated by KeY Version " + KeYConstants.VERSION + " (www.key-project.org)." + NEW_LINE + NEW_LINE + "/** This class enables the test suite to read and write protected and private" + NEW_LINE + " * fields of other classes. It can also simulate ghost fields using a hashmap." + NEW_LINE + " * Ghostfields are implicit fields that exist in the specification but not in the" + NEW_LINE + " * actual Java class. Futhermore, this class also enables to create an object of " + NEW_LINE + " * any class even if it has no default constructor. To create objects the " + NEW_LINE + " * the objenesis library is required and must be provided when compiling and" + NEW_LINE + " * executing the test suite. " + NEW_LINE);
        r.append(" * @see http://docs.oracle.com/javase/tutorial/reflect/member/ctorInstance.html" + NEW_LINE);
        r.append(" * @see http://code.google.com/p/objenesis/" + NEW_LINE + " * @see http://objenesis.org/" + NEW_LINE);
        r.append(" * @author gladisch" + NEW_LINE);
        r.append(" * @author mbender" + NEW_LINE);
        r.append(" */" + NEW_LINE);
        r.append("public ");
        if (staticClass) {
            r.append("static ");
        }
        r.append("class RFL {" + NEW_LINE);
        return r;
    }

    private StringBuilder ghostMapDecls(boolean ghostMapActive) {
        StringBuilder r = new StringBuilder();
        r.append(NEW_LINE);
        r.append("  private static final String NoSuchFieldExceptionText;");
        r.append("  public static boolean ghostMapActive;");
        r.append("  public static java.util.HashMap<Integer,Object> ghostModelFields;" + NEW_LINE + NEW_LINE);
        r.append("  public static int getHash(Class<?> c, Object obj, String attr){" + NEW_LINE);
        r.append("    return c.hashCode() * (obj!=null?obj.hashCode():1) * attr.hashCode();" + NEW_LINE);
        r.append("  }" + NEW_LINE + NEW_LINE);
        return r;
    }

    private StringBuilder instanceMethod() {
        StringBuilder r = new StringBuilder();
        r.append(NEW_LINE + NEW_LINE);
        r.append("  /** The Objenesis library can create instances of classes that have no default constructor. */" + NEW_LINE);
        r.append("  private static org.objenesis.Objenesis objenesis;" + NEW_LINE + NEW_LINE);
        r.append("  private static Object newInstance(Class c) throws Exception {" + NEW_LINE);
        r.append("    Object res=objenesis.newInstance(c);" + NEW_LINE);
        r.append("    if (res==null)" + NEW_LINE);
        r.append("      throw new Exception(\"Couldn't create instance of class:\"+c);" + NEW_LINE);
        r.append("  return res;" + NEW_LINE);
        r.append("  }" + NEW_LINE);
        return r;
    }

    private StringBuilder staticInitializer(boolean ghostMapActive) {
        StringBuilder r = new StringBuilder();
        String tab = "   ";
        r.append(NEW_LINE + NEW_LINE);
        r.append(tab + "static{" + NEW_LINE);
        r.append(tab + "objenesis = new org.objenesis.ObjenesisStd();" + NEW_LINE);
        r.append(tab + "ghostMapActive = " + ghostMapActive + ";" + NEW_LINE);
        r.append(tab + "ghostModelFields = new java.util.HashMap<Integer,Object>();" + NEW_LINE);
        r.append(tab + "NoSuchFieldExceptionText =" + NEW_LINE);
        r.append(tab + tab + "  \"This exception occurs when ghost fields or model fields are used in the code or \" +" + NEW_LINE);
        r.append(tab + tab + "  \"if mock objects are used that have different fields, than the real objects. \" +" + NEW_LINE);
        r.append(tab + tab + "  \"The tester should extend the handling of such fields in this generated utility class RFL.java.\";" + NEW_LINE);
        r.append("}" + NEW_LINE + NEW_LINE);
        return r;
    }

    private StringBuilder instances(HashSet<String> sorts) {
        StringBuilder r = new StringBuilder();
        r.append(NEW_LINE + "  // ---The methods for object creation---" + NEW_LINE + NEW_LINE);
        for (String sort : sorts) {
            r.append((CharSequence)this.newRef(sort));
        }
        r.append(NEW_LINE);
        return r;
    }

    private StringBuilder newRef(String sort) {
        if (sort.indexOf(91) != -1) {
            return this.newArray(sort);
        }
        return this.newInstance(sort);
    }

    public static String cleanTypeName(String s) {
        if (" jbyte jint jlong jfloat jdouble jboolean jchar jbyte[] jint[] jlong[] jfloat[] jdouble[] jboolean[] jchar[] ".indexOf(" " + (String)s + " ") != -1) {
            s = ((String)s).substring(1);
        }
        while (((String)s).indexOf(".") != -1) {
            s = ((String)s).substring(0, ((String)s).indexOf(".")) + "_" + ((String)s).substring(((String)s).indexOf(".") + 1);
        }
        while (((String)s).indexOf("[]") != -1) {
            s = ((String)s).substring(0, ((String)s).indexOf("[]")) + ARRAY + ((String)s).substring(((String)s).indexOf("[]") + 2);
        }
        return s;
    }

    private StringBuilder newInstance(String sort) {
        StringBuilder r = new StringBuilder();
        r.append(NEW_LINE);
        r.append("  public static " + sort + " new" + ReflectionClassCreator.cleanTypeName(sort) + "() throws java.lang.RuntimeException {" + NEW_LINE);
        r.append("    try{" + NEW_LINE);
        r.append("      return (" + sort + ")newInstance(" + sort + ".class);" + NEW_LINE);
        r.append("    } catch (java.lang.Throwable e) {" + NEW_LINE);
        r.append("       throw new java.lang.RuntimeException(e);" + NEW_LINE);
        r.append("    }" + NEW_LINE);
        r.append("  }" + NEW_LINE);
        return r;
    }

    private StringBuilder newArray(String sort) {
        StringBuilder r = new StringBuilder();
        r.append(NEW_LINE);
        r.append("  public static " + sort + " new" + ReflectionClassCreator.cleanTypeName(sort) + "(int dim){" + NEW_LINE);
        r.append("    return new " + sort.substring(0, sort.length() - 2) + "[dim];" + NEW_LINE);
        r.append("  }" + NEW_LINE);
        return r;
    }

    private boolean isPrimitiveType(String sort) {
        for (String s : PRIMITIVE_TYPES) {
            if (!s.equals(sort)) continue;
            return true;
        }
        return false;
    }

    private StringBuilder getterAndSetter(HashSet<String> sorts) {
        StringBuilder result = new StringBuilder();
        result.append(NEW_LINE + "  // ---Getter and setter for primitive types---" + NEW_LINE);
        for (int i = 0; i < 7; ++i) {
            result.append(NEW_LINE);
            result.append((CharSequence)this.declareSetter(PRIMITIVE_TYPES[i], true));
            result.append((CharSequence)this.declareGetter(PRIMITIVE_TYPES[i], PRIM_TYP_DEF_VAL[i], true));
        }
        result.append(NEW_LINE);
        result.append(NEW_LINE + "  // ---Getter and setter for Reference types---" + NEW_LINE);
        for (String sort : sorts) {
            result.append(NEW_LINE);
            result.append((CharSequence)this.declareSetter(sort, false));
            result.append((CharSequence)this.declareGetter(sort, "null", false));
        }
        return result;
    }

    private StringBuilder declareSetter(String sort, boolean prim) {
        StringBuilder r = new StringBuilder();
        String cmd = "      " + (prim ? "f.set" + Character.toUpperCase(sort.charAt(0)) + sort.substring(1) + "(obj, val);" + NEW_LINE : "f.set(obj, val);" + NEW_LINE);
        r.append(NEW_LINE);
        r.append("  public static void _set_" + ReflectionClassCreator.cleanTypeName(sort) + "(Class<?> c, Object obj, String attr, " + sort + " val) throws RuntimeException{" + NEW_LINE);
        r.append("    try {" + NEW_LINE);
        r.append("      java.lang.reflect.Field f = c.getDeclaredField(attr);" + NEW_LINE);
        r.append("      f.setAccessible(true);" + NEW_LINE);
        r.append(cmd);
        r.append("    } catch(NoSuchFieldException e) {" + NEW_LINE);
        r.append("      if(ghostMapActive)" + NEW_LINE);
        r.append("        ghostModelFields.put(getHash(c,obj,attr), val);" + NEW_LINE);
        r.append("      else" + NEW_LINE);
        r.append("        throw new RuntimeException(e.toString() + NoSuchFieldExceptionText);" + NEW_LINE);
        r.append("    } catch(Exception e) {" + NEW_LINE);
        r.append("      throw new RuntimeException(e);" + NEW_LINE);
        r.append("    }" + NEW_LINE);
        r.append("  }" + NEW_LINE);
        return r;
    }

    private String primToWrapClass(String sort) {
        if (sort.equals("int")) {
            return "Integer";
        }
        if (sort.equals("char")) {
            return "Character";
        }
        return Character.toUpperCase(sort.charAt(0)) + sort.substring(1);
    }

    private StringBuilder declareGetter(String sort, String def, boolean prim) {
        StringBuilder r = new StringBuilder();
        String cmd = "      " + (prim ? "return f.get" + Character.toUpperCase(sort.charAt(0)) + sort.substring(1) + "(obj);" + NEW_LINE : "return (" + sort + ") f.get(obj);" + NEW_LINE);
        r.append(NEW_LINE);
        r.append("  public static " + sort + " _get_" + ReflectionClassCreator.cleanTypeName(sort) + "(Class<?> c, Object obj, String attr) throws RuntimeException{" + NEW_LINE);
        r.append("    " + sort + " res = " + def + ";" + NEW_LINE);
        r.append("    try {" + NEW_LINE);
        r.append("      java.lang.reflect.Field f = c.getDeclaredField(attr);" + NEW_LINE);
        r.append("      f.setAccessible(true);" + NEW_LINE);
        r.append(cmd);
        r.append("      } catch(NoSuchFieldException e) {" + NEW_LINE);
        r.append("      return (" + (prim ? this.primToWrapClass(sort) : sort) + ")ghostModelFields.get(getHash(c,obj,attr));" + NEW_LINE);
        r.append("    } catch(Exception e) {" + NEW_LINE);
        r.append("      throw new RuntimeException(e);" + NEW_LINE);
        r.append("    }" + NEW_LINE);
        r.append("  }" + NEW_LINE);
        return r;
    }

    private String footer() {
        return "}" + NEW_LINE;
    }

    private boolean checkBraces(StringBuilder buf) {
        int curly = 0;
        int round = 0;
        int edged = 0;
        block8: for (int i = 0; i < buf.length(); ++i) {
            switch (buf.charAt(i)) {
                case '{': {
                    ++curly;
                    continue block8;
                }
                case '}': {
                    --curly;
                    continue block8;
                }
                case '(': {
                    ++round;
                    continue block8;
                }
                case ')': {
                    --round;
                    continue block8;
                }
                case '[': {
                    ++edged;
                    continue block8;
                }
                case ']': {
                    --edged;
                }
            }
        }
        if (curly == 0 && round == 0 && edged == 0) {
            return true;
        }
        LOGGER.error("Error braces in RFL.java: curly: {} round: {}: egded: {}", new Object[]{curly, round, edged});
        return false;
    }
}

