/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.testgen;

import de.uka.ilkd.key.java.JavaInfo;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.declaration.MethodDeclaration;
import de.uka.ilkd.key.java.declaration.ParameterDeclaration;
import de.uka.ilkd.key.java.declaration.VariableSpecification;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.logic.Named;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.ObserverFunction;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.TestGenerationSettings;
import de.uka.ilkd.key.smt.SMTSolver;
import de.uka.ilkd.key.smt.model.Heap;
import de.uka.ilkd.key.smt.model.Model;
import de.uka.ilkd.key.smt.model.ObjectVal;
import de.uka.ilkd.key.smt.testgen.TestGenerationLog;
import de.uka.ilkd.key.testgen.Assignment;
import de.uka.ilkd.key.testgen.ProofInfo;
import de.uka.ilkd.key.testgen.RefEx;
import de.uka.ilkd.key.testgen.ReflectionClassCreator;
import de.uka.ilkd.key.testgen.oracle.OracleGenerator;
import de.uka.ilkd.key.testgen.oracle.OracleMethod;
import de.uka.ilkd.key.testgen.oracle.OracleMethodCall;
import de.uka.ilkd.key.util.KeYConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.key_project.util.java.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseGenerator {
    public static final String JAVA_FILE_EXTENSION_WITH_DOT = ".java";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseGenerator.class);
    public static final String NEW_LINE = StringUtil.NEW_LINE;
    private static final String NULLABLE = "/*@ nullable */";
    public static final String ALL_OBJECTS = "allObjects";
    public static final String ALL_INTS = "allInts";
    public static final String ALL_BOOLS = "allBools";
    public static final String ALL_HEAPS = "allHeaps";
    public static final String ALL_FIELDS = "allFields";
    public static final String ALL_SEQ = "allSeq";
    public static final String ALL_LOCSETS = "allLocSets";
    public static final String OBJENESIS_NAME = "objenesis-2.2.jar";
    public static final String OLDMap = "old";
    public static final String TAB = "   ";
    private final Services services;
    static int fileCounter = 0;
    private final boolean junitFormat;
    private static final String DONT_COPY = "aux";
    private final boolean rflAsInternalClass;
    protected boolean useRFL;
    protected ReflectionClassCreator rflCreator;
    private final String dontCopy;
    protected final String modDir;
    protected final String directory;
    private TestGenerationLog logger;
    private String fileName;
    private String packageName;
    private final String mutName;
    private final ProofInfo info;
    private final OracleGenerator oracleGenerator;
    private List<OracleMethod> oracleMethods;
    private String oracleMethodCall;
    private final Map<Sort, StringBuilder> sortDummyClass;
    final String dummyPostfix = "DummyImpl";
    private String compileWithOpenJML = "#!/bin/bash" + NEW_LINE + NEW_LINE + "if [ -e \"openjml.jar\" ]" + NEW_LINE + "then" + NEW_LINE + "   java -jar openjml.jar -cp \".\" -rac *.java" + NEW_LINE + "else" + NEW_LINE + "   echo \"openjml.jar not found!\"" + NEW_LINE + "   echo \"Download openJML from http://sourceforge.net/projects/jmlspecs/files/\"" + NEW_LINE + "   echo \"Copy openjml.jar into the directory with test files.\"" + NEW_LINE + "fi" + NEW_LINE;
    private final String executeWithOpenJML;

    public static boolean modelIsOK(Model m) {
        return m != null && !m.isEmpty() && m.getHeaps() != null && m.getHeaps().size() > 0 && m.getTypes() != null;
    }

    private String createCompileWithOpenJML(String openJMLPath, String objenesisPath) {
        return "#!/bin/bash" + NEW_LINE + NEW_LINE + "if [ -e \"" + openJMLPath + File.separator + "openjml.jar\" ] " + NEW_LINE + "then" + NEW_LINE + "   if [ -e \"" + objenesisPath + File.separator + "objenesis-2.2.jar\" ]" + NEW_LINE + "   then" + NEW_LINE + "      java -jar " + openJMLPath + File.separator + "openjml.jar -cp \"." + objenesisPath + File.separator + "objenesis-2.2.jar\" -rac *.java" + NEW_LINE + "   else" + NEW_LINE + "      echo \"objenesis-2.2.jar not found!\"" + NEW_LINE + "   fi" + NEW_LINE + "else" + NEW_LINE + "   echo \"openjml.jar not found!\"" + NEW_LINE + "   echo \"Download openJML from http://sourceforge.net/projects/jmlspecs/files/\"" + NEW_LINE + "   echo \"Copy openjml.jar into the directory with test files.\"" + NEW_LINE + "fi" + NEW_LINE;
    }

    private String createExecuteWithOpenJML(String path, String objenesisPath) {
        return "#!/bin/bash" + NEW_LINE + "if [ -e \"" + path + File.separator + "jmlruntime.jar\" ]" + NEW_LINE + "then  if [ -e \"" + path + File.separator + "jmlspecs.jar\" ]" + NEW_LINE + "  then" + NEW_LINE + "     if [ -e \"" + objenesisPath + File.separator + "objenesis-2.2.jar\" ]" + NEW_LINE + "     then" + NEW_LINE + "        if [ \"$1\" = \"\" ] ; then" + NEW_LINE + "           echo \"Provide the test driver as an argument (without .java postfix). For example:\"" + NEW_LINE + "           echo \"  executeWithOpenJML.sh TestGeneric0 \"" + NEW_LINE + "           echo \"Make sure that jmlruntime.jar and jmlspecs.jar are in the\"" + NEW_LINE + "           echo \"current directory.\"" + NEW_LINE + "           quit" + NEW_LINE + "        else" + NEW_LINE + "           java -cp " + objenesisPath + File.separator + "objenesis-2.2.jar:" + path + File.separator + "jmlruntime.jar:" + path + File.separator + "jmlspecs.jar:. $1" + NEW_LINE + "        fi" + NEW_LINE + "      else" + NEW_LINE + "         echo \"objenesis-2.2.jar not found!\"" + NEW_LINE + "      fi" + NEW_LINE + "else" + NEW_LINE + "  echo \"jmlspecs.jar not found!\"" + NEW_LINE + "  echo \"Download openJML from http://sourceforge.net/projects/jmlspecs/files/\"" + NEW_LINE + "  echo \"Copy jmlspecs.jar into the directory with test files.\"" + NEW_LINE + "  quit" + NEW_LINE + "fi" + NEW_LINE + "else" + NEW_LINE + "   echo \"jmlruntime.jar not found!\"" + NEW_LINE + "   echo \"Download openJML from http://sourceforge.net/projects/jmlspecs/files/\"" + NEW_LINE + "   echo \"Copy jmlruntime.jar into the directory with test files.\"" + NEW_LINE + "   quit" + NEW_LINE + "fi" + NEW_LINE;
    }

    public TestCaseGenerator(Proof proof) {
        this(proof, false);
    }

    public TestCaseGenerator(Proof proof, boolean rflAsInternalClass) {
        this.rflAsInternalClass = rflAsInternalClass;
        TestGenerationSettings settings = TestGenerationSettings.getInstance();
        this.services = proof.getServices();
        this.junitFormat = settings.useJunit();
        this.useRFL = settings.useRFL();
        this.modDir = this.computeProjectSubPath(this.services.getJavaModel().getModelDir());
        this.dontCopy = this.modDir + File.separator + DONT_COPY;
        this.directory = settings.getOutputFolderPath();
        this.sortDummyClass = new HashMap<Sort, StringBuilder>();
        this.info = new ProofInfo(proof);
        this.mutName = this.info.getMUT().getFullName();
        this.rflCreator = new ReflectionClassCreator();
        this.executeWithOpenJML = this.createExecuteWithOpenJML(settings.getOpenjmlPath(), settings.getObjenesisPath());
        this.compileWithOpenJML = this.createCompileWithOpenJML(settings.getOpenjmlPath(), settings.getObjenesisPath());
        this.oracleGenerator = new OracleGenerator(this.services, this.rflCreator, this.useRFL);
        if (this.junitFormat) {
            this.oracleMethods = new LinkedList<OracleMethod>();
            this.oracleMethodCall = this.getOracleAssertion(this.oracleMethods);
        }
    }

    protected String computeProjectSubPath(String modelDir) {
        if (modelDir.startsWith("/")) {
            return modelDir;
        }
        int index = modelDir.indexOf(File.separator);
        if (index >= 0) {
            return modelDir.substring(index);
        }
        return modelDir;
    }

    public String getMUTCall() {
        IProgramMethod m = this.info.getMUT();
        String name = m.getFullName();
        StringBuilder params = new StringBuilder();
        for (ParameterDeclaration p : m.getParameters()) {
            for (VariableSpecification v : p.getVariables()) {
                IProgramVariable var = v.getProgramVariable();
                params.append(",").append(var.name());
            }
        }
        if (params.length() > 0) {
            params = new StringBuilder(params.substring(1));
        }
        String caller = m.isStatic() ? this.info.getTypeOfClassUnderTest().getName() : "self";
        if (m.getReturnType().equals((Object)KeYJavaType.VOID_TYPE)) {
            return caller + "." + name + "(" + params + ");";
        }
        String returnType = m.getReturnType().getFullName();
        return returnType + " result = " + caller + "." + name + "(" + params + ");";
    }

    protected String buildDummyClassForAbstractSort(Sort sort) {
        JavaInfo jinfo = this.services.getJavaInfo();
        KeYJavaType kjt = jinfo.getKeYJavaType(sort);
        String className = this.getDummyClassNameFor(sort);
        if (this.sortDummyClass.containsKey(sort)) {
            return className;
        }
        StringBuilder sb = new StringBuilder();
        this.sortDummyClass.put(sort, sb);
        sb.append("import ").append(sort.declarationString()).append(";").append(NEW_LINE).append(NEW_LINE);
        sb.append("class ").append(className).append(" implements ").append(sort.declarationString()).append("{").append(NEW_LINE);
        sb.append(" public ").append(className).append("(){ };").append(NEW_LINE);
        for (IProgramMethod m : jinfo.getAllProgramMethods(kjt)) {
            if (m.getFullName().indexOf(60) > -1 || m.isPrivate() || m.isFinal() || !m.isAbstract()) continue;
            sb.append(" ");
            MethodDeclaration md = m.getMethodDeclaration();
            if (m.isProtected()) {
                sb.append("protected ");
            }
            if (m.isPublic()) {
                sb.append("public ");
            }
            if (m.isFinal()) {
                sb.append("final ");
            }
            if (m.isStatic()) {
                sb.append("static ");
            }
            if (m.isSynchronized()) {
                sb.append("synchronized ");
            }
            if (md.getTypeReference() == null) {
                sb.append("void ");
            } else {
                sb.append(md.getTypeReference().toString()).append(" ");
            }
            sb.append(m.getName()).append("(");
            Iterator pdIter = md.getParameters().iterator();
            int varcount = 0;
            while (pdIter.hasNext()) {
                ParameterDeclaration pd = (ParameterDeclaration)pdIter.next();
                if (pd.isFinal()) {
                    sb.append("final ");
                }
                if (pd.getTypeReference() == null) {
                    sb.append("void /*unkown type*/ ");
                } else {
                    sb.append(pd.getTypeReference().toString()).append(" ");
                }
                if (pd.getVariables().isEmpty()) {
                    sb.append("var").append(varcount);
                } else {
                    sb.append(((VariableSpecification)pd.getVariables().iterator().next()).getFullName());
                }
                if (pdIter.hasNext()) {
                    sb.append(", ");
                }
                ++varcount;
            }
            sb.append(")");
            if (md.getThrown() != null) {
                sb.append(" throws ").append(md.getThrown().getTypeReferenceAt(0)).append(" ").append(NEW_LINE).append(" ");
            }
            if (md.getTypeReference() == null) {
                sb.append("{ };");
            } else {
                String type = md.getTypeReference().toString();
                if (this.isNumericType(type)) {
                    sb.append("{ return 0;}");
                } else if (type.equals("boolean")) {
                    sb.append("{ return true;}");
                } else if (type.equals("char")) {
                    sb.append("{ return 'a';}");
                } else {
                    boolean returnNull = true;
                    try {
                        String retType = md.getTypeReference().getKeYJavaType().getSort().name().toString();
                        if (retType.equals("java.lang.String")) {
                            sb.append("{ return \"").append(className).append("\";}");
                            returnNull = false;
                        }
                    }
                    catch (Exception e) {
                        returnNull = true;
                    }
                    if (returnNull) {
                        sb.append("{ return null;}");
                    }
                }
            }
            sb.append(NEW_LINE);
        }
        sb.append("}");
        return className;
    }

    private void copyFiles(String srcName, String targName) throws IOException {
        block20: {
            if (srcName.equals(this.dontCopy)) {
                return;
            }
            File srcFile = new File(srcName);
            if (!srcFile.exists()) {
                throw new IOException("FileCopy: no such source file: " + srcName);
            }
            if (!srcFile.canRead()) {
                throw new IOException("FileCopy: source file is unreadable: " + srcName);
            }
            if (srcFile.isDirectory()) {
                Object newTarget = srcName.equals(this.modDir) ? targName : targName + File.separator + srcFile.getName();
                for (String subName : srcFile.list()) {
                    this.copyFiles(srcName + File.separator + subName, (String)newTarget);
                }
            } else {
                if (srcFile.isFile()) {
                    File targFile;
                    File targDir = new File(targName);
                    if (!targDir.exists()) {
                        targDir.mkdirs();
                    }
                    if ((targFile = new File(targDir, srcFile.getName())).exists() && !targFile.canWrite()) {
                        throw new IOException("FileCopy: destination file is unwriteable: " + targName);
                    }
                    try (FileInputStream src = new FileInputStream(srcFile);
                         FileOutputStream targ = new FileOutputStream(targFile);){
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = src.read(buffer)) != -1) {
                            targ.write(buffer, 0, bytesRead);
                        }
                        break block20;
                    }
                }
                throw new IOException("FileCopy: " + srcName + " is neither a file nor a directory!");
            }
        }
    }

    protected void createDummyClasses() throws IOException {
        for (Sort s : this.sortDummyClass.keySet()) {
            StringBuilder sb = this.sortDummyClass.get(s);
            String file = this.getDummyClassNameFor(s) + JAVA_FILE_EXTENSION_WITH_DOT;
            this.writeToFile(file, sb);
        }
    }

    protected void writeRFLFile() throws IOException {
        this.writeToFile("RFL.java", this.createRFLFileContent());
    }

    public StringBuilder createRFLFileContent() {
        return this.rflCreator.createClass(this.rflAsInternalClass);
    }

    protected void createOpenJMLShellScript() throws IOException {
        StringBuilder sb = new StringBuilder();
        String filestr = "compileWithOpenJML.sh";
        File file = new File(this.directory + this.modDir + File.separator + filestr);
        if (!file.exists()) {
            sb.append(this.compileWithOpenJML);
            this.writeToFile(filestr, sb);
        }
        if (!(file = new File(this.directory + this.modDir + File.separator + (filestr = "executeWithOpenJML.sh"))).exists()) {
            sb = new StringBuilder();
            sb.append(this.executeWithOpenJML);
            this.writeToFile(filestr, sb);
        }
    }

    protected void exportCodeUnderTest() throws IOException {
        this.copyFiles(this.modDir, this.directory + this.modDir);
    }

    private boolean filterVal(String s) {
        return !s.startsWith("#a") && !s.startsWith("#s") && !s.startsWith("#h") && !s.startsWith("#l") && !s.startsWith("#f");
    }

    protected String getOracleAssertion(List<OracleMethod> oracleMethods) {
        Term postcondition = this.getPostCondition();
        OracleMethod oracle = this.oracleGenerator.generateOracleMethod(postcondition);
        OracleMethodCall oracleCall = new OracleMethodCall(oracle, oracle.getArgs());
        oracleMethods.add(oracle);
        oracleMethods.addAll(this.oracleGenerator.getOracleMethods());
        LOGGER.debug("Modifier Set: {}", (Object)this.oracleGenerator.getOracleLocationSet(this.info.getAssignable()));
        return "assertTrue(" + oracleCall + ");";
    }

    private Term getPostCondition() {
        return this.info.getPostCondition();
    }

    public String generateJUnitTestSuite(Collection<SMTSolver> problemSolvers) throws IOException {
        this.initFileName();
        StringBuilder testSuite = this.createTestCaseCotent(problemSolvers);
        this.writeToFile(this.fileName + JAVA_FILE_EXTENSION_WITH_DOT, testSuite);
        this.logger.writeln("Writing test file to:" + this.directory + this.modDir + File.separator + this.fileName + JAVA_FILE_EXTENSION_WITH_DOT);
        this.exportCodeUnderTest();
        this.createDummyClasses();
        try {
            if (this.useRFL) {
                this.writeRFLFile();
            }
        }
        catch (Exception ex) {
            this.logger.writeln("Error: The file RFL.java is either not generated or it has an error.");
            LOGGER.error("Error: The file RFL {} is either not generated or it has an error.", (Object)JAVA_FILE_EXTENSION_WITH_DOT);
        }
        this.createOpenJMLShellScript();
        ++fileCounter;
        return testSuite.toString();
    }

    public void initFileName() {
        this.fileName = "TestGeneric" + fileCounter;
        String mut = this.getMUTCall();
        if (mut == null) {
            mut = "<method under test> //Manually write a call to the method under test, because KeY could not determine it automatically.";
        } else {
            this.fileName = this.fileName + "_" + this.mutName;
        }
    }

    public StringBuilder createTestCaseCotent(Collection<SMTSolver> problemSolvers) {
        StringBuilder testSuite = new StringBuilder();
        testSuite.append(this.getFilePrefix(this.fileName, this.packageName)).append(NEW_LINE);
        StringBuilder testMethods = new StringBuilder();
        int i = 0;
        for (SMTSolver solver : problemSolvers) {
            try {
                Model m;
                StringBuilder testMethod = new StringBuilder();
                String originalNodeName = solver.getProblem().getGoal().proof().name().toString();
                boolean success = false;
                if (solver.getSocket().getQuery() != null && TestCaseGenerator.modelIsOK(m = solver.getSocket().getQuery().getModel())) {
                    this.logger.writeln("Generate: " + originalNodeName);
                    Map<String, Sort> typeInfMap = this.generateTypeInferenceMap(solver.getProblem().getGoal().node());
                    testMethod.append("  //").append(originalNodeName).append(NEW_LINE);
                    testMethod.append(this.getTestMethodSignature(i)).append("{").append(NEW_LINE);
                    testMethod.append("   //Test preamble: creating objects and intializing test data").append(this.generateTestCase(m, typeInfMap)).append(NEW_LINE).append(NEW_LINE);
                    HashSet<Term> vars = new HashSet<Term>();
                    this.info.getProgramVariables(this.info.getPO(), vars);
                    testMethod.append("   //Other variables").append(NEW_LINE).append(this.getRemainingConstants(m.getConstants().keySet(), vars)).append(NEW_LINE);
                    testMethod.append("   //Calling the method under test   ").append(NEW_LINE).append(this.info.getCode()).append(NEW_LINE);
                    if (this.junitFormat) {
                        testMethod.append("   //calling the test oracle").append(NEW_LINE).append(TAB).append(this.oracleMethodCall).append(NEW_LINE);
                    }
                    testMethod.append(" }").append(NEW_LINE).append(NEW_LINE);
                    ++i;
                    success = true;
                    testMethods.append((CharSequence)testMethod);
                }
                if (success) continue;
                this.logger.writeln("A model (test data) was not generated for:" + originalNodeName);
            }
            catch (Exception ex) {
                for (StackTraceElement ste : ex.getStackTrace()) {
                    this.logger.writeln(ste.toString());
                }
                this.logger.writeln("A test case was not generated due to an exception. Continuing test generation...");
            }
        }
        if (i == 0) {
            this.logger.writeln("Warning: no test case was generated. Adjust the SMT solver settings (e.g. timeout) in Options->SMT Solvers.");
        } else if (i < problemSolvers.size()) {
            this.logger.writeln("Warning: SMT solver could not solve all test data constraints. Adjust the SMT solver settings (e.g. timeout) in Options->SMT Solvers.");
        }
        testSuite.append((CharSequence)this.getMainMethod(this.fileName, i)).append(NEW_LINE).append(NEW_LINE);
        testSuite.append((CharSequence)testMethods);
        if (this.junitFormat) {
            for (OracleMethod m : this.oracleMethods) {
                testSuite.append(NEW_LINE).append(NEW_LINE);
                testSuite.append(m);
            }
        }
        if (this.rflAsInternalClass) {
            testSuite.append((CharSequence)this.createRFLFileContent());
        }
        testSuite.append(NEW_LINE).append("}");
        return testSuite;
    }

    protected String inferSort(Map<String, Sort> typeInfMap, String progVar) {
        if (typeInfMap.containsKey(progVar)) {
            return typeInfMap.get(progVar).name().toString();
        }
        LOGGER.warn("Warning: inferSort did not find:  {}", (Object)progVar);
        return "NOTYPE";
    }

    protected Map<String, Sort> generateTypeInferenceMap(Node n) {
        HashMap<String, Sort> typeInfMap = new HashMap<String, Sort>();
        for (SequentFormula sequentFormula : n.sequent()) {
            Term t = sequentFormula.formula();
            this.generateTypeInferenceMapHelper(t, typeInfMap);
        }
        return typeInfMap;
    }

    private void generateTypeInferenceMapHelper(Term t, Map<String, Sort> map) {
        String name;
        Operator op = t.op();
        if (op instanceof ProgramVariable) {
            ProgramVariable pv = (ProgramVariable)t.op();
            name = pv.name().toString();
            if (map.containsKey(name)) {
                if (map.get(name) != pv.sort()) {
                    LOGGER.warn("Warning: ProgramVariable {} is ambiguous.", (Object)name);
                }
            } else {
                LOGGER.debug("PV {} Sort: {} KeYJavaType: {}", new Object[]{name, pv.sort(), pv.getKeYJavaType()});
                map.put(name, pv.sort());
            }
        } else if (op instanceof Function && !(op instanceof ObserverFunction)) {
            HeapLDT hLDT;
            Function func = (Function)t.op();
            name = func.name().toString();
            Sort sort = func.sort();
            if (sort == (hLDT = this.services.getTypeConverter().getHeapLDT()).getFieldSort()) {
                ProgramVariable pv = this.getProgramVariable(t);
                if (pv != null) {
                    if (map.containsKey(name = name.replace("::$", "::"))) {
                        if (map.get(name) != pv.sort()) {
                            LOGGER.warn("Function {} is ambiguous.", (Object)name);
                        }
                    } else {
                        LOGGER.debug("Func: {} Sort: {} PV.sort: {}", new Object[]{name, func.sort(), pv.sort()});
                        map.put(name, pv.sort());
                    }
                } else {
                    LOGGER.warn("Program variable could not be determined: {}", (Object)t);
                }
            }
        }
        for (int i = 0; i < t.arity(); ++i) {
            this.generateTypeInferenceMapHelper(t.sub(i), map);
        }
    }

    private ProgramVariable getProgramVariable(Term locationTerm) {
        HeapLDT heapLDT = this.services.getTypeConverter().getHeapLDT();
        ProgramVariable result = null;
        if (locationTerm.op() instanceof Function) {
            Function function = (Function)locationTerm.op();
            if (heapLDT.getArr() != function) {
                String typeName = HeapLDT.getClassName((Function)function);
                KeYJavaType type = this.services.getJavaInfo().getKeYJavaType(typeName);
                if (type != null) {
                    String fieldName = HeapLDT.getPrettyFieldName((Named)function);
                    result = this.services.getJavaInfo().getAttribute(fieldName, type);
                }
            }
        }
        return result;
    }

    private String getRemainingConstants(Collection<String> existingConstants, Collection<Term> newConstants) {
        StringBuilder result = new StringBuilder();
        for (Term c : newConstants) {
            if (existingConstants.contains(c.toString())) continue;
            String init = "null";
            if (c.sort().equals(this.services.getTypeConverter().getIntegerLDT().targetSort())) {
                init = "0";
            } else if (c.sort().equals(this.services.getTypeConverter().getBooleanLDT().targetSort())) {
                init = "false";
            }
            result.append(NEW_LINE).append(TAB).append(NULLABLE).append(" ").append(this.getSafeType(c.sort())).append(" ").append(c).append(" = ").append(init).append(";");
            if (!this.junitFormat) continue;
            result.append(NEW_LINE).append(TAB).append(NULLABLE).append(" ").append(this.getSafeType(c.sort())).append(" ").append(this.getPreName(c.toString())).append(" = ").append(init).append(";");
        }
        return result.toString();
    }

    private boolean isInPrestate(Collection<? extends ObjectVal> prestate, ObjectVal o) {
        return true;
    }

    private boolean isInPrestate(Collection<? extends ObjectVal> prestate, String name) {
        return true;
    }

    public String generateModifierSetAssertions(Model m) {
        StringBuilder res = new StringBuilder();
        res.append("   //Modifier set assertions");
        return res.toString();
    }

    public String generateTestCase(Model m, Map<String, Sort> typeInfMap) {
        m.removeUnnecessaryObjects();
        HashSet<String> objects = new HashSet<String>();
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        Object heap = null;
        for (Object h : m.getHeaps()) {
            if (!h.getName().equals(HeapLDT.BASE_HEAP_NAME.toString())) continue;
            heap = h;
            break;
        }
        HashSet prestate = new HashSet();
        if (heap != null) {
            for (ObjectVal o : heap.getObjects()) {
                Object right;
                if (o.getName().equals("#o0")) continue;
                String type = this.getSafeType(o.getSort());
                if (type.endsWith("[]")) {
                    right = "new " + type.substring(0, type.length() - 2) + "[" + o.getLength() + "]";
                } else if (o.getSort() == null || o.getSort().toString().equals("Null")) {
                    right = "null";
                } else if (this.useRFL) {
                    right = "RFL.new" + ReflectionClassCreator.cleanTypeName(type) + "()";
                    this.rflCreator.addSort(type);
                    LOGGER.debug("Adding sort (create Object): {}", (Object)type);
                } else {
                    right = "new " + type + "()";
                }
                String objName = this.createObjectName(o);
                objects.add(objName);
                assignments.add(new Assignment(type, objName, (String)right));
                if (!this.junitFormat || !this.isInPrestate(prestate, o)) continue;
                assignments.add(new Assignment(type, this.getPreName(objName), (String)right));
            }
        }
        for (String c : m.getConstants().keySet()) {
            String val = (String)m.getConstants().get(c);
            if (!this.filterVal(val) || c.equals("null")) continue;
            boolean isObject = false;
            boolean isLiteral = false;
            String type = "int";
            if (val.equals("true") || val.equals("false")) {
                type = "boolean";
                isLiteral = true;
            } else if (StringUtil.isNumber((String)val)) {
                isLiteral = true;
            } else if (val.startsWith("#o")) {
                isObject = true;
                type = this.inferSort(typeInfMap, c);
            }
            if (type.equals("NOTYPE")) continue;
            Object declType = isObject ? "/*@ nullable */ " + type : type;
            val = this.translateValueExpression(val);
            assignments.add(new Assignment((String)declType, c, "(" + type + ")" + val));
            if (!this.junitFormat || !isObject && !Character.isJavaIdentifierStart(c.charAt(0)) || !this.isInPrestate(prestate, val)) continue;
            if (isLiteral) {
                assignments.add(new Assignment((String)declType, this.getPreName(c), "(" + type + ")" + val));
                continue;
            }
            assignments.add(new Assignment((String)declType, this.getPreName(c), "(" + type + ")" + this.getPreName(val)));
        }
        if (heap != null) {
            for (ObjectVal o : heap.getObjects()) {
                if (o.getName().equals("#o0") || o.getSort().name().toString().endsWith("Exception")) continue;
                String receiverObject = this.createObjectName(o);
                for (String f : o.getFieldvalues().keySet()) {
                    if (f.contains("<") || f.contains(">")) continue;
                    String fieldName = f.substring(f.lastIndexOf(":") + 1);
                    fieldName = fieldName.replace("|", "");
                    String val = (String)o.getFieldvalues().get(f);
                    String fieldName2 = f.replace("|", "");
                    String vType = this.inferSort(typeInfMap, fieldName2);
                    this.rflCreator.addSort(vType);
                    LOGGER.debug("Added sort (init fields): {}", (Object)vType);
                    val = this.translateValueExpression(val);
                    String rcObjType = this.getSafeType(o.getSort());
                    assignments.add(new Assignment(new RefEx(rcObjType, receiverObject, vType, fieldName), "(" + vType + ")" + val));
                    if (!this.junitFormat || !this.isInPrestate(prestate, o)) continue;
                    if (!vType.equals("int") && !vType.equals("boolean") && this.isInPrestate(prestate, val) && !val.equals("null")) {
                        val = this.getPreName(val);
                    }
                    assignments.add(new Assignment(new RefEx(rcObjType, this.getPreName(receiverObject), vType, fieldName), "(" + vType + ")" + val));
                }
                if (o.getSort() == null || !o.getSort().name().toString().endsWith("[]")) continue;
                String safeType = this.getSafeType(o.getSort());
                String elementType = safeType.substring(0, safeType.length() - 2);
                this.rflCreator.addSort(safeType);
                LOGGER.debug("Added sort (init array fields): {}", (Object)safeType);
                for (int i = 0; i < o.getLength(); ++i) {
                    String fieldName = "[" + i + "]";
                    String val = o.getArrayValue(i);
                    val = this.translateValueExpression(val);
                    assignments.add(new Assignment(receiverObject + fieldName, val));
                    if (!this.junitFormat || !this.isInPrestate(prestate, o)) continue;
                    if (!elementType.equals("int") && !elementType.equals("boolean") && this.isInPrestate(prestate, val) && !val.equals("null")) {
                        val = this.getPreName(val);
                    }
                    assignments.add(new Assignment(this.getPreName(receiverObject) + fieldName, val));
                }
            }
        }
        StringBuilder result = new StringBuilder();
        for (Assignment a : assignments) {
            result.append(NEW_LINE).append(TAB);
            result.append(a.toString(this.useRFL));
        }
        if (this.junitFormat) {
            result.append(NEW_LINE);
            result.append(this.createOldMap(objects)).append(NEW_LINE);
            result.append(this.createBoolSet()).append(NEW_LINE);
            result.append(this.createIntSet()).append(NEW_LINE);
            result.append(this.createObjSet((Heap)heap)).append(NEW_LINE);
        }
        return result.toString();
    }

    private String createOldMap(Set<String> objNames) {
        StringBuilder result = new StringBuilder(NEW_LINE + "   Map<Object,Object> old = new HashMap<Object,Object>();");
        for (String o : objNames) {
            result.append(NEW_LINE).append(TAB).append(OLDMap).append(".put(").append(this.getPreName(o)).append(",").append(o).append(");");
        }
        return result.toString();
    }

    private String getPreName(String val) {
        return "_pre" + val;
    }

    private String createObjectName(ObjectVal o) {
        return o.getName().replace("#", "_");
    }

    private String getDummyClassNameFor(Sort sort) {
        JavaInfo jinfo = this.services.getJavaInfo();
        KeYJavaType kjt = jinfo.getKeYJavaType(sort);
        return kjt.getName() + "DummyImpl";
    }

    private String getFilePrefix(String className, String packageName) {
        String res = "/** This is a test driver generated by KeY " + KeYConstants.VERSION + " (www.key-project.org). " + NEW_LINE + " * Possible use cases:" + NEW_LINE + " *  Use Case 1. Using JUnit 4:" + NEW_LINE + " *        javac -cp .:PATH_TO_JUNIT4_JAR *.java" + NEW_LINE + " *        java  -cp .:PATH_TO_JUNIT4_JAR:PATH_TO_HAMCREST_JAR org.junit.runner.JUnitCore " + className + NEW_LINE + " *  Use Case 2. Use JML runtime checker: " + NEW_LINE + " *      Compile this file and and execute the main method with a JML runtime checker. On linux you can use the built-in scripts:" + NEW_LINE + " *        ./compileWithOpenJML.sh" + NEW_LINE + " *        ./executeWithOpenJML.sh " + className + NEW_LINE + " *  Use Case 3. Use simply a program debugger to follow and understand the execution of the program." + NEW_LINE + " * @author Christoph Gladisch" + NEW_LINE + " * @author Mihai Herda" + NEW_LINE + " */" + NEW_LINE;
        if (packageName != null) {
            res = res + "package " + packageName + ";" + NEW_LINE;
        }
        res = this.junitFormat ? res + "import java.util.Set;" + NEW_LINE + "import java.util.HashSet;" + NEW_LINE + "import java.util.Map;" + NEW_LINE + "import java.util.HashMap;" + NEW_LINE + " public class " + className + " extends junit.framework.TestCase {" + NEW_LINE + NEW_LINE + " public static junit.framework.Test suite() {    return new junit.framework.JUnit4TestAdapter(" + className + ".class);" + NEW_LINE + " } " + NEW_LINE + NEW_LINE + " public " + className + "(){}" + NEW_LINE + NEW_LINE : res + "public class " + className + "{ " + NEW_LINE + NEW_LINE + " public " + className + "(){}" + NEW_LINE;
        return res;
    }

    private StringBuilder getMainMethod(String className, int i) {
        StringBuilder res = new StringBuilder();
        res.append(" public static void  main (java.lang.String[]  arg) {").append(NEW_LINE).append(TAB).append(className).append(" testSuiteObject;").append(NEW_LINE).append("   testSuiteObject=new ").append(className).append(" ();").append(NEW_LINE).append(NEW_LINE);
        for (int j = 0; j < i; ++j) {
            res.append("   testSuiteObject.testcode").append(j).append("();").append(NEW_LINE);
        }
        if (i == 0) {
            res.append("   //Warning:no test methods were generated.").append(NEW_LINE);
        }
        res.append(" }");
        return res;
    }

    private String createBoolSet() {
        String allbool = ALL_BOOLS;
        return NEW_LINE + "   Set<Boolean> " + allbool + "= new HashSet<Boolean>();" + NEW_LINE + TAB + allbool + ".add(true);" + NEW_LINE + TAB + allbool + ".add(false);" + NEW_LINE;
    }

    private String createIntSet() {
        StringBuilder res = new StringBuilder();
        long size = ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings().getIntBound();
        long low = (long)(-Math.pow(2.0, size - 1L));
        long hi = (long)(Math.pow(2.0, size - 1L) - 1.0);
        String allint = ALL_INTS;
        res.append("   Set<Integer> ").append(allint).append("= new HashSet<Integer>();").append(NEW_LINE);
        for (long i = low; i <= hi; ++i) {
            res.append(TAB).append(allint).append(".add(").append(i).append(");").append(NEW_LINE);
        }
        return res.toString();
    }

    private String createObjSet(Heap h) {
        StringBuilder res = new StringBuilder();
        res.append("   Set<Object> allObjects= new HashSet<Object>();").append(NEW_LINE);
        for (ObjectVal o : h.getObjects()) {
            String name = o.getName();
            if (name.equals("#o0")) continue;
            name = name.replace("#", "_");
            res.append("   allObjects.add(").append(name).append(");").append(NEW_LINE);
        }
        return res.toString();
    }

    public String getSafeType(Sort sort) {
        if (sort == null || sort.name().toString().equals("Null")) {
            return "java.lang.Object";
        }
        if (sort.isAbstract()) {
            return this.buildDummyClassForAbstractSort(sort);
        }
        return sort.name().toString();
    }

    private String getTestMethodSignature(int i) {
        String sig = " public void  testcode" + i + "()";
        if (this.junitFormat) {
            return "@org.junit.Test" + NEW_LINE + sig;
        }
        return sig;
    }

    public boolean isJunit() {
        return this.junitFormat;
    }

    protected boolean isNumericType(String type) {
        return type.equals("byte") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double");
    }

    protected boolean isPrimitiveType(String type) {
        return this.isNumericType(type) || type.equals("boolean") || type.equals("char");
    }

    public void setLogger(TestGenerationLog logger) {
        this.logger = logger;
    }

    protected String translateValueExpression(String val) {
        if (val.contains("/")) {
            val = val.substring(0, val.indexOf("/"));
        }
        if (val.equals("#o0")) {
            return "null";
        }
        val = val.replace("|", "");
        val = val.replace("#", "_");
        return val;
    }

    public void writeToFile(String file, StringBuilder sb) throws IOException {
        File dir = new File(this.directory + this.modDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File pcFile = new File(dir, file);
        LOGGER.debug("Writing file: {}", (Object)pcFile);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(pcFile));){
            bw.write(sb.toString());
        }
    }

    public boolean isUseRFL() {
        return this.useRFL;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean isRflAsInternalClass() {
        return this.rflAsInternalClass;
    }
}

