/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.testgen.oracle;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.ldt.LocSetLDT;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.testgen.oracle.OracleGenerator;
import de.uka.ilkd.key.testgen.oracle.OracleLocation;
import de.uka.ilkd.key.testgen.oracle.OracleLocationSet;

public class ModifiesSetTranslator {
    private Services services;
    private OracleGenerator gen;

    public boolean isSingleTon(Term t) {
        return t.op().equals(this.getLocSetLDT().getSingleton());
    }

    public boolean isUnion(Term t) {
        return t.op().equals(this.getLocSetLDT().getUnion());
    }

    public boolean isIntersection(Term t) {
        return t.op().equals(this.getLocSetLDT().getIntersect());
    }

    public boolean isAllFields(Term t) {
        return t.op().equals(this.getLocSetLDT().getAllFields());
    }

    public boolean isAllLocs(Term t) {
        return t.op().equals(this.getLocSetLDT().getAllLocs());
    }

    public boolean isEmpty(Term t) {
        return t.op().equals(this.getLocSetLDT().getEmpty());
    }

    private LocSetLDT getLocSetLDT() {
        return this.services.getTypeConverter().getLocSetLDT();
    }

    public ModifiesSetTranslator(Services services, OracleGenerator gen) {
        this.services = services;
        this.gen = gen;
    }

    public OracleLocationSet translate(Term t) {
        if (this.isSingleTon(t)) {
            Term obj = t.sub(0);
            Term field = t.sub(1);
            String objString = this.gen.generateOracle(obj, false).toString();
            String fieldString = this.gen.generateOracle(field, false).toString();
            OracleLocation loc = new OracleLocation(objString, fieldString);
            return OracleLocationSet.singleton(loc);
        }
        if (this.isUnion(t)) {
            OracleLocationSet left = this.translate(t.sub(0));
            OracleLocationSet right = this.translate(t.sub(1));
            return OracleLocationSet.union(left, right);
        }
        if (this.isIntersection(t)) {
            OracleLocationSet left = this.translate(t.sub(0));
            OracleLocationSet right = this.translate(t.sub(1));
            return OracleLocationSet.intersect(left, right);
        }
        if (this.isAllFields(t)) {
            Term obj = t.sub(0);
            String objString = this.gen.generateOracle(obj, false).toString();
            OracleLocation loc = new OracleLocation(objString);
            return OracleLocationSet.singleton(loc);
        }
        if (this.isEmpty(t)) {
            return OracleLocationSet.EMPTY;
        }
        if (this.isAllLocs(t)) {
            return OracleLocationSet.ALL_LOCS;
        }
        throw new RuntimeException("Unsupported locset operation: " + t.op());
    }
}

