/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.testgen.oracle;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.Equality;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IObserverFunction;
import de.uka.ilkd.key.logic.op.IfThenElse;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.ProgramMethod;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.op.QuantifiableVariable;
import de.uka.ilkd.key.logic.op.Quantifier;
import de.uka.ilkd.key.logic.op.SortDependingFunction;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.logic.sort.SortImpl;
import de.uka.ilkd.key.smt.NumberTranslation;
import de.uka.ilkd.key.testgen.ReflectionClassCreator;
import de.uka.ilkd.key.testgen.oracle.ModifiesSetTranslator;
import de.uka.ilkd.key.testgen.oracle.OracleBinTerm;
import de.uka.ilkd.key.testgen.oracle.OracleConstant;
import de.uka.ilkd.key.testgen.oracle.OracleInvariantTranslator;
import de.uka.ilkd.key.testgen.oracle.OracleLocationSet;
import de.uka.ilkd.key.testgen.oracle.OracleMethod;
import de.uka.ilkd.key.testgen.oracle.OracleMethodCall;
import de.uka.ilkd.key.testgen.oracle.OracleTerm;
import de.uka.ilkd.key.testgen.oracle.OracleType;
import de.uka.ilkd.key.testgen.oracle.OracleUnaryTerm;
import de.uka.ilkd.key.testgen.oracle.OracleVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.key_project.util.collection.ImmutableArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleGenerator.class);
    private static final String OR = "||";
    private static final String AND = "&&";
    private static final String EQUALS = "==";
    private final Services services;
    private static int varNum;
    private HashMap<Operator, String> ops;
    private final Set<OracleMethod> oracleMethods;
    private final List<OracleVariable> quantifiedVariables;
    private Set<String> truePredicates;
    private Set<String> falsePredicates;
    private final Set<String> prestateTerms;
    private final Map<Sort, OracleMethod> invariants;
    private List<OracleVariable> methodArgs;
    private Set<Term> constants;
    private final ReflectionClassCreator rflCreator;
    private final boolean useRFL;
    public static final String PRE_STRING = "_pre";

    public OracleGenerator(Services services, ReflectionClassCreator rflCreator, boolean useRFL) {
        this.services = services;
        this.initOps();
        this.oracleMethods = new HashSet<OracleMethod>();
        this.quantifiedVariables = new LinkedList<OracleVariable>();
        this.prestateTerms = new HashSet<String>();
        this.invariants = new HashMap<Sort, OracleMethod>();
        this.rflCreator = rflCreator;
        this.useRFL = useRFL;
        this.initTrue();
        this.initFalse();
        this.methodArgs = null;
    }

    private void initTrue() {
        this.truePredicates = new HashSet<String>();
        this.truePredicates.add("inByte");
        this.truePredicates.add("inChar");
        this.truePredicates.add("inShort");
        this.truePredicates.add("inInt");
        this.truePredicates.add("inLong");
    }

    private void initFalse() {
        this.falsePredicates = new HashSet<String>();
    }

    private void initOps() {
        this.ops = new HashMap();
        this.ops.put((Operator)Equality.EQV, EQUALS);
        this.ops.put((Operator)Equality.EQUALS, EQUALS);
        this.ops.put((Operator)Junctor.AND, AND);
        this.ops.put((Operator)Junctor.OR, OR);
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getLessOrEquals(), "<=");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getLessThan(), "<");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getGreaterOrEquals(), ">=");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getGreaterThan(), ">");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getAdd(), "+");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getArithJavaIntAddition(), "+");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getSub(), "-");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getJavaSubInt(), "-");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getMul(), "*");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getJavaMulInt(), "*");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getDiv(), "/");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getJavaDivInt(), "/");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getMod(), "%");
        this.ops.put((Operator)this.services.getTypeConverter().getIntegerLDT().getJavaMod(), "%");
    }

    public OracleMethod generateOracleMethod(Term term) {
        this.constants = this.getConstants(term);
        this.methodArgs = this.getMethodArgs(term);
        OracleTerm body = this.generateOracle(term, false);
        return new OracleMethod("testOracle", this.methodArgs, "return " + body.toString() + ";");
    }

    public OracleLocationSet getOracleLocationSet(Term modifierset) {
        ModifiesSetTranslator mst = new ModifiesSetTranslator(this.services, this);
        return mst.translate(modifierset);
    }

    public List<OracleVariable> getMethodArgs() {
        return this.methodArgs;
    }

    public Set<OracleMethod> getOracleMethods() {
        return this.oracleMethods;
    }

    private boolean isRelevantConstant(Term c) {
        Operator op = c.op();
        if (this.isTrueConstant(op) || this.isFalseConstant(op)) {
            return false;
        }
        Sort s = c.sort();
        Sort nullSort = this.services.getJavaInfo().getNullType().getSort();
        Sort objSort = this.services.getJavaInfo().getJavaLangObject().getSort();
        Sort intSort = this.services.getTypeConverter().getIntegerLDT().targetSort();
        Sort boolSort = this.services.getTypeConverter().getBooleanLDT().targetSort();
        if (s.equals(nullSort)) {
            return false;
        }
        return s.extendsTrans(objSort) || s.equals(intSort) || s.equals(boolSort);
    }

    private Set<Term> getConstants(Term t) {
        HashSet<Term> result = new HashSet<Term>();
        HashSet<Term> temp = new HashSet<Term>();
        this.findConstants(temp, t);
        for (Term c : temp) {
            if (!this.isRelevantConstant(c)) continue;
            result.add(c);
        }
        return result;
    }

    public Set<Term> getConstants() {
        return this.constants;
    }

    private List<OracleVariable> getMethodArgs(Term t) {
        LinkedList<OracleVariable> result = new LinkedList<OracleVariable>();
        Sort allIntSort = this.createSetSort("Integer");
        Sort allBoolSort = this.createSetSort("Boolean");
        Sort allObjSort = this.createSetSort("java.lang.Object");
        SortImpl oldMapSort = new SortImpl(new Name("Map<Object,Object>"));
        OracleVariable allInts = new OracleVariable("allInts", allIntSort);
        OracleVariable allBools = new OracleVariable("allBools", allBoolSort);
        OracleVariable allObj = new OracleVariable("allObjects", allObjSort);
        OracleVariable oldMap = new OracleVariable("old", (Sort)oldMapSort);
        for (Term c : this.constants) {
            result.add(new OracleVariable(c.toString(), c.sort()));
            result.add(new OracleVariable(PRE_STRING + c, c.sort()));
        }
        result.add(allBools);
        result.add(allInts);
        result.add(allObj);
        result.add(oldMap);
        return result;
    }

    private void findConstants(Set<Term> constants, Term term) {
        LOGGER.debug("FindConstants: {} cls {} ", (Object)term, (Object)term.getClass().getName());
        if (term.op() instanceof Function && term.arity() == 0) {
            constants.add(term);
        }
        if (term.op() instanceof ProgramVariable) {
            constants.add(term);
        }
        for (Term sub : term.subs()) {
            this.findConstants(constants, sub);
        }
    }

    private Sort createSetSort(String inner) {
        String name = "Set<" + inner + ">";
        return new SortImpl(new Name(name));
    }

    public OracleTerm generateOracle(Term term, boolean initialSelect) {
        Operator op = term.op();
        LOGGER.debug("Translate: {} init: {}", (Object)term, (Object)initialSelect);
        if (this.ops.containsKey(op)) {
            String javaOp;
            OracleTerm left = this.generateOracle(term.sub(0), initialSelect);
            OracleTerm right = this.generateOracle(term.sub(1), initialSelect);
            switch (javaOp = this.ops.get(op)) {
                case "==": {
                    return OracleGenerator.eq(left, right);
                }
                case "&&": {
                    return OracleGenerator.and(left, right);
                }
                case "||": {
                    return OracleGenerator.or(left, right);
                }
            }
            return new OracleBinTerm(javaOp, left, right);
        }
        if (op == Junctor.NOT) {
            OracleTerm sub = this.generateOracle(term.sub(0), initialSelect);
            if (sub instanceof OracleUnaryTerm) {
                OracleUnaryTerm neg = (OracleUnaryTerm)sub;
                return neg.getSub();
            }
            return new OracleUnaryTerm(sub, OracleUnaryTerm.Op.Neg);
        }
        if (op == Junctor.TRUE) {
            return OracleConstant.TRUE;
        }
        if (op == Junctor.FALSE) {
            return OracleConstant.FALSE;
        }
        if (op == Junctor.IMP) {
            OracleTerm left = this.generateOracle(term.sub(0), initialSelect);
            OracleTerm right = this.generateOracle(term.sub(1), initialSelect);
            OracleTerm notLeft = OracleGenerator.neg(left);
            return new OracleBinTerm(OR, notLeft, right);
        }
        if (op instanceof QuantifiableVariable) {
            QuantifiableVariable qop = (QuantifiableVariable)op;
            return new OracleVariable(qop.name().toString(), qop.sort());
        }
        if (op == this.services.getTypeConverter().getIntegerLDT().getNumberSymbol()) {
            long num = NumberTranslation.translate((Term)term.sub(0)).longValue();
            return new OracleConstant(Long.toString(num), term.sort());
        }
        if (op == Quantifier.ALL || op == Quantifier.EX) {
            Sort field = this.services.getTypeConverter().getHeapLDT().getFieldSort();
            Sort heap = this.services.getTypeConverter().getHeapLDT().targetSort();
            Sort varSort = ((QuantifiableVariable)term.boundVars().get(0)).sort();
            if (varSort.equals(field) || varSort.equals(heap)) {
                return OracleConstant.TRUE;
            }
            OracleMethod method = this.createQuantifierMethod(term, initialSelect);
            this.oracleMethods.add(method);
            LinkedList<OracleVariable> args = new LinkedList<OracleVariable>();
            args.addAll(this.quantifiedVariables);
            args.addAll(this.methodArgs);
            return new OracleMethodCall(method, args);
        }
        if (op == IfThenElse.IF_THEN_ELSE) {
            OracleMethod method = this.createIfThenElseMethod(term, initialSelect);
            this.oracleMethods.add(method);
            LinkedList<OracleVariable> args = new LinkedList<OracleVariable>();
            args.addAll(this.quantifiedVariables);
            args.addAll(this.methodArgs);
            return new OracleMethodCall(method, args);
        }
        if (op instanceof Function) {
            return this.translateFunction(term, initialSelect);
        }
        if (op instanceof ProgramVariable) {
            ProgramVariable var = (ProgramVariable)op;
            return new OracleConstant(var.name().toString(), var.sort());
        }
        LOGGER.debug("Could not translate: {}", (Object)term);
        throw new RuntimeException("Could not translate oracle for: " + term + " of type " + term.op());
    }

    private OracleTerm translateFunction(Term term, boolean initialSelect) {
        Operator op = term.op();
        Function fun = (Function)op;
        String name = fun.name().toString();
        if (this.isTrueConstant(op)) {
            return OracleConstant.TRUE;
        }
        if (this.isFalseConstant(op)) {
            return OracleConstant.FALSE;
        }
        if (this.truePredicates.contains(name)) {
            return OracleConstant.TRUE;
        }
        if (this.falsePredicates.contains(name)) {
            return OracleConstant.FALSE;
        }
        if (term.arity() == 0) {
            return new OracleConstant(name, term.sort());
        }
        if (name.endsWith("select")) {
            return this.translateSelect(term, initialSelect);
        }
        if (name.equals("arr")) {
            OracleTerm index = this.generateOracle(term.sub(0), initialSelect);
            return new OracleConstant("[" + index + "]", term.sort());
        }
        if (name.equals("length")) {
            OracleTerm o = this.generateOracle(term.sub(0), initialSelect);
            return new OracleConstant(o + ".length", term.sort());
        }
        if (name.endsWith("::<inv>")) {
            if (fun instanceof IObserverFunction) {
                OracleMethod m;
                IObserverFunction obs = (IObserverFunction)fun;
                Sort s = obs.getContainerType().getSort();
                if (this.invariants.containsKey(s)) {
                    m = this.invariants.get(s);
                } else {
                    m = this.createDummyInvariant(s);
                    this.invariants.put(s, m);
                    m = this.createInvariantMethod(s, initialSelect);
                    this.invariants.put(s, m);
                    this.oracleMethods.add(m);
                }
                Term heap = term.sub(0);
                OracleTerm heapTerm = this.generateOracle(heap, initialSelect);
                Term object = term.sub(1);
                OracleTerm objTerm = this.generateOracle(object, initialSelect);
                if (this.isPreHeap(heapTerm) && !objTerm.toString().startsWith(PRE_STRING)) {
                    this.prestateTerms.add(objTerm.toString());
                    objTerm = new OracleConstant(PRE_STRING + object, object.sort());
                }
                LinkedList<OracleTerm> args = new LinkedList<OracleTerm>();
                args.add(objTerm);
                args.addAll(this.quantifiedVariables);
                args.addAll(this.methodArgs);
                return new OracleMethodCall(m, args);
            }
        } else if (name.endsWith("::instance")) {
            if (fun instanceof SortDependingFunction) {
                SortDependingFunction sdf = (SortDependingFunction)fun;
                Sort s = sdf.getSortDependingOn();
                OracleTerm arg = this.generateOracle(term.sub(0), initialSelect);
                OracleType type = new OracleType(s);
                return new OracleBinTerm("instanceof", arg, type);
            }
        } else {
            if (op instanceof ProgramMethod) {
                return this.translateQuery(term, initialSelect, op);
            }
            if (name.equals("javaUnaryMinusInt")) {
                OracleTerm sub = this.generateOracle(term.sub(0), initialSelect);
                return new OracleUnaryTerm(sub, OracleUnaryTerm.Op.Minus);
            }
        }
        throw new RuntimeException("Unsupported function found: " + name + " of type " + fun.getClass().getName());
    }

    private OracleTerm translateQuery(Term term, boolean initialSelect, Operator op) {
        int i;
        ProgramMethod pm = (ProgramMethod)op;
        OracleMethod m = this.createDummyOracleMethod(pm);
        LinkedList<OracleTerm> params = new LinkedList<OracleTerm>();
        int n = i = pm.isStatic() ? 1 : 2;
        while (i < term.subs().size()) {
            OracleTerm param = this.generateOracle((Term)term.subs().get(i), initialSelect);
            params.add(param);
            ++i;
        }
        LOGGER.info("pm= {}", (Object)pm.name());
        for (i = 0; i < term.arity(); ++i) {
            LOGGER.info("(i={}): {}", (Object)i, (Object)term.sub(i));
        }
        if (pm.isStatic()) {
            LOGGER.info(" isstatic ");
            return new OracleMethodCall(m, params);
        }
        OracleTerm caller = this.generateOracle(term.sub(1), false);
        LOGGER.info(" non-static caller= {}", (Object)caller);
        return new OracleMethodCall(m, params, caller);
    }

    private OracleMethod createDummyOracleMethod(ProgramMethod pm) {
        String methodName;
        String body = "";
        if (pm.isStatic()) {
            methodName = pm.name().toString();
            methodName = methodName.replace("::", ".");
        } else {
            methodName = pm.getName();
        }
        Sort returnType = pm.getReturnType().getSort();
        LinkedList<OracleVariable> args = new LinkedList<OracleVariable>();
        for (int i = 2; i < pm.argSorts().size(); ++i) {
            OracleVariable var = new OracleVariable("a" + i, (Sort)pm.argSorts().get(i));
            args.add(var);
        }
        return new OracleMethod(methodName, args, body, returnType);
    }

    private OracleTerm translateSelect(Term term, boolean initialSelect) {
        Term heap = term.sub(0);
        OracleTerm heapTerm = this.generateOracle(heap, true);
        Term object = term.sub(1);
        OracleTerm objTerm = this.generateOracle(object, true);
        Term field = term.sub(2);
        OracleTerm fldTerm = this.generateOracle(field, true);
        String fieldName = fldTerm.toString();
        fieldName = fieldName.substring(fieldName.lastIndexOf(":") + 1);
        fieldName = fieldName.replace("$", "");
        String value = this.createLocationString(heapTerm, objTerm, fieldName, object.sort(), term.sort(), initialSelect);
        if (!initialSelect && this.isPreHeap(heapTerm) && term.sort().extendsTrans(this.services.getJavaInfo().getJavaLangObject().getSort())) {
            return new OracleConstant("old.get(" + value + ")", term.sort());
        }
        return new OracleConstant(value, term.sort());
    }

    private String createLocationString(OracleTerm heapTerm, OracleTerm objTerm, String fieldName, Sort objSort, Sort fieldSort, boolean initialSelect) {
        String value;
        Object objString = objTerm.toString();
        if (this.isPreHeap(heapTerm)) {
            if (this.useRFL) {
                if (!((String)objString).startsWith("RFL")) {
                    objString = PRE_STRING + (String)objString;
                }
            } else if (initialSelect) {
                objString = PRE_STRING + (String)objString;
            }
        }
        if (fieldName.startsWith("[")) {
            value = (String)objString + fieldName;
        } else if (this.useRFL) {
            this.rflCreator.addSort(objSort);
            this.rflCreator.addSort(objSort);
            value = "RFL._get_" + ReflectionClassCreator.cleanTypeName(fieldSort.toString()) + "(" + objSort + ".class, " + (String)objString + ", \"" + fieldName + "\")";
        } else {
            value = (String)objString + "." + fieldName;
        }
        return value;
    }

    private boolean isPreHeap(OracleTerm heapTerm) {
        return heapTerm.toString().equals("heapAtPre");
    }

    private boolean isTrueConstant(Operator o) {
        return o.equals(this.services.getTypeConverter().getBooleanLDT().getTrueConst());
    }

    private boolean isFalseConstant(Operator o) {
        return o.equals(this.services.getTypeConverter().getBooleanLDT().getFalseConst());
    }

    public static String generateMethodName() {
        return "sub" + ++varNum;
    }

    private String getSortInvName(Sort s) {
        String sortName = s.name().toString();
        sortName = sortName.replace(".", "");
        return "inv_" + sortName;
    }

    private OracleMethod createDummyInvariant(Sort s) {
        String methodName = this.getSortInvName(s);
        LinkedList<OracleVariable> args = new LinkedList<OracleVariable>();
        OracleVariable o = new OracleVariable("o", s);
        args.add(o);
        args.addAll(this.methodArgs);
        String body = "return true;";
        return new OracleMethod(methodName, args, body);
    }

    private OracleMethod createInvariantMethod(Sort s, boolean initialSelect) {
        String methodName = this.getSortInvName(s);
        LinkedList<OracleVariable> args = new LinkedList<OracleVariable>();
        OracleVariable o = new OracleVariable("o", s);
        args.add(o);
        args.addAll(this.methodArgs);
        OracleInvariantTranslator oit = new OracleInvariantTranslator(this.services);
        Term t = oit.getInvariantTerm(s);
        OracleTerm invTerm = this.generateOracle(t, initialSelect);
        String body = "return " + invTerm.toString() + ";";
        return new OracleMethod(methodName, args, body);
    }

    private OracleMethod createIfThenElseMethod(Term term, boolean initialSelect) {
        String methodName = OracleGenerator.generateMethodName();
        LinkedList<OracleVariable> args = new LinkedList<OracleVariable>();
        args.addAll(this.methodArgs);
        OracleTerm cond = this.generateOracle(term.sub(0), initialSelect);
        OracleTerm trueCase = this.generateOracle(term.sub(1), initialSelect);
        OracleTerm falseCase = this.generateOracle(term.sub(2), initialSelect);
        String body = "if(" + cond + "){\n   return " + trueCase + ";\n}else{\n   return " + falseCase + ";\n}";
        return new OracleMethod(methodName, args, body, term.sort());
    }

    public Set<String> getPrestateTerms() {
        return this.prestateTerms;
    }

    private String getSetName(Sort s) {
        if (s.equals(Sort.FORMULA)) {
            return "allBools";
        }
        if (s.equals(this.services.getTypeConverter().getIntegerLDT().targetSort())) {
            return "allInts";
        }
        if (s.equals(this.services.getTypeConverter().getLocSetLDT().targetSort())) {
            throw new RuntimeException("Not implemented yet.");
        }
        if (s.equals(this.services.getTypeConverter().getHeapLDT().getFieldSort())) {
            throw new RuntimeException("Not implemented yet.");
        }
        if (s.equals(this.services.getTypeConverter().getHeapLDT().targetSort())) {
            throw new RuntimeException("Not implemented yet.");
        }
        if (s.equals(this.services.getTypeConverter().getSeqLDT().targetSort())) {
            throw new RuntimeException("Not implemented yet.");
        }
        return "allObjects";
    }

    private OracleMethod createQuantifierMethod(Term term, boolean initialSelect) {
        String body;
        String methodName = OracleGenerator.generateMethodName();
        ImmutableArray vars = term.varsBoundHere(0);
        QuantifiableVariable qv = (QuantifiableVariable)vars.get(0);
        OracleVariable var = new OracleVariable(qv.name().toString(), qv.sort());
        String setName = this.getSetName(qv.sort());
        this.quantifiedVariables.add(var);
        OracleTerm sub = this.generateOracle(term.sub(0), initialSelect);
        this.quantifiedVariables.remove(var);
        OracleUnaryTerm neg = new OracleUnaryTerm(sub, OracleUnaryTerm.Op.Neg);
        if (term.op() == Quantifier.ALL) {
            body = this.createForallBody(qv, setName, neg);
        } else if (term.op() == Quantifier.EX) {
            body = this.createExistsBody(qv, setName, sub);
        } else {
            throw new RuntimeException("This is not a quantifier: " + term);
        }
        LinkedList<OracleVariable> args = new LinkedList<OracleVariable>();
        args.addAll(this.quantifiedVariables);
        args.addAll(this.methodArgs);
        return new OracleMethod(methodName, args, body);
    }

    private String createForallBody(QuantifiableVariable qv, String setName, OracleUnaryTerm neg) {
        String tab = "   ";
        return "\n" + tab + "for(" + qv.sort().name() + " " + qv.name() + " : " + setName + "){\n" + tab + tab + "if(" + neg.toString() + "){\n" + tab + tab + tab + "return false;\n" + tab + tab + "}\n" + tab + "}\n" + tab + "return true;";
    }

    private String createExistsBody(QuantifiableVariable qv, String setName, OracleTerm cond) {
        String tab = "   ";
        return "\n" + tab + "for(" + qv.sort().name() + " " + qv.name() + " : " + setName + "){\n" + tab + tab + "if(" + cond.toString() + "){\n" + tab + tab + tab + "return true;\n" + tab + tab + "}\n" + tab + "}\n" + tab + "return false;";
    }

    private static OracleTerm neg(OracleTerm t) {
        if (t instanceof OracleUnaryTerm) {
            return ((OracleUnaryTerm)t).getSub();
        }
        return new OracleUnaryTerm(t, OracleUnaryTerm.Op.Neg);
    }

    private static OracleTerm eq(OracleTerm left, OracleTerm right) {
        if (left.equals(OracleConstant.TRUE)) {
            return right;
        }
        if (left.equals(OracleConstant.FALSE)) {
            return OracleGenerator.neg(right);
        }
        if (right.equals(OracleConstant.TRUE)) {
            return left;
        }
        if (right.equals(OracleConstant.FALSE)) {
            return OracleGenerator.neg(left);
        }
        return new OracleBinTerm(EQUALS, left, right);
    }

    private static OracleTerm and(OracleTerm left, OracleTerm right) {
        if (left.equals(OracleConstant.TRUE)) {
            return right;
        }
        if (left.equals(OracleConstant.FALSE)) {
            return OracleConstant.FALSE;
        }
        if (right.equals(OracleConstant.TRUE)) {
            return left;
        }
        if (right.equals(OracleConstant.FALSE)) {
            return OracleConstant.FALSE;
        }
        return new OracleBinTerm(AND, left, right);
    }

    private static OracleTerm or(OracleTerm left, OracleTerm right) {
        if (left.equals(OracleConstant.TRUE)) {
            return OracleConstant.TRUE;
        }
        if (left.equals(OracleConstant.FALSE)) {
            return right;
        }
        if (right.equals(OracleConstant.TRUE)) {
            return OracleConstant.TRUE;
        }
        if (right.equals(OracleConstant.FALSE)) {
            return left;
        }
        return new OracleBinTerm(OR, left, right);
    }
}

