/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.testgen.oracle;

import de.uka.ilkd.key.testgen.oracle.AllLocsLocationSet;
import de.uka.ilkd.key.testgen.oracle.EmptyOracleLocationSet;
import de.uka.ilkd.key.testgen.oracle.OracleLocation;
import java.util.HashSet;
import java.util.Set;

public class OracleLocationSet {
    private Set<OracleLocation> locs = new HashSet<OracleLocation>();
    public static final EmptyOracleLocationSet EMPTY = new EmptyOracleLocationSet();
    public static final AllLocsLocationSet ALL_LOCS = new AllLocsLocationSet();

    private void add(OracleLocation loc) {
        this.locs.add(loc);
    }

    private void add(OracleLocationSet loc) {
        this.locs.addAll(loc.locs);
    }

    public static OracleLocationSet singleton(OracleLocation loc) {
        OracleLocationSet result = new OracleLocationSet();
        result.add(loc);
        return result;
    }

    public static OracleLocationSet union(OracleLocationSet l1, OracleLocationSet l2) {
        if (l1 == ALL_LOCS || l2 == ALL_LOCS) {
            return ALL_LOCS;
        }
        if (l1 == EMPTY) {
            return l2;
        }
        if (l2 == EMPTY) {
            return l1;
        }
        OracleLocationSet result = new OracleLocationSet();
        result.add(l1);
        result.add(l2);
        return result;
    }

    public static OracleLocationSet intersect(OracleLocationSet l1, OracleLocationSet l2) {
        if (l1 == EMPTY || l2 == EMPTY) {
            return EMPTY;
        }
        if (l1 == ALL_LOCS) {
            return l2;
        }
        if (l2 == ALL_LOCS) {
            return l1;
        }
        OracleLocationSet result = new OracleLocationSet();
        for (OracleLocation l : l1.locs) {
            if (!l2.contains(l)) continue;
            result.add(l);
        }
        for (OracleLocation l : l2.locs) {
            if (!l1.contains(l)) continue;
            result.add(l);
        }
        return result;
    }

    public boolean contains(OracleLocation l) {
        for (OracleLocation loc : this.locs) {
            if (loc.equals(l)) {
                return true;
            }
            if (!loc.isAllFields() || !loc.getObject().equals(l.getObject())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this == EMPTY) {
            return "Empty";
        }
        if (this == ALL_LOCS) {
            return "All";
        }
        Object result = "";
        result = (String)result + "{";
        for (OracleLocation loc : this.locs) {
            result = (String)result + loc + " ";
        }
        result = (String)result + "}";
        return result;
    }
}

