/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.testgen.oracle;

import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.testgen.oracle.OracleVariable;
import java.util.List;

public class OracleMethod {
    private final String methodName;
    private final List<OracleVariable> args;
    private final String body;
    private Sort returnType;

    public OracleMethod(String methodName, List<OracleVariable> args, String body) {
        this.methodName = methodName;
        this.args = args;
        this.body = body;
    }

    public OracleMethod(String methodName, List<OracleVariable> args, String body, Sort sort) {
        this.methodName = methodName;
        this.args = args;
        this.body = body;
        this.returnType = sort;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<OracleVariable> getArgs() {
        return this.args;
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        String tab = "   ";
        StringBuilder argString = new StringBuilder();
        for (OracleVariable var : this.args) {
            argString.append(var.getSort().name()).append(" ").append(var.getName()).append(",");
        }
        if (!this.args.isEmpty()) {
            argString = new StringBuilder(argString.substring(0, argString.length() - 1));
        }
        String retType = "boolean";
        if (this.returnType != null) {
            retType = this.returnType.name().toString();
        }
        return tab + "public " + retType + " " + this.methodName + "(" + argString + "){\n" + tab + tab + this.body + "\n" + tab + "}";
    }
}

