/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import de.uka.ilkd.key.util.removegenerics.ResolveGenerics;
import de.uka.ilkd.key.util.removegenerics.SingleLineCommentRepairer;
import de.uka.ilkd.key.util.removegenerics.monitor.GenericRemoverMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ParserException;
import recoder.io.PathList;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;

public abstract class AbstractGenericRemover {
    private final GenericRemoverMonitor monitor;
    private final CrossReferenceServiceConfiguration sc = new CrossReferenceServiceConfiguration();
    private final Map<CompilationUnit, String> allUnits = new LinkedHashMap<CompilationUnit, String>();
    private final List<String> sourceFiles = new ArrayList<String>();

    public AbstractGenericRemover(GenericRemoverMonitor monitor) {
        assert (monitor != null);
        this.monitor = monitor;
    }

    public void addSearchPath(String path) {
        PathList searchPaths = this.sc.getProjectSettings().getSearchPathList();
        searchPaths.add(path);
    }

    public void addSourceFiles(Collection<String> sourceFiles) {
        sourceFiles.addAll(sourceFiles);
    }

    public void addSourceFile(String file) {
        this.sourceFiles.add(file);
    }

    public PathList getSearchPath() {
        return this.sc.getProjectSettings().getSearchPathList();
    }

    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public void removeGenerics() throws ParserException, IOException {
        for (String fileName : this.sourceFiles) {
            File file = new File(fileName);
            if (file.isDirectory()) {
                this.processDirectory(file);
                continue;
            }
            this.processFile(file);
        }
        ArrayList<ResolveGenerics> allTransformations = new ArrayList<ResolveGenerics>();
        this.monitor.taskStarted("Analysing ...");
        this.sc.getChangeHistory().updateModel();
        for (CompilationUnit cu : this.allUnits.keySet()) {
            ResolveGenerics transformation = new ResolveGenerics(this.sc, cu);
            transformation.analyze();
            allTransformations.add(transformation);
        }
        this.monitor.taskStarted("Transformation ...");
        for (ResolveGenerics transformation : allTransformations) {
            transformation.transform();
            CompilationUnit cu = transformation.getCU();
            SingleLineCommentRepairer.repairSingleLineComments((ProgramElement)cu);
            String filename = this.allUnits.get(cu);
            this.saveModifiedCompilationUnit(cu, filename);
        }
        this.monitor.taskStarted("Remove Generics completed.");
    }

    protected abstract void saveModifiedCompilationUnit(CompilationUnit var1, String var2) throws IOException;

    private void processDirectory(File dir) throws ParserException {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.processDirectory(f);
                continue;
            }
            if (!f.getName().toLowerCase().endsWith(".java")) continue;
            this.processFile(f);
        }
    }

    private void processFile(File file) throws ParserException {
        this.monitor.taskStarted("Reading from " + file);
        if (!file.exists()) {
            this.monitor.warningOccurred(file + " does not exist");
            return;
        }
        if (!file.canRead()) {
            this.monitor.warningOccurred(file + " cannot be read");
            return;
        }
        CompilationUnit cu = this.sc.getSourceFileRepository().getCompilationUnitFromFile(file.getPath());
        String filename = file.getName();
        this.allUnits.put(cu, filename);
    }
}

