/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import recoder.CrossReferenceServiceConfiguration;
import recoder.NamedModelElement;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.java.NamedProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.kit.TwoPassTransformation;

public class GenericResolutionTransformation
extends TwoPassTransformation {
    public static boolean DEBUG_OUTPUT = Boolean.getBoolean("resolvegen.verbose");
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericResolutionTransformation.class);

    public GenericResolutionTransformation() {
    }

    public GenericResolutionTransformation(CrossReferenceServiceConfiguration sc) {
        super(sc);
    }

    protected Type targetType(Type t) {
        int dimension = 0;
        boolean changed = false;
        Type origType = t;
        while (t instanceof ArrayType) {
            t = ((ArrayType)t).getBaseType();
            ++dimension;
        }
        if (t instanceof ParameterizedType) {
            t = ((ParameterizedType)t).getGenericType();
            changed = true;
        }
        while (t instanceof TypeParameter) {
            changed = true;
            TypeParameter typeParameter = (TypeParameter)t;
            int boundNo = typeParameter.getBoundCount();
            if (boundNo == 0) {
                t = this.getNameInfo().getJavaLangObject();
                if (t != null) continue;
                throw new IllegalStateException("java.lang.Object not known");
            }
            String bound = typeParameter.getBoundName(0);
            if (typeParameter instanceof TypeParameterDeclaration) {
                TypeParameterDeclaration tdecl = (TypeParameterDeclaration)typeParameter;
                t = this.getSourceInfo().getType(bound, (ProgramElement)tdecl);
                continue;
            }
            t = this.getNameInfo().getType(bound);
        }
        if (changed) {
            if (dimension > 0) {
                t = this.getNameInfo().createArrayType(t, dimension);
            }
            return t;
        }
        return origType;
    }

    public static void debugOut(String msg, Object ... arg) {
        if (DEBUG_OUTPUT) {
            StringBuilder args = new StringBuilder();
            if (arg.length > 0) {
                args.append(":");
                for (int i = 1; i < arg.length; ++i) {
                    args.append("; ").append(GenericResolutionTransformation.toString(arg[i]));
                }
            }
            LOGGER.debug(msg + args);
        }
    }

    public static String toString(Object object) {
        if (object instanceof MethodDeclaration) {
            MethodDeclaration md = (MethodDeclaration)object;
            return md.getFullName() + GenericResolutionTransformation.toString(md.getSignature());
        }
        if (object instanceof NamedModelElement) {
            NamedModelElement ne = (NamedModelElement)object;
            String name = ne.getName();
            if (object instanceof NamedProgramElement) {
                NonTerminalProgramElement parent = ((NamedProgramElement)ne).getASTParent();
                if (parent instanceof NamedModelElement) {
                    NamedModelElement p = (NamedModelElement)parent;
                    return p.getName() + "::" + name;
                }
            } else {
                return name;
            }
        }
        if (object instanceof Collection) {
            StringBuilder ret = new StringBuilder("[ ");
            Collection coll = (Collection)object;
            for (Object o : coll) {
                ret.append(GenericResolutionTransformation.toString(o)).append(" ");
            }
            return ret + "]";
        }
        if (object == null) {
            return "(null)";
        }
        return object.toString();
    }
}

