/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import de.uka.ilkd.key.util.removegenerics.GenericRemover;
import de.uka.ilkd.key.util.removegenerics.GenericResolutionTransformation;
import de.uka.ilkd.key.util.removegenerics.monitor.ConsoleGenericRemoverMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Version - 071019 - 1546");
        if (args.length == 0) {
            Main.usage();
        }
        GenericRemover remover = new GenericRemover(new ConsoleGenericRemoverMonitor());
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].equals("-d")) {
                    remover.setOutDir(new File(args[++i].trim()));
                    continue;
                }
                if (args[i].equals("-classpath") || args[i].equals("-cp")) {
                    for (String s : args[++i].split(File.pathSeparator)) {
                        remover.addSearchPath(s);
                    }
                    continue;
                }
                if (args[i].startsWith("@")) {
                    List<String> files = Main.addLinesFromFile(args[i].substring(1));
                    remover.addSourceFiles(files);
                    continue;
                }
                if (args[i].equals("-v")) {
                    GenericResolutionTransformation.DEBUG_OUTPUT = true;
                    continue;
                }
                remover.addSourceFile(args[i]);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("Argument " + args[i - 1] + " needs a parameter");
            }
        }
        if (!remover.getOutDir().exists()) {
            System.err.println("The output directory does not exist");
            System.exit(1);
        }
        remover.removeGenerics();
    }

    private static void usage() {
        System.out.println("This program can be used to transform a Java program with generics into one without.");
        System.out.println();
        System.out.println("The following arguments are supported");
        System.out.println("   -cp or -classpath ");
        System.out.println("     Set a location to look for .java or .class files");
        System.out.println("   -d");
        System.out.println("     Set the output directory. Files will be placed according to their package");
        System.out.println("   -v");
        System.out.println("     be verbose with the output. lots of internal information will pop up.");
        System.out.println("   <file-name>");
        System.out.println("     add a .java-source file to examine");
        System.out.println("   <directory-name>");
        System.out.println("     add a directory to examine. every .java within the named directory tree will be considered");
        System.out.println("   @filename");
        System.out.println("     take every line of the file filename and add it as a file to consider");
        System.out.println("   <jar-file-name>");
        System.out.println("     add a jar-file to examine. every .java file within the jar-repository will be considered");
        System.out.println();
        System.exit(0);
    }

    private static List<String> addLinesFromFile(String file) throws IOException {
        LinkedList<String> files = new LinkedList<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            files.add(line);
        }
        br.close();
        return files;
    }
}

