/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import de.uka.ilkd.key.util.removegenerics.ResolveMemberReference;
import de.uka.ilkd.key.util.removegenerics.ResolveMethodDeclaration;
import de.uka.ilkd.key.util.removegenerics.ResolveTypeDeclaration;
import de.uka.ilkd.key.util.removegenerics.ResolveTypeReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.NameReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;

public class ResolveGenerics
extends TwoPassTransformation {
    private CompilationUnit compUnitUnderTest;
    private List<TwoPassTransformation> transformations;

    public ResolveGenerics(CrossReferenceServiceConfiguration sc, CompilationUnit cu) {
        super(sc);
        this.compUnitUnderTest = cu;
    }

    public ProblemReport analyze() {
        TreeWalker tw = new TreeWalker((ProgramElement)this.compUnitUnderTest);
        this.transformations = new LinkedList<TwoPassTransformation>();
        while (tw.next()) {
            ProgramElement pe = tw.getProgramElement();
            if (pe instanceof ClassDeclaration) {
                this.transformations.add(new ResolveTypeDeclaration((ClassDeclaration)pe, this.getServiceConfiguration()));
                continue;
            }
            if (pe instanceof InterfaceDeclaration) {
                this.transformations.add(new ResolveTypeDeclaration((InterfaceDeclaration)pe, this.getServiceConfiguration()));
                continue;
            }
            if (pe instanceof MethodDeclaration) {
                this.transformations.add(new ResolveMethodDeclaration((MethodDeclaration)pe, this.getServiceConfiguration()));
                continue;
            }
            if (pe instanceof MethodReference) {
                this.transformations.add(new ResolveMemberReference((NameReference)((MethodReference)pe), this.getServiceConfiguration()));
                continue;
            }
            if (pe instanceof FieldReference) {
                this.transformations.add(new ResolveMemberReference((NameReference)((FieldReference)pe), this.getServiceConfiguration()));
                continue;
            }
            if (pe instanceof VariableReference) {
                this.transformations.add(new ResolveMemberReference((NameReference)((VariableReference)pe), this.getServiceConfiguration()));
                continue;
            }
            if (!(pe instanceof TypeReference)) continue;
            this.transformations.add(new ResolveTypeReference((TypeReference)pe, this.getServiceConfiguration()));
        }
        Iterator<TwoPassTransformation> it = this.transformations.iterator();
        while (it.hasNext()) {
            TwoPassTransformation tpt = it.next();
            if (tpt.analyze() != IDENTITY) continue;
            it.remove();
        }
        Collections.reverse(this.transformations);
        if (this.transformations.isEmpty()) {
            return IDENTITY;
        }
        return EQUIVALENCE;
    }

    public void transform() {
        for (TwoPassTransformation tpt : this.transformations) {
            tpt.transform();
        }
    }

    public CompilationUnit getCU() {
        return this.compUnitUnderTest;
    }
}

