/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import de.uka.ilkd.key.util.removegenerics.GenericResolutionTransformation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.SingleLineComment;
import recoder.java.StatementBlock;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.expression.operator.TypeCast;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.kit.ProblemReport;
import recoder.kit.TypeKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.SourceInfo;

class ResolveTypeDeclaration
extends GenericResolutionTransformation {
    private final TypeDeclaration declaration;
    private final List<MethodDeclaration> methodsToAdd = new ArrayList<MethodDeclaration>();
    private final List<List<Type>> signaturesToAdd = new ArrayList<List<Type>>();

    public ResolveTypeDeclaration(ClassDeclaration declaration, CrossReferenceServiceConfiguration sc) {
        super(sc);
        this.declaration = declaration;
    }

    public ResolveTypeDeclaration(InterfaceDeclaration declaration, CrossReferenceServiceConfiguration sc) {
        super(sc);
        this.declaration = declaration;
    }

    public ProblemReport analyze() {
        ASTList typeParameters = this.declaration.getTypeParameters();
        if (typeParameters == null || typeParameters.isEmpty()) {
            this.setProblemReport((ProblemReport)IDENTITY);
        } else {
            this.setProblemReport((ProblemReport)EQUIVALENCE);
        }
        this.analyseMethods();
        return this.getProblemReport();
    }

    void analyseMethods() {
        for (Method method : this.declaration.getMethods()) {
            List signature = method.getSignature();
            List<Method> superMethods = this.getOverriddenMethods(method);
            List<Type> ungenericSignature = this.getUngenericSignature(signature);
            if (method.isStatic()) continue;
            ResolveTypeDeclaration.debugOut("---", new Object[0]);
            ResolveTypeDeclaration.debugOut("Method", method);
            ResolveTypeDeclaration.debugOut("Type", signature);
            ResolveTypeDeclaration.debugOut("ungeneric Type", ungenericSignature);
            ResolveTypeDeclaration.debugOut("superMethods", superMethods);
            for (Method superMethod : superMethods) {
                List<Type> ungenericSuperSignature = this.getUngenericSignature(superMethod.getSignature());
                boolean isStatic = superMethod.isStatic();
                boolean differentSigs = !ungenericSuperSignature.equals(ungenericSignature);
                boolean alreadyPresent = this.methodAlreadyPresent(method.getName(), ungenericSuperSignature);
                if (isStatic || !differentSigs || alreadyPresent) continue;
                this.setProblemReport((ProblemReport)EQUIVALENCE);
                this.addMethod(method, ungenericSignature, ungenericSuperSignature);
            }
        }
    }

    private boolean methodAlreadyPresent(String name, List<Type> signature) {
        for (Method m : this.getSourceInfo().getAllMethods((ClassType)this.declaration)) {
            List mdSig = m.getSignature();
            if (!m.getName().equals(name) || !signature.equals(mdSig)) continue;
            return true;
        }
        int i = 0;
        for (MethodDeclaration md : this.methodsToAdd) {
            List<Type> mdSig = this.signaturesToAdd.get(i++);
            if (!md.getName().equals(name) || !signature.equals(mdSig)) continue;
            return true;
        }
        return false;
    }

    private void addMethod(Method origMethod, List<Type> localSign, List<Type> superSig) {
        ProgramFactory programFactory = this.getProgramFactory();
        assert (!origMethod.isStatic());
        Type returnType = this.targetType(origMethod.getReturnType());
        String name = origMethod.getName();
        ASTList<DeclarationSpecifier> prefix = this.getDeclarationSpecifiers(origMethod);
        ArrayList<ClassType> exceptions = new ArrayList<ClassType>(origMethod.getExceptions());
        Throws aThrows = this.createThrows(exceptions);
        TypeReference returnTypeRef = returnType != null ? TypeKit.createTypeReference((ProgramFactory)programFactory, (Type)returnType) : TypeKit.createTypeReference((ProgramFactory)programFactory, (String)"void");
        Identifier methodName = programFactory.createIdentifier(name);
        ASTArrayList parameters = new ASTArrayList();
        int counter = 1;
        for (Type type : superSig) {
            TypeReference typeRef = TypeKit.createTypeReference((ProgramFactory)programFactory, (Type)type);
            Identifier param = programFactory.createIdentifier("arg" + counter);
            parameters.add((Object)programFactory.createParameterDeclaration(typeRef, param));
            ++counter;
        }
        MethodDeclaration methodDecl = programFactory.createMethodDeclaration(prefix, returnTypeRef, methodName, (ASTList)parameters, aThrows);
        counter = 1;
        ASTArrayList args = new ASTArrayList(localSign.size());
        for (Type type : localSign) {
            Identifier id = programFactory.createIdentifier("arg" + counter);
            VariableReference varRef = programFactory.createVariableReference(id);
            TypeReference tyRef = TypeKit.createTypeReference((ProgramFactory)programFactory, (Type)type);
            TypeCast cast = programFactory.createTypeCast((Expression)varRef, tyRef);
            args.add((Object)cast);
            ++counter;
        }
        MethodReference methodCall = programFactory.createMethodReference((ReferencePrefix)programFactory.createThisReference(), methodName.deepClone(), (ASTList)args);
        ASTArrayList stm = new ASTArrayList(1);
        if (returnType != null) {
            stm.add((Object)programFactory.createReturn((Expression)methodCall));
        } else {
            stm.add((Object)methodCall);
        }
        StatementBlock block = programFactory.createStatementBlock((ASTList)stm);
        methodDecl.setBody(block);
        methodDecl.setComments((ASTList)new ASTArrayList());
        SingleLineComment slc = this.getProgramFactory().createSingleLineComment("//--- This method has been created due to generics removal");
        slc.setPrefixed(true);
        methodDecl.getComments().add((Object)slc);
        methodDecl.makeAllParentRolesValid();
        this.methodsToAdd.add(methodDecl);
        this.signaturesToAdd.add(superSig);
        ResolveTypeDeclaration.debugOut("Method added", methodDecl.toSource());
    }

    private ASTList<DeclarationSpecifier> getDeclarationSpecifiers(Method origMethod) {
        ASTArrayList ret = new ASTArrayList();
        ProgramFactory programFactory = this.getProgramFactory();
        if (origMethod.isFinal()) {
            ret.add((Object)programFactory.createFinal());
        }
        if (origMethod.isPrivate()) {
            ret.add((Object)programFactory.createPrivate());
        }
        if (origMethod.isProtected()) {
            ret.add((Object)programFactory.createProtected());
        }
        if (origMethod.isPublic()) {
            ret.add((Object)programFactory.createPublic());
        }
        if (origMethod.isFinal()) {
            ret.add((Object)programFactory.createFinal());
        }
        return ret;
    }

    private Throws createThrows(List<ClassType> exceptions) {
        if (exceptions == null || exceptions.isEmpty()) {
            return null;
        }
        ASTArrayList tr = new ASTArrayList(exceptions.size());
        for (ClassType exc : exceptions) {
            tr.add((Object)TypeKit.createTypeReference((ProgramFactory)this.getProgramFactory(), (Type)exc));
        }
        return this.getProgramFactory().createThrows((ASTList)tr);
    }

    private List<Type> getUngenericSignature(List<Type> signature) {
        ArrayList<Type> newSignature = new ArrayList<Type>(signature.size());
        for (Type type : signature) {
            newSignature.add(this.targetType(type));
        }
        return newSignature;
    }

    private List<Method> getOverriddenMethods(Method method) {
        SourceInfo sourceInfo = this.getSourceInfo();
        ClassType classType = sourceInfo.getContainingClassType((Member)method);
        List signature = method.getSignature();
        String name = method.getName();
        LinkedList<Method> superMethods = new LinkedList<Method>();
        for (ClassType superType : sourceInfo.getSupertypes(classType)) {
            List matchingMethods = sourceInfo.getMethods(superType, name, signature, null, classType);
            if (matchingMethods.size() != 1) continue;
            Method match = (Method)matchingMethods.get(0);
            superMethods.add(match);
        }
        return superMethods;
    }

    public void transform() {
        if (this.declaration instanceof ClassDeclaration) {
            ((ClassDeclaration)this.declaration).setTypeParameters(null);
        } else {
            ((InterfaceDeclaration)this.declaration).setTypeParameters(null);
        }
        for (MethodDeclaration methodDecl : this.methodsToAdd) {
            this.attach((MemberDeclaration)methodDecl, this.declaration, 0);
        }
    }
}

