/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import de.uka.ilkd.key.util.removegenerics.GenericResolutionTransformation;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.Type;
import recoder.java.ProgramElement;
import recoder.java.reference.TypeReference;
import recoder.kit.ProblemReport;
import recoder.kit.TypeKit;
import recoder.list.generic.ASTList;
import recoder.service.CrossReferenceSourceInfo;

public class ResolveTypeReference
extends GenericResolutionTransformation {
    private TypeReference reference;
    private TypeReference replaceWith;
    private CrossReferenceSourceInfo sourceInfo;

    public ResolveTypeReference(TypeReference reference, CrossReferenceServiceConfiguration sc) {
        super(sc);
        this.reference = reference;
        this.sourceInfo = sc.getCrossReferenceSourceInfo();
    }

    public ProblemReport analyze() {
        ASTList typeArguments = this.reference.getTypeArguments();
        if (typeArguments != null && !typeArguments.isEmpty()) {
            return EQUIVALENCE;
        }
        Type type = this.sourceInfo.getType(this.reference);
        Type replaceType = this.targetType(type);
        if (replaceType != null && !replaceType.equals(type)) {
            this.replaceWith = TypeKit.createTypeReference((ProgramFactory)this.getProgramFactory(), (Type)replaceType);
            return EQUIVALENCE;
        }
        return IDENTITY;
    }

    public void transform() {
        if (this.replaceWith != null) {
            this.replace((ProgramElement)this.reference, (ProgramElement)this.replaceWith);
        } else {
            this.reference.setTypeArguments(null);
        }
    }
}

