/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.testgen;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.core.InterruptListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.smt.SolverListener;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.proof.SingleProof;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.mgt.SpecificationRepository;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.smt.SolverLauncherListener;
import de.uka.ilkd.key.smt.counterexample.AbstractCounterExampleGenerator;
import de.uka.ilkd.key.smt.counterexample.AbstractSideProofCounterExampleGenerator;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.SwingWorker;

public class CounterExampleAction
extends MainWindowAction {
    private static final long serialVersionUID = -1931682474791981751L;
    private static final String NAME = "Search for Counterexample";
    private static final String TOOLTIP = "Search for a counterexample for the selected goal";

    public CounterExampleAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName(NAME);
        this.setTooltip(TOOLTIP);
        Icon icon = IconFactory.counterExample((int)16);
        this.putValue("SmallIcon", icon);
        this.setMenuPath("Proof");
        this.init();
        this.lookupAcceleratorKey();
    }

    public void init() {
        final KeYSelectionListener selListener = new KeYSelectionListener(){

            public void selectedNodeChanged(KeYSelectionEvent e) {
                Proof proof = CounterExampleAction.this.getMediator().getSelectedProof();
                if (proof == null) {
                    CounterExampleAction.this.setEnabled(false);
                } else {
                    Node selNode = CounterExampleAction.this.getMediator().getSelectedNode();
                    CounterExampleAction.this.setEnabled(selNode.childrenCount() == 0 && !selNode.isClosed());
                }
            }

            public void selectedProofChanged(KeYSelectionEvent e) {
                this.selectedNodeChanged(e);
            }
        };
        this.getMediator().addKeYSelectionListener(selListener);
        this.getMediator().getUI().getProofControl().addAutoModeListener(new AutoModeListener(){

            public void autoModeStarted(ProofEvent e) {
                CounterExampleAction.this.getMediator().removeKeYSelectionListener(selListener);
                CounterExampleAction.this.setEnabled(false);
            }

            public void autoModeStopped(ProofEvent e) {
                CounterExampleAction.this.getMediator().addKeYSelectionListener(selListener);
                selListener.selectedNodeChanged(null);
            }
        });
        selListener.selectedNodeChanged(new KeYSelectionEvent(this.getMediator().getSelectionModel()));
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Goal goal = this.getMediator().getSelectedGoal();
            Node node = goal.node();
            Proof oldProof = node.proof();
            Sequent oldSequent = node.sequent();
            this.getMediator().stopInterface(true);
            this.getMediator().setInteractive(false);
            CEWorker worker = new CEWorker(oldProof, oldSequent);
            this.getMediator().addInterruptedListener((InterruptListener)worker);
            worker.execute();
        }
        catch (Exception exc) {
            IssueDialog.showExceptionDialog((Window)this.mainWindow, (Throwable)exc);
        }
    }

    private class CEWorker
    extends SwingWorker<Void, Void>
    implements InterruptListener {
        private final Proof oldProof;
        private final Sequent oldSequent;

        public CEWorker(Proof oldProof, Sequent oldSequent) {
            this.oldProof = oldProof;
            this.oldSequent = oldSequent;
        }

        @Override
        protected Void doInBackground() throws Exception {
            NoMainWindowCounterExampleGenerator generator = new NoMainWindowCounterExampleGenerator();
            generator.searchCounterExample((UserInterfaceControl)CounterExampleAction.this.getMediator().getUI(), this.oldProof, this.oldSequent);
            return null;
        }

        public void interruptionPerformed() {
            this.cancel(true);
        }

        @Override
        protected void done() {
            CounterExampleAction.this.getMediator().setInteractive(true);
            CounterExampleAction.this.getMediator().startInterface(true);
            CounterExampleAction.this.getMediator().removeInterruptedListener((InterruptListener)this);
        }
    }

    public static class MainWindowCounterExampleGenerator
    extends AbstractCounterExampleGenerator {
        private final KeYMediator mediator;

        public MainWindowCounterExampleGenerator(KeYMediator mediator) {
            this.mediator = mediator;
        }

        protected Proof createProof(UserInterfaceControl ui, Proof oldProof, Sequent oldSequent, String proofName) {
            Sequent newSequent = this.createNewSequent(oldSequent);
            InitConfig newInitConfig = oldProof.getInitConfig().deepCopy();
            Proof proof = new Proof(proofName, newSequent, "", newInitConfig.createTacletIndex(), newInitConfig.createBuiltInRuleIndex(), newInitConfig);
            proof.setEnv(oldProof.getEnv());
            proof.setNamespaces(oldProof.getNamespaces());
            SingleProof pa = new SingleProof(proof, "XXX");
            ui.registerProofAggregate((ProofAggregate)pa);
            SpecificationRepository spec = proof.getServices().getSpecificationRepository();
            spec.registerProof(spec.getProofOblInput(oldProof), proof);
            this.mediator.goalChosen(proof.getGoal(proof.root()));
            return proof;
        }

        protected void semanticsBlastingCompleted(UserInterfaceControl ui) {
            this.mediator.setInteractive(true);
            this.mediator.startInterface(true);
        }

        protected SolverLauncherListener createSolverListener(DefaultSMTSettings settings, Proof proof) {
            return new SolverListener(settings, proof);
        }
    }

    public static class NoMainWindowCounterExampleGenerator
    extends AbstractSideProofCounterExampleGenerator {
        protected SolverLauncherListener createSolverListener(DefaultSMTSettings settings, Proof proof) {
            return new SolverListener(settings, proof);
        }
    }
}

