/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.testgen;

import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.SingleProof;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.SpecificationRepository;
import de.uka.ilkd.key.smt.testgen.AbstractTestGenerator;
import java.util.List;

class MainWindowTestGenerator
extends AbstractTestGenerator {
    private final boolean showInMainWindow;
    private final KeYMediator mediator;

    public MainWindowTestGenerator(KeYMediator mediator, Proof originalProof, boolean showInMainWindow) {
        super((UserInterfaceControl)mediator.getUI(), originalProof);
        this.mediator = mediator;
        this.showInMainWindow = showInMainWindow;
    }

    public void dispose() {
        if (this.showInMainWindow) {
            List proofs = this.getProofs();
            if (proofs == null) {
                return;
            }
            for (Proof p : proofs) {
                if (!MainWindow.getInstance().getProofList().containsProof(p)) continue;
                p.dispose();
            }
            this.mediator.setProof(super.getOriginalProof());
        } else {
            super.dispose();
        }
    }

    protected Proof createProof(UserInterfaceControl ui, Proof oldProof, String newName, Sequent newSequent) throws ProofInputException {
        if (this.showInMainWindow) {
            InitConfig initConfig = oldProof.getInitConfig().deepCopy();
            Proof proof = new Proof(newName, newSequent, "", initConfig.createTacletIndex(), initConfig.createBuiltInRuleIndex(), initConfig.deepCopy());
            proof.setEnv(oldProof.getEnv());
            proof.setNamespaces(oldProof.getNamespaces());
            Services services = this.mediator.getServices();
            SpecificationRepository spec = services.getSpecificationRepository();
            spec.registerProof(spec.getProofOblInput(oldProof), proof);
            SingleProof pa = new SingleProof(proof, "XXX");
            ui.registerProofAggregate((ProofAggregate)pa);
            return proof;
        }
        return super.createProof(ui, oldProof, newName, newSequent);
    }

    protected void handleAllProofsPerformed(UserInterfaceControl ui) {
        this.mediator.setInteractive(true);
        this.mediator.startInterface(true);
    }

    protected void selectProof(UserInterfaceControl ui, Proof proof) {
        if (this.showInMainWindow) {
            this.mediator.setProof(proof);
        }
    }
}

