/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.testgen;

import de.uka.ilkd.key.core.InterruptListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.testgen.TGWorker;
import de.uka.ilkd.key.gui.testgen.TestgenOptionsPanel;
import de.uka.ilkd.key.smt.testgen.TestGenerationLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class TGInfoDialog
extends JDialog {
    private final JTextArea textArea;
    private final JButton stopButton;
    private final JButton exitButton;
    private final JButton startButton;
    private transient TGWorker worker;
    private final KeyAction actionStop = new KeyAction(){
        {
            this.setName("Stop");
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.getInstance().getMediator().getUI().getProofControl().stopAndWaitAutoMode();
            TGInfoDialog.this.exitButton.setEnabled(true);
        }
    };
    private final AbstractAction actionExit = new KeyAction(){
        {
            this.setName("Exit");
        }

        public void actionPerformed(ActionEvent e) {
            TGInfoDialog.this.dispose();
        }
    };
    private final KeyAction actionStart = new KeyAction(){
        {
            this.setName("Start");
        }

        public void actionPerformed(ActionEvent e) {
            KeYMediator mediator = MainWindow.getInstance().getMediator();
            mediator.stopInterface(true);
            mediator.setInteractive(false);
            TGInfoDialog.this.worker = new TGWorker(TGInfoDialog.this);
            mediator.addInterruptedListener((InterruptListener)TGInfoDialog.this.worker);
            TGInfoDialog.this.worker.execute();
        }
    };
    private final TestGenerationLog logger = new TestGenerationLog(){

        public void write(String t) {
            TGInfoDialog.this.textArea.append(t);
        }

        public void writeln(String line) {
            TGInfoDialog.this.textArea.append(line + "\n");
        }

        public void writeException(Throwable t) {
            t.printStackTrace();
            TGInfoDialog.this.textArea.append("Error: " + t.getMessage());
        }

        public void testGenerationCompleted() {
            TGInfoDialog.this.exitButton.setEnabled(true);
        }
    };

    public TGInfoDialog(Window owner) {
        super(owner);
        this.textArea = new JTextArea();
        this.stopButton = new JButton((Action)this.actionStop);
        this.exitButton = new JButton(this.actionExit);
        this.startButton = new JButton((Action)this.actionStart);
        this.setModal(false);
        this.setTitle("Test Suite Generation");
        this.setSize(1000, 700);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo((Component)MainWindow.getInstance());
        this.setLayout(new BorderLayout());
        JScrollPane scrollpane = new JScrollPane(this.textArea);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        JPanel flowPanel = new JPanel(new FlowLayout());
        scrollpane.setHorizontalScrollBarPolicy(30);
        scrollpane.setVerticalScrollBarPolicy(22);
        caret.setUpdatePolicy(2);
        this.exitButton.setEnabled(false);
        flowPanel.add(this.startButton);
        flowPanel.add(this.stopButton);
        flowPanel.add(this.exitButton);
        this.add((Component)scrollpane, "Center");
        this.add((Component)flowPanel, "South");
        this.add((Component)((Object)new TestgenOptionsPanel()), "East");
    }

    public KeyAction getActionStop() {
        return this.actionStop;
    }

    public AbstractAction getActionExit() {
        return this.actionExit;
    }

    public KeyAction getActionStart() {
        return this.actionStart;
    }

    public TestGenerationLog getLogger() {
        return this.logger;
    }
}

