/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.testgen;

import de.uka.ilkd.key.core.InterruptListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.nodeviews.SequentViewInputListener;
import de.uka.ilkd.key.gui.testgen.MainWindowTestGenerator;
import de.uka.ilkd.key.gui.testgen.TGInfoDialog;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.smt.testgen.StopRequest;
import javax.swing.SwingWorker;

public class TGWorker
extends SwingWorker<Void, Void>
implements InterruptListener,
StopRequest {
    private final TGInfoDialog tgInfoDialog;
    private boolean stop;
    private final MainWindowTestGenerator testGenerator;
    private Proof originalProof;

    public TGWorker(TGInfoDialog tgInfoDialog) {
        this.tgInfoDialog = tgInfoDialog;
        this.originalProof = this.getMediator().getSelectedProof();
        this.testGenerator = new MainWindowTestGenerator(this.getMediator(), this.originalProof, false);
    }

    @Override
    public Void doInBackground() {
        this.getMediator().setInteractive(false);
        this.getMediator().startInterface(false);
        SequentViewInputListener.setRefresh((boolean)false);
        this.testGenerator.generateTestCases(this, this.tgInfoDialog.getLogger());
        return null;
    }

    @Override
    public void done() {
        this.getMediator().setInteractive(true);
        this.getMediator().startInterface(true);
        this.getMediator().removeInterruptedListener((InterruptListener)this);
        SequentViewInputListener.setRefresh((boolean)true);
        this.originalProof = null;
    }

    public void interruptionPerformed() {
        this.cancel(true);
        this.tgInfoDialog.getLogger().writeln("\nStopping test case generation.");
        this.stop = true;
        this.testGenerator.stopSMTLauncher();
    }

    private KeYMediator getMediator() {
        return MainWindow.getInstance().getMediator();
    }

    public Proof getOriginalProof() {
        return this.originalProof;
    }

    public boolean shouldStop() {
        return this.stop;
    }
}

